/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.beacon;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.util.Log;
import io.glimr.sdk.beacon.IBeacon;
import io.glimr.sdk.beacon.IBeaconConsumer;
import io.glimr.sdk.beacon.IBeaconManager;
import io.glimr.sdk.beacon.MonitorNotifier;
import io.glimr.sdk.beacon.RangeNotifier;
import io.glimr.sdk.beacon.Region;
import io.glimr.sdk.engine.KATRequestAdvertPayload;
import io.glimr.sdk.network.KATEndPoints;
import io.glimr.sdk.network.KATPostReqAsync;
import io.glimr.sdk.network.KATRequest;
import io.glimr.sdk.network.KATRequestDone;
import io.glimr.sdk.network.KATResponse;
import io.glimr.sdk.utils.KATSystemInformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;

public class KATBeaconManager {
    private static KATBeaconManager instance;
    private final HashMap<String, IBeacon> mEnterBeacons = new HashMap();
    private final HashMap<String, Integer> mExitBeacons = new HashMap();
    public boolean isApplicationOpen = false;
    private ArrayList<String> mBeaconTokens;
    private String apiToken;
    private IBeaconManager iBeaconManager;
    private Context context;
    private MonitorNotifier mMonitorNotifier = new MonitorNotifier(){

        @Override
        public void didEnterRegion(Region region) {
            Log.d((String)"GlimrSDK", (String)("#Beacon enter region: " + region.getProximityUuid()));
            KATBeaconManager.this.sendRegionRequestToServer(region, 0);
        }

        @Override
        public void didExitRegion(Region region) {
            Log.d((String)"GlimrSDK", (String)("#Beacon exit region: " + region.getUniqueId()));
            KATBeaconManager.this.sendRegionRequestToServer(region, 1);
        }

        @Override
        public void didDetermineStateForRegion(int state, Region region) {
            Log.d((String)"GlimrSDK", (String)("#Beacon state for region: " + region.getUniqueId()));
        }
    };
    private RangeNotifier mRangeNotifier = new RangeNotifier(){

        @Override
        public void didRangeBeaconsInRegion(Collection<IBeacon> iBeacons, Region region) {
            KATBeaconManager.this.beaconSendRequests(iBeacons, region);
        }
    };
    private IBeaconConsumer mBeaconConsumer = new IBeaconConsumer(){

        @Override
        public void onIBeaconServiceConnect() {
            KATBeaconManager.this.iBeaconManager.setMonitorNotifier(KATBeaconManager.this.mMonitorNotifier);
            KATBeaconManager.this.iBeaconManager.setRangeNotifier(KATBeaconManager.this.mRangeNotifier);
            for (String token : KATBeaconManager.this.mBeaconTokens) {
                String dashlessUuid = token.toLowerCase().replaceAll("[\\-\\s]", "");
                if (dashlessUuid.length() != 32) continue;
                try {
                    KATBeaconManager.this.iBeaconManager.startMonitoringBeaconsInRegion(new Region(token, token, null, null));
                }
                catch (RemoteException e) {
                    Log.e((String)"GlimrSDK", (String)("#Beacon beaconError: " + e.getMessage()));
                }
                try {
                    KATBeaconManager.this.iBeaconManager.startRangingBeaconsInRegion(new Region(token, token, null, null));
                }
                catch (RemoteException e) {
                    Log.e((String)"GlimrSDK", (String)("#Beacon beaconError: " + e.getMessage()));
                }
            }
        }

        @Override
        public Context getApplicationContext() {
            return KATBeaconManager.this.context.getApplicationContext();
        }

        @Override
        public void unbindService(ServiceConnection connection) {
            this.getApplicationContext().unbindService(connection);
        }

        @Override
        public boolean bindService(Intent intent, ServiceConnection connection, int mode) {
            return this.getApplicationContext().bindService(intent, connection, mode);
        }
    };

    protected KATBeaconManager(Context context) {
        this.context = context;
        this.iBeaconManager = IBeaconManager.getInstanceForApplication(context.getApplicationContext());
    }

    public static KATBeaconManager getInstance(Context context) {
        if (instance == null) {
            instance = new KATBeaconManager(context);
            KATSystemInformation.initSettings(context);
        }
        return instance;
    }

    public String getApiToken() {
        return this.apiToken;
    }

    public void setApiToken(String mApiToken) {
        this.apiToken = mApiToken;
    }

    public void stop() {
        try {
            this.iBeaconManager.stopScan();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void bindBeacons(ArrayList<String> beaconIDs, String apiToken) {
        if (KATSystemInformation.canDoBle(this.context).booleanValue() && this.context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            this.mBeaconTokens = beaconIDs;
            this.apiToken = apiToken;
            Log.d((String)"GlimrSDK", (String)"#Beacon bind");
            if (!this.iBeaconManager.isBound(this.mBeaconConsumer)) {
                this.iBeaconManager.bind(this.mBeaconConsumer);
            }
        }
    }

    public void unbindBeacons() {
        if (this.context != null && KATSystemInformation.canDoBle(this.context).booleanValue() && this.context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            PackageManager pm = this.context.getPackageManager();
            if (pm.checkPermission("android.permission.BLUETOOTH", this.context.getPackageName()) == 0 && pm.checkPermission("android.permission.BLUETOOTH_ADMIN", this.context.getPackageName()) == 0) {
                Log.d((String)"GlimrSDK", (String)"#Beacon unbind");
                if (this.iBeaconManager.isBound(this.mBeaconConsumer)) {
                    this.iBeaconManager.unBind(this.mBeaconConsumer);
                }
            } else {
                Log.d((String)"GlimrSDK", (String)"YOU NEED TO ADD BLUETOOTH AND BLUETOOTH ADMIN PERMISSION IN THE MANIFEST");
            }
        }
    }

    private void beaconSendRequests(Collection<IBeacon> iBeacons, Region region) {
        ArrayList<IBeacon> beacons = new ArrayList<IBeacon>(iBeacons);
        for (IBeacon iBeacon : beacons) {
            String key = this.keyForBeacon(iBeacon);
            if (!this.mEnterBeacons.containsKey(key)) {
                this.sendBeaconRequestToServer(iBeacon, region, 0);
                this.mEnterBeacons.put(key, iBeacon);
                Log.d((String)"GlimrSDK", (String)("#Make send " + key));
            }
            if (iBeacon.getRssi() == 0 || !this.mExitBeacons.containsKey(key)) continue;
            this.mExitBeacons.remove(key);
        }
        try {
            Object beaconId;
            for (Map.Entry<String, IBeacon> entry : this.mEnterBeacons.entrySet()) {
                beaconId = entry.getValue();
                String key = this.keyForBeacon((IBeacon)beaconId);
                boolean isActive = false;
                for (IBeacon beacon : beacons) {
                    if (!key.equalsIgnoreCase(this.keyForBeacon(beacon))) continue;
                    isActive = true;
                    break;
                }
                if (isActive || this.mExitBeacons.containsKey(key)) continue;
                this.mExitBeacons.put(key, 2);
            }
            for (Map.Entry<String, Object> entry : this.mExitBeacons.entrySet()) {
                beaconId = entry.getKey();
                int current = (Integer)entry.getValue();
                if (current >= 2) {
                    this.mExitBeacons.remove(beaconId);
                    this.mEnterBeacons.remove(beaconId);
                    continue;
                }
                if (current >= 2) continue;
                this.mExitBeacons.put((String)beaconId, current + 1);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    private String keyForBeacon(IBeacon beacon) {
        return beacon.getProximityUuid() + "-" + beacon.getMajor() + "-" + beacon.getMinor();
    }

    private void sendBeaconRequestToServer(IBeacon iBeacon, Region region, int action) {
        KATRequestAdvertPayload requestBeaconRegion = new KATRequestAdvertPayload(this.context);
        requestBeaconRegion.setAccuracy((float)iBeacon.getAccuracy());
        requestBeaconRegion.setActionType(action);
        requestBeaconRegion.setMajor(iBeacon.getMajor());
        requestBeaconRegion.setMinor(iBeacon.getMinor());
        requestBeaconRegion.setProximity(iBeacon.getProximity());
        requestBeaconRegion.setRegionId(region.getProximityUuid().toUpperCase());
        requestBeaconRegion.setRssi(iBeacon.getRssi());
        requestBeaconRegion.setState(this.isApplicationOpen ? 0 : 2);
        this.sendRequest(requestBeaconRegion);
    }

    private void sendRegionRequestToServer(Region region, int action) {
        KATRequestAdvertPayload requestBeaconRegion = new KATRequestAdvertPayload(this.context);
        requestBeaconRegion.setActionType(action);
        requestBeaconRegion.setMajor(region.getMajor() != null ? region.getMajor() : 0);
        requestBeaconRegion.setMinor(region.getMinor() != null ? region.getMinor() : 0);
        requestBeaconRegion.setRegionId(region.getProximityUuid().toUpperCase());
        requestBeaconRegion.setState(this.isApplicationOpen ? 0 : 2);
        this.sendRequest(requestBeaconRegion);
    }

    private void sendRequest(KATRequestAdvertPayload payload) {
        KATRequest requestObject = new KATRequest(payload, KATEndPoints.baseURL(this.context) + "/collect/event/", null);
        KATPostReqAsync request = new KATPostReqAsync(this.apiToken, new KATRequestDone(){

            @Override
            public void KATRequestSuccess(KATResponse response) {
            }

            @Override
            public void KATRequestFailed(int responseCode, String errorMessage) {
            }
        });
        request.execute(new KATRequest[]{requestObject});
    }
}

