/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.audience;

import android.content.Context;
import android.content.pm.PackageManager;
import android.location.Location;
import android.util.Log;
import io.glimr.sdk.audience.KATRequestConcludePayload;
import io.glimr.sdk.audience.KATUserTags;
import io.glimr.sdk.engine.KATEvent;
import io.glimr.sdk.engine.KATManager;
import io.glimr.sdk.network.KATEndPoints;
import io.glimr.sdk.network.KATPostReqAsync;
import io.glimr.sdk.network.KATRequest;
import io.glimr.sdk.network.KATRequestDone;
import io.glimr.sdk.network.KATRequestPayload;
import io.glimr.sdk.network.KATResponse;
import io.glimr.sdk.utils.KATSharedPreferences;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class KATAudienceManager {
    private String apiToken;
    private int tagCacheExpireSeconds;
    private Context context;

    public KATAudienceManager(Context context, String apiToken, int tagCacheExpireSeconds) {
        this.context = context;
        this.apiToken = apiToken;
        this.tagCacheExpireSeconds = Math.min(tagCacheExpireSeconds, 300);
    }

    private static String hashOfConcludes(Map<String, String> map) {
        String s = "";
        if (map == null || map.isEmpty()) {
            return s;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            s = s + entry.getKey() + String.valueOf(entry.getValue());
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(s.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuilder hexString = new StringBuilder();
            for (byte aMessageDigest : messageDigest) {
                hexString.append(Integer.toHexString(0xFF & aMessageDigest));
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return s;
        }
    }

    public void getAudiences(Location location, final KATEvent callback) {
        HashMap storedTags;
        if (callback == null) {
            return;
        }
        final Date now = new Date();
        long diffInMs = now.getTime() - KATSharedPreferences.getLastAudienceUpdateDate(this.context).getTime();
        if (KATManager.disableCaching) {
            Log.d((String)"GlimrSDK", (String)"#Caching disabled, please enable for production - Glimr");
        }
        if (!KATManager.disableCaching && diffInMs > 0L && TimeUnit.MILLISECONDS.toSeconds(diffInMs) < (long)this.tagCacheExpireSeconds && (storedTags = KATSharedPreferences.getAudienceResponseMap(this.context)) != null) {
            callback.availableAudiencesUpdated(storedTags);
            return;
        }
        KATRequestPayload payload = new KATRequestPayload(this.context);
        if (location != null) {
            payload.lat = location.getLatitude();
            payload.lon = location.getLongitude();
            payload.speed = Float.valueOf(location.getSpeed());
            payload.course = Float.valueOf(location.getBearing());
        }
        KATRequest requestObject = new KATRequest(payload, KATEndPoints.baseURL(this.context) + "/audience/", KATUserTags.class);
        KATPostReqAsync request = new KATPostReqAsync(this.apiToken, new KATRequestDone(){

            @Override
            public void KATRequestSuccess(KATResponse response) {
                if (response.responseObject != null && ((KATUserTags)response.responseObject).mapping != null && ((KATUserTags)response.responseObject).mapping.size() > 0) {
                    callback.availableAudiencesUpdated(((KATUserTags)response.responseObject).mapping);
                    KATSharedPreferences.setLastAudienceUpdateDate(KATAudienceManager.this.context, now);
                    KATSharedPreferences.saveAudienceResponseMap(KATAudienceManager.this.context, ((KATUserTags)response.responseObject).mapping);
                }
            }

            @Override
            public void KATRequestFailed(int responseCode, String errorMessage) {
                Log.d((String)"GlimrSDK", (String)errorMessage);
            }
        });
        request.execute(new KATRequest[]{requestObject});
    }

    public void collect(HashMap concludes, Location location) {
        try {
            KATRequestConcludePayload basePayload = new KATRequestConcludePayload(this.context);
            String storedConcludesHash = KATSharedPreferences.getConcludesHash(this.context);
            String calculatedConcludesHash = KATAudienceManager.hashOfConcludes(concludes);
            storedConcludesHash = storedConcludesHash == null ? "" : storedConcludesHash;
            calculatedConcludesHash = calculatedConcludesHash == null ? "" : calculatedConcludesHash;
            boolean hasChanged = calculatedConcludesHash.compareTo(storedConcludesHash) != 0;
            Date now = new Date();
            long diffInMs = now.getTime() - KATSharedPreferences.getLastCollectionUpdateDate(this.context).getTime();
            if (KATManager.disableCaching) {
                Log.d((String)"GlimrSDK", (String)"#Caching disabled, please enable for production - Glimr");
            }
            if (hasChanged || !KATManager.disableCaching && diffInMs > 0L && TimeUnit.MILLISECONDS.toSeconds(diffInMs) < 604800L) {
                basePayload.setConcludes(concludes);
                KATSharedPreferences.saveConcludesHash(this.context, calculatedConcludesHash);
                KATSharedPreferences.setLastCollectionUpdateDate(this.context, now);
            }
            basePayload.setUrls(KATSharedPreferences.getTrackedURLs(this.context));
            basePayload.setCollect(true);
            if (location != null) {
                basePayload.lat = location.getLatitude();
                basePayload.lon = location.getLongitude();
                basePayload.speed = Float.valueOf(location.getSpeed());
                basePayload.course = Float.valueOf(location.getBearing());
            }
            KATRequest requestObject = new KATRequest(basePayload, KATEndPoints.baseURL(this.context) + "/audience/", null);
            KATPostReqAsync request = new KATPostReqAsync(this.apiToken, null);
            request.execute(new KATRequest[]{requestObject});
        }
        catch (Exception e) {
            Log.e((String)"Error", (String)e.getMessage());
        }
    }

    public void trackURL(String url) {
        try {
            KATSharedPreferences.storeTrackedURL(this.context, url, new Date());
        }
        catch (Exception e) {
            Log.e((String)"Error", (String)e.getMessage());
        }
    }

    public boolean isPackageInstalled(String packagename, Context context) {
        PackageManager pm = context.getPackageManager();
        try {
            pm.getPackageInfo(packagename, 1);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }
}

