/**
 * Radius Networks, Inc.
 * http://www.radiusnetworks.com
 *
 * @author David G. Young
 * <p/>
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * <p/>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p/>
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package io.glimr.sdk.beacon.service;

import android.os.Parcel;
import android.os.Parcelable;

import io.glimr.sdk.beacon.Region;

public class MonitoringData implements Parcelable {
    public static final Creator<MonitoringData> CREATOR
            = new Creator<MonitoringData>() {
        public MonitoringData createFromParcel(Parcel in) {
            return new MonitoringData(in);
        }

        public MonitoringData[] newArray(int size) {
            return new MonitoringData[size];
        }
    };
    @SuppressWarnings("unused")
    private static final String TAG = "MonitoringData";
    private boolean inside;
    private RegionData regionData;

    public MonitoringData(boolean inside, Region region) {
        this.inside = inside;
        this.regionData = new RegionData(region);
    }

    private MonitoringData(Parcel in) {
        inside = in.readByte() == 1;
        regionData = in.readParcelable(this.getClass().getClassLoader());
    }

    public boolean isInside() {
        return inside;
    }

    public Region getRegion() {
        return regionData;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeByte((byte) (inside ? 1 : 0));
        out.writeParcelable(regionData, flags);

    }
}
