package io.glimr.sdk.network;

import android.Manifest;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;

import com.google.gson.annotations.SerializedName;
import io.glimr.sdk.engine.KATActionType;
import io.glimr.sdk.utils.KATSystemInformation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class KATRequestPayload {

    @SerializedName("lat")
    public Double lat;
    @SerializedName("lon")
    public Double lon;
    @SerializedName("speed")
    public Float speed;
    @SerializedName("course")
    public Float course;
    @SerializedName("collect")
    private boolean collect;
    @SerializedName("isRoaming")
    private boolean isRoaming;
    @SerializedName("batteryLevel")
    private Float batteryLevel;
    @SerializedName("locationState")
    private int locationState;
    @SerializedName("bleState")
    private int bleState;
    @SerializedName("notificationState")
    private int notificationState;
    @SerializedName("batteryState")
    private int batteryState;
    @SerializedName("carrierName")
    private String carrierName;
    @SerializedName("isoCountryCode")
    private String isoCountryCode;
    @SerializedName("mobileNetworkCode")
    private String mobileNetworkCode;
    @SerializedName("currentRadioAccessTechnology")
    private String currentRadioAccessTechnology;
    @SerializedName("ips")
    private ArrayList<HashMap<String, String>> ips;
    @SerializedName("networks")
    private ArrayList<HashMap<String, String>> networks;
    @SerializedName("advertIdEnabled")
    private boolean advertIdEnabled;
    @SerializedName("advertId")
    private String advertId;
    @SerializedName("api")
    private String api;
    @SerializedName("bundle")
    private String bundle;
    @SerializedName("sessionId")
    private String sessionId;
    @SerializedName("accuracy")
    private Float accuracy;
    @SerializedName("actionType")
    private int actionType;
    //Only for requestBeaconAdvertForBeacon
    @SerializedName("beaconId")
    private String beaconId;
    @SerializedName("device")
    private String device;
    @SerializedName("locale")
    private String locale;
    @SerializedName("major")
    private int major;
    @SerializedName("minor")
    private int minor;
    @SerializedName("proximity")
    private int proximity;
    //Only for requestBeaconAdvertForRegion
    @SerializedName("regionId")
    private String regionId;
    @SerializedName("rssi")
    private Float rssi;
    @SerializedName("state")
    private int state;
    @SerializedName("system")
    private String system;
    @SerializedName("vendorId")
    private String vendorId;
    @SerializedName("userInfo")
    private HashMap userInfo;

    public KATRequestPayload() {

    }

    public KATRequestPayload(Context context) {

        try {
            this.advertIdEnabled = KATSystemInformation.advertIdEnabled;
            this.advertId = KATSystemInformation.advertId != null ? KATSystemInformation.advertId
                    : KATSystemInformation.getDeviceId();
            this.api = KATSystemInformation.getApiVersion();
            this.bundle = context.getApplicationContext().getPackageName();
            this.sessionId = KATSystemInformation.sessionId.toString().toUpperCase();
            this.actionType = KATActionType.KATActionTypeConfig;
            this.device = KATSystemInformation.getDeviceName();
            this.locale = Locale.getDefault().toString();
            this.regionId = "";
            this.system = String.valueOf(Build.VERSION.RELEASE);
            this.vendorId = KATSystemInformation.advertId != null ? KATSystemInformation.advertId
                    : KATSystemInformation.getDeviceId();
            this.state = 0;
            this.accuracy = 0.0f;
            this.beaconId = "";
            this.major = 0;
            this.minor = 0;
            this.proximity = 0;
            this.rssi = 0.0f;
            this.notificationState = -1;
            this.lat = 0.0;
            this.lon = 0.0;
            this.speed = 0.0f;
            this.course = 0.0f;
            this.collect = false;
            this.bleState = 0;
            this.locationState = 0;

            this.bleState = KATSystemInformation.bleEnabled ? 1 : 0;
            this.locationState = KATSystemInformation.locationEnabled ? 1 : 0;

            TelephonyManager manager = (TelephonyManager) context
                    .getSystemService(Context.TELEPHONY_SERVICE);
            this.carrierName = manager.getSimOperatorName() != null ? manager.getSimOperatorName()
                    : "";
            this.isoCountryCode = manager.getSimOperator() != null ? manager.getSimOperator() : "";
            this.currentRadioAccessTechnology = manager.getNetworkType() + "";
            this.mobileNetworkCode = manager.getNetworkOperator() != null ? manager.getNetworkOperator() : "";
            this.isRoaming = manager.isNetworkRoaming();
            this.ips = KATSystemInformation.ips;

            this.networks = new ArrayList();
            int premission_wifi_service = context
                    .checkCallingOrSelfPermission(Manifest.permission.ACCESS_WIFI_STATE);
            if (premission_wifi_service == PackageManager.PERMISSION_GRANTED) {
                WifiManager wifiManager = (WifiManager) context
                        .getSystemService(Context.WIFI_SERVICE);
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                HashMap<String, String> network = new HashMap<String, String>();
                network.put("ssid", wifiInfo.getSSID());
                network.put("bssid", wifiInfo.getBSSID());
                network.put("networkId", "" + wifiInfo.getNetworkId());
                network.put("ip", "" + wifiInfo.getIpAddress());
                network.put("mac", wifiInfo.getMacAddress());
                networks.add(network);
            }

            Intent batteryIntent = context.getApplicationContext()
                    .registerReceiver(null, new IntentFilter(Intent.ACTION_BATTERY_CHANGED));
            int plugged = batteryIntent != null ? batteryIntent.getIntExtra("plugged", -1) : -1;
            int rawlevel = batteryIntent != null ? batteryIntent.getIntExtra("level", -1) : -1;
            double scale = batteryIntent != null ? batteryIntent.getIntExtra("scale", -1) : -1;
            float level = -1;
            if (rawlevel >= 0 && scale > 0) {
                level = (float) rawlevel / (float) scale;
            }

            this.batteryLevel = level;
            this.batteryState = plugged;
        } catch (Exception e) {

        }
    }

    public Double getLat() {
        return lat;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public boolean getIsRoaming() {
        return isRoaming;
    }

    public Float getSpeed() {
        return speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public Float getCourse() {
        return course;
    }

    public void setCourse(float course) {
        this.course = course;
    }

    public Double getLon() {
        return lon;
    }

    public void setLon(double lon) {
        this.lon = lon;
    }

    public boolean getCollect() {
        return collect;
    }

    public void setCollect(boolean collect) {
        this.collect = collect;
    }

    public boolean getAdvertIdEnabled() {
        return advertIdEnabled;
    }

    public int getLocationState() {
        return locationState;
    }

    public void setLocationState(int locationState) {
        this.locationState = locationState;
    }

    public int getBleState() {
        return bleState;
    }

    public void setBleState(int bleState) {
        this.bleState = bleState;
    }

    public int getNotificationState() {
        return notificationState;
    }

    public void setNotificationState(int notificationState) {
        this.notificationState = notificationState;
    }

    public String getSessionId() {
        return sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getBundle() {
        return bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getApi() {
        return api;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public String getAdvertId() {
        return advertId;
    }

    public void setAdvertId(String advertId) {
        this.advertId = advertId;
    }

    public String getVendorId() {
        return vendorId;
    }

    public void setVendorId(String vendorId) {
        this.vendorId = vendorId;
    }

    public int getActionType() {
        return actionType;
    }

    public void setActionType(int actionType) {
        this.actionType = actionType;
    }

    public String getLocale() {
        return locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getDevice() {
        return device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public String getSystem() {
        return system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public Float getRssi() {
        return rssi;
    }

    public void setRssi(Float rssi) {
        this.rssi = rssi;
    }

    public void setRssi(float rssi) {
        this.rssi = rssi;
    }

    public int getProximity() {
        return proximity;
    }

    public void setProximity(int proximity) {
        this.proximity = proximity;
    }

    public Float getAccuracy() {
        return accuracy;
    }

    public void setAccuracy(Float accuracy) {
        this.accuracy = accuracy;
    }

    public void setAccuracy(float accuracy) {
        this.accuracy = accuracy;
    }

    public int getMinor() {
        return minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getMajor() {
        return major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getState() {
        return state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getRegionId() {
        return regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getBeaconId() {
        return beaconId;
    }

    public void setBeaconId(String beaconId) {
        this.beaconId = beaconId;
    }

    public HashMap getUserInfo() {
        return userInfo;
    }

    public void setUserInfo(HashMap userInfo) {
        this.userInfo = userInfo;
    }

    public String getCarrierName() {
        return carrierName;
    }

    public void setCarrierName(String carrierName) {
        this.carrierName = carrierName;
    }

    public String getIsoCountryCode() {
        return isoCountryCode;
    }

    public void setIsoCountryCode(String isoCountryCode) {
        this.isoCountryCode = isoCountryCode;
    }

    public String getMobileNetworkCode() {
        return mobileNetworkCode;
    }

    public void setMobileNetworkCode(String mobileNetworkCode) {
        this.mobileNetworkCode = mobileNetworkCode;
    }

    public String getCurrentRadioAccessTechnology() {
        return currentRadioAccessTechnology;
    }

    public void setCurrentRadioAccessTechnology(String currentRadioAccessTechnology) {
        this.currentRadioAccessTechnology = currentRadioAccessTechnology;
    }

    public ArrayList<HashMap<String, String>> getNetworks() {
        return networks;
    }

    public void setNetworks(ArrayList<HashMap<String, String>> networks) {
        this.networks = networks;
    }

    public boolean isAdvertIdEnabled() {
        return advertIdEnabled;
    }

    public void setAdvertIdEnabled(boolean advertIdEnabled) {
        this.advertIdEnabled = advertIdEnabled;
    }

    public ArrayList<HashMap<String, String>> getIps() {
        return ips;
    }

    public void setIps(ArrayList<HashMap<String, String>> ips) {
        this.ips = ips;
    }
}
