package io.glimr.sdk.utils;


import android.Manifest;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import android.provider.Settings.SettingNotFoundException;
import android.text.TextUtils;

import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.identifier.AdvertisingIdClient.Info;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.UUID;

public class KATSystemInformation {

    public static String advertId = null;

    public static boolean advertIdEnabled = false;
    public static boolean bleEnabled = false;
    public static boolean locationEnabled = false;
    public static ArrayList ips = new ArrayList();

    public static UUID sessionId = null;
    public static String PUB_SSL_KEY = "30820122300d06092a864886f70d01010105000382010f003082010a0282010100bba3e920ec"
            + "212145e553fa1831981848e799203378c713254109d787444472f4eaae47b792c3eeb6c8fa89d7d844d944994f4c72fcd1"
            + "a3415d53af62125aba0dacfb7edc67048a16819e366162031780583fc4ee08976fa94e215828a3f801acf58c7d4d74e6eb"
            + "8950acd9b0ae347a5a1e242c11d3c57bd607e3916435c2d22e848ff610f477dc5ad40473b361d23655237382a695c9b23c"
            + "5a3fb4d6cb86e78bb12e8802dd4111e4bb6de72a1ff5d4a81db54e36d6431dbec95b5afaf1c8827444a9a62ce67dcd46d3"
            + "1e200d6bda23b8b042a2e87c4e3ebbe84afb6bc099966377089f4dfb594131eea36a5be5539f91c7d5ac87d59ef772fd4f"
            + "29313785ddc70203010001";

    public static Boolean canDoBle(final Context context) {
        String manufacturer = android.os.Build.MANUFACTURER;
        boolean ishtc = manufacturer.toLowerCase(Locale.ENGLISH).contains("htc");

        if (ishtc && Build.VERSION.SDK_INT == 23) {
            return false;
        }

        if (context == null) {
            return false;
        }

        PackageManager pm = context.getPackageManager();
        if (android.os.Build.VERSION.SDK_INT > Build.VERSION_CODES.KITKAT
                && (pm.checkPermission(Manifest.permission.BLUETOOTH, context.getPackageName()) == PackageManager.PERMISSION_GRANTED)
                && (pm.checkPermission(Manifest.permission.BLUETOOTH_ADMIN, context.getPackageName()) == PackageManager.PERMISSION_GRANTED)
                && pm.hasSystemFeature(PackageManager.FEATURE_BLUETOOTH_LE)
                ) {
            return true;
        }
        return false;
    }

    public static String getDeviceName() {
        String manufacturer = Build.MANUFACTURER;
        String model = Build.MODEL;
        if (model.startsWith(manufacturer)) {
            return capitalize(model);
        } else {
            return capitalize(manufacturer) + " " + model;
        }
    }

    public static String getDeviceId() {
        return Settings.Secure.ANDROID_ID;
    }

    public static String getApiVersion() {
        return "1.9.2";
    }

    private static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char first = s.charAt(0);
        if (Character.isUpperCase(first)) {
            return s;
        } else {
            return Character.toUpperCase(first) + s.substring(1);
        }
    }

    public static int advertIdDelay() {
        if (advertId != null) {
            return 500;
        }
        return 1000;
    }

    // Do not call this function from the main thread. Otherwise, an IllegalStateException will be thrown.
    public static void initSettings(final Context context) {
        sessionId = UUID.randomUUID();

        new Thread(new Runnable() {
            @Override
            public void run() {
                advertId = KATSharedPreferences.getAdvertId(context);
                advertIdEnabled = KATSharedPreferences.getAdvertIdEnabled(context);
                bleEnabled = KATSystemInformation.isBluetoothEnabled(context);
                locationEnabled = KATSystemInformation.isLocationEnabled(context);

                Info adInfo = null;
                try {
                    adInfo = AdvertisingIdClient.getAdvertisingIdInfo(context.getApplicationContext());
                } catch (IOException e) {
                    // Unrecoverable error connecting to Google Play services (e.g.,
                    // the old version of the service doesn't support getting AdvertisingId).
                } catch (GooglePlayServicesNotAvailableException e) {
                    // Encountered a recoverable error connecting to Google Play services.

                } catch (GooglePlayServicesRepairableException e) {
                    // Google Play services is not available entirely.
                }

                getAdIdThreadFinished(adInfo, context);
            }
        }).start();
    }

    private static void getAdIdThreadFinished(final AdvertisingIdClient.Info adInfo,
                                              Context context) {
        if (adInfo != null) {
            advertId = adInfo.getId();
            advertIdEnabled = !adInfo.isLimitAdTrackingEnabled();

            KATSharedPreferences.saveAdvertId(context, advertId);
            KATSharedPreferences.saveAdvertIdEnabled(context, advertIdEnabled);
        }
    }

    public static ArrayList refreshIPs(Context context) {
//        INFO: No use for it at the moment so let's skip
//
//        if (ips.size() > 0) {
//            ips.clear();
//        }
//
//        int premission_network_service = context
//                .checkCallingOrSelfPermission(Manifest.permission.ACCESS_NETWORK_STATE);
//        if (premission_network_service == PackageManager.PERMISSION_GRANTED) {
//            HashMap<String, String> ip = new HashMap<String, String>();
//            try {
//                for (Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
//                     en.hasMoreElements(); ) {
//                    NetworkInterface intf = en.nextElement();
//                    int x = 0;
//                    for (Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
//                         enumIpAddr.hasMoreElements(); ) {
//                        InetAddress inetAddress = enumIpAddr.nextElement();
//                        if (!inetAddress.isLoopbackAddress()) {
//                            ip.put("ip" + x, "" + inetAddress.getHostAddress());
//                            x++;
//                        }
//                    }
//                }
//            } catch (SocketException e) {
//                e.printStackTrace();
//            }
//            ips.add(ip);
//        }
        return ips;
    }

    public static boolean isBluetoothEnabled(Context context) {
        PackageManager pm = context.getPackageManager();
        if (KATSystemInformation.canDoBle(context)) {
            BluetoothAdapter btAdapter = BluetoothAdapter.getDefaultAdapter();
            if (btAdapter != null) {
                KATSystemInformation.bleEnabled = btAdapter != null && btAdapter.isEnabled()
                        && btAdapter.getState() == BluetoothAdapter.STATE_ON;
            } else {
                KATSystemInformation.bleEnabled = false;
            }
            return KATSystemInformation.bleEnabled;
        }
        KATSystemInformation.bleEnabled = false;
        return KATSystemInformation.bleEnabled;
    }

    public static boolean isLocationEnabled(Context context) {
        int locationMode = 0;
        String locationProviders;

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            try {
                locationMode = Settings.Secure.getInt(context.getContentResolver(), Settings.Secure.LOCATION_MODE);

            } catch (SettingNotFoundException e) {
                e.printStackTrace();
            }

            KATSystemInformation.locationEnabled = locationMode != Settings.Secure.LOCATION_MODE_OFF;
            return KATSystemInformation.locationEnabled;
        } else {
            locationProviders = Settings.Secure.getString(context.getContentResolver(), Settings.Secure.LOCATION_PROVIDERS_ALLOWED);
            KATSystemInformation.locationEnabled = !TextUtils.isEmpty(locationProviders);
            return KATSystemInformation.locationEnabled;
        }
    }

    public static boolean hasLocationPermission(Context context) {
        PackageManager pm = context.getPackageManager();
        return pm.checkPermission(Manifest.permission.ACCESS_FINE_LOCATION, context.getPackageName()) == PackageManager.PERMISSION_GRANTED;
    }

    public static boolean isGenerallySupported() {
        return Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1;
    }
}
