/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.geofence;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import io.glimr.sdk.engine.KATRequestAdvertPayload;
import io.glimr.sdk.network.KATEndPoints;
import io.glimr.sdk.network.KATPostReqAsync;
import io.glimr.sdk.network.KATRequest;
import io.glimr.sdk.network.KATRequestDone;
import io.glimr.sdk.network.KATResponse;
import io.glimr.sdk.utils.KATSharedPreferences;
import io.glimr.sdk.utils.KATSystemInformation;
import java.util.List;

public class KATGeofenceIntentService
extends IntentService {
    public KATGeofenceIntentService() {
        super("KATGeofenceIntentService");
    }

    protected void onHandleIntent(Intent intent) {
        GeofencingEvent geoFenceEvent = GeofencingEvent.fromIntent((Intent)intent);
        if (geoFenceEvent.hasError()) {
            int errorCode = geoFenceEvent.getErrorCode();
            String errorMessage = "CODE " + errorCode;
            Log.d((String)"GlimrSDK", (String)errorMessage);
        } else {
            int transitionType = geoFenceEvent.getGeofenceTransition();
            if (1 == transitionType || 2 == transitionType) {
                int actionType = transitionType == 1 ? 0 : 1;
                List geofences = geoFenceEvent.getTriggeringGeofences();
                Object[] geofenceIds = new String[geofences.size()];
                for (int index = 0; index < geofences.size(); ++index) {
                    geofenceIds[index] = ((Geofence)geofences.get(index)).getRequestId();
                }
                String ids = TextUtils.join((CharSequence)",", (Object[])geofenceIds);
                Log.d((String)"GlimrSDK #Trigger", (String)ids);
                this.sendRequest((String)geofenceIds[0], actionType);
            } else {
                Log.d((String)"GlimrSDK", (String)("#Tansition " + transitionType));
            }
        }
    }

    private void sendRequest(String identifier, int action) {
        KATSystemInformation.initSettings((Context)this);
        try {
            Thread.sleep(KATSystemInformation.advertIdDelay());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        KATRequestAdvertPayload payload = new KATRequestAdvertPayload((Context)this);
        payload.setActionType(action);
        payload.setRegionId(identifier);
        payload.setState(2);
        KATRequest requestObject = new KATRequest(payload, KATEndPoints.baseURL(this.getApplicationContext()) + "/collect/event/", null);
        KATPostReqAsync request = new KATPostReqAsync(KATSharedPreferences.getEntry((Context)this), new KATRequestDone(){

            @Override
            public void KATRequestSuccess(KATResponse response) {
            }

            @Override
            public void KATRequestFailed(int responseCode, String errorMessage) {
            }
        });
        request.execute(new KATRequest[]{requestObject});
    }
}

