/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.engine;

import android.annotation.SuppressLint;
import android.telephony.CellIdentityGsm;
import android.telephony.CellIdentityLte;
import android.telephony.CellInfo;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.CellSignalStrengthLte;
import android.telephony.TelephonyManager;
import java.util.ArrayList;
import java.util.List;

public class KATBaseStationServices {
    @SuppressLint(value={"NewApi"})
    public static KATBaseStationInfo getBaseStations(TelephonyManager telephonyManager) {
        ArrayList<KATWCDMABaseStationInfo> katwcdmaBaseStationInfoList = new ArrayList<KATWCDMABaseStationInfo>();
        ArrayList<KATLTEBaseStationInfo> katlteBaseStationInfoList = new ArrayList<KATLTEBaseStationInfo>();
        ArrayList<KATGSMBaseStationInfo> katgsmBaseStationInfoList = new ArrayList<KATGSMBaseStationInfo>();
        ArrayList cellInfos = telephonyManager.getAllCellInfo();
        if (cellInfos == null) {
            cellInfos = new ArrayList();
        }
        for (CellInfo cellInfo : cellInfos) {
            CellSignalStrengthLte cellSignalStrength;
            CellIdentityLte cellIdentity;
            if (cellInfo instanceof CellInfoLte) {
                cellIdentity = ((CellInfoLte)cellInfo).getCellIdentity();
                cellSignalStrength = ((CellInfoLte)cellInfo).getCellSignalStrength();
                KATLTEBaseStationInfo katlteBaseStationInfo = new KATLTEBaseStationInfo(cellIdentity.getCi(), cellIdentity.getMcc(), cellIdentity.getMnc(), cellIdentity.getPci(), cellIdentity.getTac(), cellSignalStrength.getDbm());
                katlteBaseStationInfoList.add(katlteBaseStationInfo);
                continue;
            }
            if (cellInfo instanceof CellInfoGsm) {
                CellIdentityGsm cellIdentityGsm = ((CellInfoGsm)cellInfo).getCellIdentity();
                cellSignalStrength = ((CellInfoGsm)cellInfo).getCellSignalStrength();
                KATGSMBaseStationInfo katgsmBaseStationInfo = new KATGSMBaseStationInfo(cellIdentityGsm.getCid(), cellIdentityGsm.getLac(), cellIdentityGsm.getMcc(), cellIdentityGsm.getMnc(), cellSignalStrength.getDbm());
                katgsmBaseStationInfoList.add(katgsmBaseStationInfo);
                continue;
            }
            if (!(cellInfo instanceof CellInfoWcdma)) continue;
            cellIdentity = ((CellInfoWcdma)cellInfo).getCellIdentity();
            cellSignalStrength = ((CellInfoWcdma)cellInfo).getCellSignalStrength();
            KATWCDMABaseStationInfo katwcdmaBaseStationInfo = new KATWCDMABaseStationInfo(cellIdentity.getCid(), cellIdentity.getLac(), cellIdentity.getMcc(), cellIdentity.getMnc(), cellIdentity.getPsc(), cellSignalStrength.getDbm());
            katwcdmaBaseStationInfoList.add(katwcdmaBaseStationInfo);
        }
        return new KATBaseStationInfo(katlteBaseStationInfoList, katwcdmaBaseStationInfoList, katgsmBaseStationInfoList);
    }

    public static class KATBaseStationInfo {
        private List<KATLTEBaseStationInfo> mKATLteBaseStationInfoList;
        private List<KATWCDMABaseStationInfo> mKATWCDMABaseStationInfoList;
        private List<KATGSMBaseStationInfo> mKATGSMBaseStationInfoList;

        public KATBaseStationInfo(List<KATLTEBaseStationInfo> KATLteBaseStationInfoList, List<KATWCDMABaseStationInfo> KATWCDMABaseStationInfoList, List<KATGSMBaseStationInfo> KATGSMBaseStationInfoList) {
            this.mKATLteBaseStationInfoList = KATLteBaseStationInfoList;
            this.mKATWCDMABaseStationInfoList = KATWCDMABaseStationInfoList;
            this.mKATGSMBaseStationInfoList = KATGSMBaseStationInfoList;
        }

        public List<KATLTEBaseStationInfo> getKATLTEBaseStationInfoList() {
            return this.mKATLteBaseStationInfoList;
        }

        public List<KATWCDMABaseStationInfo> getKATWCDMABaseStationInfoList() {
            return this.mKATWCDMABaseStationInfoList;
        }

        public List<KATGSMBaseStationInfo> getKATGSMBaseStationInfoList() {
            return this.mKATGSMBaseStationInfoList;
        }
    }

    public static class KATGSMBaseStationInfo {
        private int cid;
        private int lac;
        private int mcc;
        private int mnc;
        private int dbm;

        public KATGSMBaseStationInfo(int cid, int lac, int mcc, int mnc, int dbm) {
            this.cid = cid;
            this.lac = lac;
            this.mcc = mcc;
            this.mnc = mnc;
            this.dbm = dbm;
        }

        public int getCid() {
            return this.cid;
        }

        public int getLac() {
            return this.lac;
        }

        public int getMcc() {
            return this.mcc;
        }

        public int getMnc() {
            return this.mnc;
        }

        public int getDbm() {
            return this.dbm;
        }
    }

    public static class KATWCDMABaseStationInfo {
        private int cid;
        private int lac;
        private int mcc;
        private int mnc;
        private int psc;
        private int dbm;

        public KATWCDMABaseStationInfo(int cid, int lac, int mcc, int mnc, int psc, int dbm) {
            this.cid = cid;
            this.lac = lac;
            this.mcc = mcc;
            this.mnc = mnc;
            this.psc = psc;
            this.dbm = dbm;
        }

        public int getCid() {
            return this.cid;
        }

        public int getLac() {
            return this.lac;
        }

        public int getMcc() {
            return this.mcc;
        }

        public int getMnc() {
            return this.mnc;
        }

        public int getPsc() {
            return this.psc;
        }

        public int getDbm() {
            return this.dbm;
        }
    }

    public static class KATLTEBaseStationInfo {
        private int ci;
        private int mcc;
        private int mnc;
        private int pci;
        private int tac;
        private int dbm;

        public KATLTEBaseStationInfo(int ci, int mcc, int mnc, int pci, int tac, int dbm) {
            this.ci = ci;
            this.mcc = mcc;
            this.mnc = mnc;
            this.pci = pci;
            this.tac = tac;
            this.dbm = dbm;
        }

        public int getCi() {
            return this.ci;
        }

        public int getMcc() {
            return this.mcc;
        }

        public int getMnc() {
            return this.mnc;
        }

        public int getPci() {
            return this.pci;
        }

        public int getTac() {
            return this.tac;
        }

        public int getDbm() {
            return this.dbm;
        }
    }
}

