/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.beacon;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import io.glimr.sdk.beacon.IBeacon;
import io.glimr.sdk.beacon.IBeaconManager;
import io.glimr.sdk.beacon.RangeNotifier;
import io.glimr.sdk.beacon.service.IBeaconData;
import io.glimr.sdk.beacon.service.MonitoringData;
import io.glimr.sdk.beacon.service.RangingData;
import java.util.Collection;

public class IBeaconIntentProcessor
extends IntentService {
    private static final String TAG = "IBeaconIntentProcessor";
    private boolean initialized = false;

    public IBeaconIntentProcessor() {
        super(TAG);
    }

    public void onHandleIntent(Intent intent) {
        Object notifier;
        if (IBeaconManager.LOG_DEBUG) {
            Log.d((String)TAG, (String)"got an intent to process");
        }
        MonitoringData monitoringData = null;
        RangingData rangingData = null;
        if (intent != null && intent.getExtras() != null) {
            monitoringData = (MonitoringData)intent.getExtras().get("monitoringData");
            rangingData = (RangingData)intent.getExtras().get("rangingData");
        }
        if (rangingData != null) {
            if (IBeaconManager.LOG_DEBUG) {
                Log.d((String)TAG, (String)"got ranging data");
            }
            if (rangingData.getIBeacons() == null) {
                Log.w((String)TAG, (String)"Ranging data has a null iBeacons collection");
            }
            notifier = IBeaconManager.getInstanceForApplication((Context)this).getRangingNotifier();
            Collection<IBeacon> iBeacons = IBeaconData.fromIBeaconDatas(rangingData.getIBeacons());
            if (notifier != null) {
                notifier.didRangeBeaconsInRegion(iBeacons, rangingData.getRegion());
            } else if (IBeaconManager.LOG_DEBUG) {
                Log.d((String)TAG, (String)"but ranging notifier is null, so we're dropping it.");
            }
            RangeNotifier dataNotifier = IBeaconManager.getInstanceForApplication((Context)this).getDataRequestNotifier();
            if (dataNotifier != null) {
                dataNotifier.didRangeBeaconsInRegion(iBeacons, rangingData.getRegion());
            }
        }
        if (monitoringData != null) {
            if (IBeaconManager.LOG_DEBUG) {
                Log.d((String)TAG, (String)"got monitoring data");
            }
            if ((notifier = IBeaconManager.getInstanceForApplication((Context)this).getMonitoringNotifier()) != null) {
                if (IBeaconManager.LOG_DEBUG) {
                    Log.d((String)TAG, (String)("Calling monitoring notifier:" + notifier));
                }
                notifier.didDetermineStateForRegion(monitoringData.isInside() ? 1 : 0, monitoringData.getRegion());
                if (monitoringData.isInside()) {
                    notifier.didEnterRegion(monitoringData.getRegion());
                } else {
                    notifier.didExitRegion(monitoringData.getRegion());
                }
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
    }
}

