package io.glimr.sdk.network;


import android.content.Context;
import android.util.Log;

import io.glimr.sdk.utils.KATSharedPreferences;

public class KATEndPoints {
    public static final String COLLECT_EVENT_URL = "/collect/event/";
    public static final String CONFIG_URL = "/config/";
    public static final String AUDIENCE_URL = "/audience/";
    protected static final String BASE_URL = "https://api.glimr.io/v4";

    public static String fallbackURL() {
        return BASE_URL;
    }

    public static String baseURL(Context context) {
        try {
            String serviceURL = KATSharedPreferences.getServiceURL(context);
            if (serviceURL != null) {
                if (KATRequest.sslPinning && serviceURL.contains("glimr.io")) {
                    return serviceURL;
                }

                return BASE_URL;
            }
        } catch (Exception e) {
            Log.e("GlimrSDK", e.getMessage());
        }

        return BASE_URL;
    }
}
