package io.glimr.sdk.utils;

import android.content.Context;
import android.content.SharedPreferences;

import com.google.gson.Gson;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class KATSharedPreferences {

    protected static final String KAT_CONFIG_RESPONSE = "KatConfigString";

    protected static final String KAT_ENTRY = "KatEntryString";

    protected static final String KAT_SERVICE_URL = "KatServiceURLString";

    protected static final String KAT_ADVERT_ID = "KatAdvertIdString";

    protected static final String KAT_SSL_PINNING_ENABLED = "KatSSLPinningEnabledBoolean";

    protected static final String KAT_ADVERT_ID_ENABLED = "KatAdvertIdEnabledBoolean";

    protected static final String KAT_LAST_CONFIG_UPDATE = "KatLastConfigUpdate";

    protected static final String KAT_SCAN_INTERVAL = "KatScanInterval";

    protected static final String KAT_LAST_AUDIENCE_UPDATE = "KatLastAudienceUpdate";

    protected static final String KAT_AUDIENCE_RESPONSE_MAP = "KatAudienceResponseMap";

    protected static final String KAT_CONCLUDES_MD5 = "KatConcludes";

    protected static final String DOMAIN = "com.glimr.sdk.v2";
    protected static final String DOMAIN_URLS = "com.glimr.sdk.v2.urls";

    public static void storeTrackedURL(Context context, String url, Date date) {
        SharedPreferences prefs = context.getSharedPreferences(DOMAIN_URLS, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = prefs.edit();

        editor.putFloat(url, date.getTime());
        editor.apply();
    }

    public static HashMap<String, Float> getTrackedURLs(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(DOMAIN_URLS, Context.MODE_PRIVATE);
        HashMap<String, Float> urls = new HashMap<String, Float>();

        for (Map.Entry url : prefs.getAll().entrySet()) {
            urls.put(url.getKey().toString(), (Float) url.getValue());
            prefs.edit().remove(url.getKey().toString()).apply();
        }

        return urls;
    }

    public static String getServiceURL(Context context) {
        SharedPreferences prefs = context
                .getSharedPreferences(DOMAIN, Context.MODE_PRIVATE);
        return prefs.getString(KAT_SERVICE_URL, null);
    }

    public static void saveServiceURL(Context context, String entry) {
        SharedPreferences prefs = context
                .getSharedPreferences(DOMAIN, Context.MODE_PRIVATE);
        prefs.edit().putString(KAT_SERVICE_URL, entry).apply();
    }

    public static HashMap getAudienceResponseMap(Context context) {
        SharedPreferences prefs = context
                .getSharedPreferences(DOMAIN, Context.MODE_PRIVATE);
        String response = prefs.getString(KAT_AUDIENCE_RESPONSE_MAP, null);
        Gson gson = new Gson();
        return gson.fromJson(response, HashMap.class);
    }

    public static void saveAudienceResponseMap(Context context, HashMap<String, ArrayList<String>> map) {
        SharedPreferences prefs = context
                .getSharedPreferences(DOMAIN, Context.MODE_PRIVATE);
        Gson gson = new Gson();
        String json = gson.toJson(map);
        prefs.edit().putString(KAT_AUDIENCE_RESPONSE_MAP, json).apply();
    }

    public static Boolean getAdvertIdEnabled(Context context) {
        SharedPreferences prefs = context
                .getSharedPreferences(DOMAIN, Context.MODE_PRIVATE);
        return prefs.getBoolean(KAT_ADVERT_ID_ENABLED, true);
    }

    public static void saveAdvertIdEnabled(Context context, Boolean entry) {
        SharedPreferences prefs = context
                .getSharedPreferences(DOMAIN, Context.MODE_PRIVATE);
        prefs.edit().putBoolean(KAT_ADVERT_ID_ENABLED, entry).apply();
    }

    public static Boolean getSSLPinning(Context context) {
        SharedPreferences prefs = context
                .getSharedPreferences(DOMAIN, Context.MODE_PRIVATE);
        return prefs.getBoolean(KAT_SSL_PINNING_ENABLED, false);
    }

    public static void saveSSLPinning(Context context, Boolean sslpinning) {
        SharedPreferences prefs = context
                .getSharedPreferences(DOMAIN, Context.MODE_PRIVATE);
        prefs.edit().putBoolean(KAT_SSL_PINNING_ENABLED, sslpinning).apply();
    }

    public static int getScanInterval(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(DOMAIN, Context.MODE_PRIVATE);
        return Math.max(prefs.getInt(KAT_SCAN_INTERVAL, 300), 20);
    }

    public static void saveScanInterval(Context context, int scanInterval) {
        SharedPreferences prefs = context
                .getSharedPreferences(DOMAIN, Context.MODE_PRIVATE);
        prefs.edit().putInt(KAT_SCAN_INTERVAL, scanInterval).apply();
    }

    public static Date getLastConfigUpdateDate(Context context) {
        SharedPreferences prefs = context
                .getSharedPreferences(DOMAIN, Context.MODE_PRIVATE);
        return new Date(prefs.getLong(KAT_LAST_CONFIG_UPDATE, 0L));
    }

    public static void setLastConfigUpdateDate(Context context, Date entry) {
        SharedPreferences prefs = context
                .getSharedPreferences(DOMAIN, Context.MODE_PRIVATE);
        prefs.edit().putLong(KAT_LAST_CONFIG_UPDATE, entry.getTime()).apply();
    }

    public static Date getLastAudienceUpdateDate(Context context) {
        SharedPreferences prefs = context
                .getSharedPreferences(DOMAIN, Context.MODE_PRIVATE);
        return new Date(prefs.getLong(KAT_LAST_AUDIENCE_UPDATE, 0L));
    }

    public static void setLastAudienceUpdateDate(Context context, Date entry) {
        SharedPreferences prefs = context
                .getSharedPreferences(DOMAIN, Context.MODE_PRIVATE);
        prefs.edit().putLong(KAT_LAST_AUDIENCE_UPDATE, entry.getTime()).apply();
    }

    public static String getAdvertId(Context context) {
        SharedPreferences prefs = context
                .getSharedPreferences(DOMAIN, Context.MODE_PRIVATE);
        return prefs.getString(KAT_ADVERT_ID, null);
    }

    public static void saveAdvertId(Context context, String entry) {
        SharedPreferences prefs = context
                .getSharedPreferences(DOMAIN, Context.MODE_PRIVATE);
        prefs.edit().putString(KAT_ADVERT_ID, entry).apply();
    }

    public static String getEntry(Context context) {
        SharedPreferences prefs = context
                .getSharedPreferences(DOMAIN, Context.MODE_PRIVATE);
        return prefs.getString(KAT_ENTRY, null);
    }

    public static void saveEntry(Context context, String entry) {
        SharedPreferences prefs = context
                .getSharedPreferences(DOMAIN, Context.MODE_PRIVATE);
        prefs.edit().putString(KAT_ENTRY, entry).apply();
    }

    public static ArrayList getConfigResponse(Context context) {
        SharedPreferences prefs = context
                .getSharedPreferences(DOMAIN, Context.MODE_PRIVATE);
        String response = prefs.getString(KAT_CONFIG_RESPONSE, null);
        Gson gson = new Gson();
        return gson.fromJson(response, ArrayList.class);
    }

    public static void saveConfigResponse(Context context, ArrayList katConfig) {
        SharedPreferences prefs = context
                .getSharedPreferences(DOMAIN, Context.MODE_PRIVATE);
        Gson gson = new Gson();
        String json = gson.toJson(katConfig);
        prefs.edit().putString(KAT_CONFIG_RESPONSE, json).apply();
    }

    public static void saveConcludesHash(Context context, String hash) {
        SharedPreferences prefs = context
                .getSharedPreferences(DOMAIN, Context.MODE_PRIVATE);
        prefs.edit().putString(KAT_CONCLUDES_MD5, hash).apply();
    }

    public static String getConcludesHash(Context context) {
        SharedPreferences prefs = context
                .getSharedPreferences(DOMAIN, Context.MODE_PRIVATE);
        return prefs.getString(KAT_CONCLUDES_MD5, null);
    }
}
