package io.glimr.sdk.engine;

import android.annotation.SuppressLint;
import android.telephony.CellIdentityGsm;
import android.telephony.CellIdentityLte;
import android.telephony.CellIdentityWcdma;
import android.telephony.CellInfo;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.CellSignalStrengthGsm;
import android.telephony.CellSignalStrengthLte;
import android.telephony.CellSignalStrengthWcdma;
import android.telephony.TelephonyManager;

import java.util.ArrayList;
import java.util.List;

public class KATBaseStationServices {
    @SuppressLint("NewApi")
    public static KATBaseStationInfo getBaseStations(final TelephonyManager telephonyManager) {
        List<KATWCDMABaseStationInfo> katwcdmaBaseStationInfoList = new ArrayList<KATWCDMABaseStationInfo>();
        List<KATLTEBaseStationInfo> katlteBaseStationInfoList = new ArrayList<KATLTEBaseStationInfo>();
        List<KATGSMBaseStationInfo> katgsmBaseStationInfoList = new ArrayList<KATGSMBaseStationInfo>();

        List<CellInfo> cellInfos = telephonyManager.getAllCellInfo();
        if (cellInfos == null) {
            // Skip for loop
            cellInfos = new ArrayList<CellInfo>();
        }

        for (CellInfo cellInfo : cellInfos) {
            if (cellInfo instanceof CellInfoLte) {
                CellIdentityLte cellIdentity = ((CellInfoLte) cellInfo).getCellIdentity();
                CellSignalStrengthLte cellSignalStrength = ((CellInfoLte) cellInfo).getCellSignalStrength();
                KATLTEBaseStationInfo katlteBaseStationInfo = new KATLTEBaseStationInfo(
                        cellIdentity.getCi(),
                        cellIdentity.getMcc(),
                        cellIdentity.getMnc(),
                        cellIdentity.getPci(),
                        cellIdentity.getTac(),
                        cellSignalStrength.getDbm()
                );
                katlteBaseStationInfoList.add(katlteBaseStationInfo);
            } else if (cellInfo instanceof CellInfoGsm) {
                CellIdentityGsm cellIdentityGsm = ((CellInfoGsm) cellInfo).getCellIdentity();
                CellSignalStrengthGsm cellSignalStrength = ((CellInfoGsm) cellInfo).getCellSignalStrength();
                KATGSMBaseStationInfo katgsmBaseStationInfo = new KATGSMBaseStationInfo(
                        cellIdentityGsm.getCid(),
                        cellIdentityGsm.getLac(),
                        cellIdentityGsm.getMcc(),
                        cellIdentityGsm.getMnc(),
                        cellSignalStrength.getDbm()
                );
                katgsmBaseStationInfoList.add(katgsmBaseStationInfo);
            } else if (cellInfo instanceof CellInfoWcdma) {
                CellIdentityWcdma cellIdentity = ((CellInfoWcdma) cellInfo).getCellIdentity();
                CellSignalStrengthWcdma cellSignalStrength = ((CellInfoWcdma) cellInfo).getCellSignalStrength();
                KATWCDMABaseStationInfo katwcdmaBaseStationInfo = new KATWCDMABaseStationInfo(
                        cellIdentity.getCid(),
                        cellIdentity.getLac(),
                        cellIdentity.getMcc(),
                        cellIdentity.getMnc(),
                        cellIdentity.getPsc(),
                        cellSignalStrength.getDbm()
                );
                katwcdmaBaseStationInfoList.add(katwcdmaBaseStationInfo);
            }
        }

        return new KATBaseStationInfo(
                katlteBaseStationInfoList,
                katwcdmaBaseStationInfoList,
                katgsmBaseStationInfoList
        );
    }

    public static class KATLTEBaseStationInfo {
        private int ci;
        private int mcc;
        private int mnc;
        private int pci;
        private int tac;
        private int dbm;

        public KATLTEBaseStationInfo(int ci, int mcc, int mnc, int pci, int tac, int dbm) {
            this.ci = ci;
            this.mcc = mcc;
            this.mnc = mnc;
            this.pci = pci;
            this.tac = tac;
            this.dbm = dbm;
        }

        public int getCi() {
            return ci;
        }

        public int getMcc() {
            return mcc;
        }

        public int getMnc() {
            return mnc;
        }

        public int getPci() {
            return pci;
        }

        public int getTac() {
            return tac;
        }

        public int getDbm() {
            return dbm;
        }
    }

    public static class KATWCDMABaseStationInfo {
        private int cid, lac, mcc, mnc, psc, dbm;

        public KATWCDMABaseStationInfo(int cid, int lac, int mcc, int mnc, int psc, int dbm) {
            this.cid = cid;
            this.lac = lac;
            this.mcc = mcc;
            this.mnc = mnc;
            this.psc = psc;
            this.dbm = dbm;
        }

        public int getCid() {
            return cid;
        }

        public int getLac() {
            return lac;
        }

        public int getMcc() {
            return mcc;
        }

        public int getMnc() {
            return mnc;
        }

        public int getPsc() {
            return psc;
        }

        public int getDbm() {
            return dbm;
        }
    }

    public static class KATGSMBaseStationInfo {
        private int cid, lac, mcc, mnc, dbm;

        public KATGSMBaseStationInfo(int cid, int lac, int mcc, int mnc, int dbm) {
            this.cid = cid;
            this.lac = lac;
            this.mcc = mcc;
            this.mnc = mnc;
            this.dbm = dbm;
        }

        public int getCid() {
            return cid;
        }

        public int getLac() {
            return lac;
        }

        public int getMcc() {
            return mcc;
        }

        public int getMnc() {
            return mnc;
        }

        public int getDbm() {
            return dbm;
        }
    }

    public static class KATBaseStationInfo {
        private List<KATLTEBaseStationInfo> mKATLteBaseStationInfoList;
        private List<KATWCDMABaseStationInfo> mKATWCDMABaseStationInfoList;
        private List<KATGSMBaseStationInfo> mKATGSMBaseStationInfoList;

        public KATBaseStationInfo(List<KATLTEBaseStationInfo> KATLteBaseStationInfoList, List<KATWCDMABaseStationInfo> KATWCDMABaseStationInfoList,
                                  List<KATGSMBaseStationInfo> KATGSMBaseStationInfoList) {
            mKATLteBaseStationInfoList = KATLteBaseStationInfoList;
            mKATWCDMABaseStationInfoList = KATWCDMABaseStationInfoList;
            mKATGSMBaseStationInfoList = KATGSMBaseStationInfoList;
        }

        public List<KATLTEBaseStationInfo> getKATLTEBaseStationInfoList() {
            return mKATLteBaseStationInfoList;
        }

        public List<KATWCDMABaseStationInfo> getKATWCDMABaseStationInfoList() {
            return mKATWCDMABaseStationInfoList;
        }

        public List<KATGSMBaseStationInfo> getKATGSMBaseStationInfoList() {
            return mKATGSMBaseStationInfoList;
        }
    }
}
