package io.glimr.sdk.beacon.service;

import android.Manifest;
import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.util.Log;

import com.google.gson.internal.LinkedTreeMap;
import io.glimr.sdk.beacon.KATBeaconManager;
import io.glimr.sdk.utils.KATSharedPreferences;
import io.glimr.sdk.utils.KATSystemInformation;

import java.util.ArrayList;
import java.util.Calendar;


public class KATBeaconReceiver extends BroadcastReceiver {

    @Override
    public void onReceive(final Context context, final Intent intent) {
        Log.d("GlimrSDK", "#Starting Glimr");

        if (KATSystemInformation.canDoBle(context)) {
            try {
                final PendingResult result = goAsync();
                final KATBeaconManager mKatBeaconManager = KATBeaconManager.getInstance(context);
                mKatBeaconManager.setApiToken(KATSharedPreferences.getEntry(context));

                ArrayList<LinkedTreeMap> config = KATSharedPreferences.getConfigResponse(context);
                ArrayList<String> beacons = new ArrayList<String>();

                if (config != null) {
                    int permission_state_ble = context
                            .checkCallingOrSelfPermission(Manifest.permission.BLUETOOTH);
                    int permission_state_ble_admin = context
                            .checkCallingOrSelfPermission(Manifest.permission.BLUETOOTH_ADMIN);
                    if (permission_state_ble == PackageManager.PERMISSION_GRANTED
                            && permission_state_ble_admin == PackageManager.PERMISSION_GRANTED) {
                        for (LinkedTreeMap region : config) {
                            String dashlessUuid = ((String) region.get("identifier")).toLowerCase().replaceAll("[\\-\\s]", "");
                            if ((Double) region.get("type") == 0.0 && dashlessUuid.length() == 32) {
                                beacons.add((String) region.get("identifier"));
                            }
                        }

                        if (beacons.size() > 0) {
                            mKatBeaconManager.bindBeacons(beacons, mKatBeaconManager.getApiToken());

                            Handler handler = new Handler();
                            handler.postDelayed(new Runnable() {
                                @Override
                                public void run() {
                                    Log.d("GlimrSDK", "#Stopping Glimr");
                                    mKatBeaconManager.stop();
                                    mKatBeaconManager.unbindBeacons();
                                }
                            }, 1800);
                        }
                    }
                }

                Handler handler = new Handler();
                handler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        schedule(context);
                        Log.d("GlimrSDK", "#Shutting Glimr");
                        result.setResultCode(Activity.RESULT_OK);
                        result.finish();
                    }
                }, 6000);
            } catch (Exception e) {
                Log.d("GlimrSDK", e.toString());
            }
        } else {
            Log.d("GlimrSDK", "Version too low, starting > 4.4");
        }
    }


    public void schedule(Context context) {
        Log.d("GlimrSDK", "#Reschedule Glimr");

        try {
            AlarmManager alarmMgr = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
            Intent intent = new Intent(context, KATBeaconReceiver.class);
            PendingIntent alarmIntent = PendingIntent.getBroadcast(context, 0, intent, 0);

            Calendar calendar = Calendar.getInstance();
            int hour = calendar.get(Calendar.HOUR_OF_DAY);
            if (hour >= 23) {
                calendar.add(Calendar.DATE, 1);
                calendar.set(Calendar.HOUR_OF_DAY, 6);
                calendar.set(Calendar.MINUTE, 0);
            } else {
                int next = KATSharedPreferences.getScanInterval(context);
                Log.d("GlimrSDK", "#Next in " + next);
                calendar.add(Calendar.SECOND, next);
            }

            alarmMgr.set(AlarmManager.RTC_WAKEUP, calendar.getTimeInMillis(), alarmIntent);
        } catch (Exception e) {
            Log.d("GlimrSDK", e.toString());
        }
    }
}
