/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.geofence;

import com.google.android.gms.location.Geofence;

public class KATGeofence {
    private final String mId;
    private final double mLatitude;
    private final double mLongitude;
    private final float mRadius;
    private int mTransitionType;

    public KATGeofence(String geofenceId, double latitude, double longitude, float radius, int transition) {
        this.mId = geofenceId;
        this.mLatitude = latitude;
        this.mLongitude = longitude;
        this.mRadius = radius;
        this.mTransitionType = transition;
    }

    public String getId() {
        return this.mId;
    }

    public double getLatitude() {
        return this.mLatitude;
    }

    public double getLongitude() {
        return this.mLongitude;
    }

    public float getRadius() {
        return this.mRadius;
    }

    public int getTransitionType() {
        return this.mTransitionType;
    }

    public Geofence toGeofence() {
        return new Geofence.Builder().setRequestId(this.getId()).setTransitionTypes(this.mTransitionType).setCircularRegion(this.getLatitude(), this.getLongitude(), this.getRadius()).setExpirationDuration(-1L).build();
    }
}

