/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.beacon.service;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import io.glimr.sdk.beacon.IBeacon;
import io.glimr.sdk.beacon.IBeaconManager;
import io.glimr.sdk.beacon.Region;
import io.glimr.sdk.beacon.service.IBeaconData;
import io.glimr.sdk.beacon.service.RegionData;
import java.util.ArrayList;
import java.util.Collection;

public class RangingData
implements Parcelable {
    public static final Parcelable.Creator<RangingData> CREATOR = new Parcelable.Creator<RangingData>(){

        public RangingData createFromParcel(Parcel in) {
            return new RangingData(in);
        }

        public RangingData[] newArray(int size) {
            return new RangingData[size];
        }
    };
    private static final String TAG = "RangingData";
    private Collection<IBeaconData> iBeaconDatas;
    private RegionData regionData;

    public RangingData(Collection<IBeacon> iBeacons, Region region) {
        this.iBeaconDatas = IBeaconData.fromIBeacons(iBeacons);
        this.regionData = new RegionData(region);
    }

    public RangingData(Collection<IBeaconData> iBeacons, RegionData region) {
        this.iBeaconDatas = iBeacons;
        this.regionData = region;
    }

    private RangingData(Parcel in) {
        if (IBeaconManager.LOG_DEBUG) {
            Log.d((String)TAG, (String)"parsing RangingData");
        }
        Parcelable[] parcelables = in.readParcelableArray(this.getClass().getClassLoader());
        this.iBeaconDatas = new ArrayList<IBeaconData>(parcelables.length);
        for (int i = 0; i < parcelables.length; ++i) {
            this.iBeaconDatas.add((IBeaconData)parcelables[i]);
        }
        this.regionData = (RegionData)in.readParcelable(this.getClass().getClassLoader());
    }

    public Collection<IBeaconData> getIBeacons() {
        return this.iBeaconDatas;
    }

    public RegionData getRegion() {
        return this.regionData;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (IBeaconManager.LOG_DEBUG) {
            Log.d((String)TAG, (String)"writing RangingData");
        }
        out.writeParcelableArray(this.iBeaconDatas.toArray(new Parcelable[0]), flags);
        out.writeParcelable((Parcelable)this.regionData, flags);
        if (IBeaconManager.LOG_DEBUG) {
            Log.d((String)TAG, (String)"done writing RangingData");
        }
    }
}

