/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.beacon.service;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.util.Log;
import com.google.gson.internal.LinkedTreeMap;
import io.glimr.sdk.beacon.KATBeaconManager;
import io.glimr.sdk.engine.KATEvent;
import io.glimr.sdk.engine.KATManager;
import io.glimr.sdk.utils.KATSharedPreferences;
import io.glimr.sdk.utils.KATSystemInformation;
import java.util.ArrayList;
import java.util.Calendar;

public class KATBeaconReceiver
extends BroadcastReceiver {
    public void onReceive(final Context context, Intent intent) {
        Log.d((String)"GlimrSDK", (String)"#Starting Glimr");
        if (KATSystemInformation.canDoBle(context).booleanValue()) {
            try {
                final BroadcastReceiver.PendingResult result = this.goAsync();
                final KATBeaconManager mKatBeaconManager = KATBeaconManager.getInstance(context);
                mKatBeaconManager.setApiToken(KATSharedPreferences.getEntry(context));
                KATManager mKatManager = KATManager.getInstance(context, mKatBeaconManager.getApiToken(), null, KATSharedPreferences.getSSLPinning(context), KATSharedPreferences.getScanInterval(context));
                KATEvent callbackContext = mKatManager.callbackContext;
                ArrayList config = KATSharedPreferences.getConfigResponse(context);
                ArrayList<String> beacons = new ArrayList<String>();
                if (config != null) {
                    int permission_state_ble = context.checkCallingOrSelfPermission("android.permission.BLUETOOTH");
                    int permission_state_ble_admin = context.checkCallingOrSelfPermission("android.permission.BLUETOOTH_ADMIN");
                    if (permission_state_ble == 0 && permission_state_ble_admin == 0) {
                        for (LinkedTreeMap region : config) {
                            String dashlessUuid = ((String)region.get((Object)"identifier")).toLowerCase().replaceAll("[\\-\\s]", "");
                            if ((Double)region.get((Object)"type") != 0.0 || dashlessUuid.length() != 32) continue;
                            beacons.add((String)region.get((Object)"identifier"));
                        }
                        if (beacons.size() > 0) {
                            mKatBeaconManager.bindBeacons(beacons, mKatBeaconManager.getApiToken());
                            Handler handler = new Handler();
                            handler.postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    Log.d((String)"GlimrSDK", (String)"#Stopping Glimr");
                                    mKatBeaconManager.stop();
                                    mKatBeaconManager.unbindBeacons();
                                }
                            }, 1800L);
                        }
                    }
                }
                Handler handler = new Handler();
                handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        KATBeaconReceiver.this.schedule(context);
                        Log.d((String)"GlimrSDK", (String)"#Shutting Glimr");
                        result.setResultCode(-1);
                        result.finish();
                    }
                }, 6000L);
            }
            catch (Exception e) {
                Log.d((String)"GlimrSDK", (String)e.toString());
            }
        } else {
            Log.d((String)"GlimrSDK", (String)"Version too low, starting > 4.4");
        }
    }

    public void schedule(Context context) {
        Log.d((String)"GlimrSDK", (String)"#Reschedule Glimr");
        try {
            AlarmManager alarmMgr = (AlarmManager)context.getSystemService("alarm");
            Intent intent = new Intent(context, KATBeaconReceiver.class);
            PendingIntent alarmIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
            Calendar calendar = Calendar.getInstance();
            int hour = calendar.get(11);
            if (hour >= 23) {
                calendar.add(5, 1);
                calendar.set(11, 6);
                calendar.set(12, 0);
            } else {
                int next = KATSharedPreferences.getScanInterval(context);
                Log.d((String)"GlimrSDK", (String)("#Next in " + next));
                calendar.add(13, next);
            }
            alarmMgr.set(0, calendar.getTimeInMillis(), alarmIntent);
        }
        catch (Exception e) {
            Log.d((String)"GlimrSDK", (String)e.toString());
        }
    }
}

