/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.beacon.client;

import android.util.Log;
import io.glimr.sdk.beacon.IBeacon;
import io.glimr.sdk.beacon.IBeaconManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

public class RangedIBeacon
extends IBeacon {
    public static long DEFAULT_SAMPLE_EXPIRATION_MILLISECONDS = 5000L;
    private static String TAG = "RangedIBeacon";
    private long sampleExpirationMilliseconds = DEFAULT_SAMPLE_EXPIRATION_MILLISECONDS;
    private ArrayList<Measurement> measurements = new ArrayList();

    public RangedIBeacon(IBeacon ibeacon) {
        super(ibeacon);
        this.addMeasurement(this.rssi);
    }

    public void setSampleExpirationMilliseconds(long milliseconds) {
        this.sampleExpirationMilliseconds = milliseconds;
    }

    public void addMeasurement(Integer rssi) {
        Measurement measurement = new Measurement();
        measurement.rssi = rssi;
        measurement.timestamp = new Date().getTime();
        this.measurements.add(measurement);
    }

    public boolean allMeasurementsExpired() {
        this.refreshMeasurements();
        return this.measurements.size() == 0;
    }

    private synchronized void refreshMeasurements() {
        Date now = new Date();
        ArrayList<Measurement> newMeasurements = new ArrayList<Measurement>();
        for (Measurement measurement : this.measurements) {
            if (now.getTime() - measurement.timestamp >= this.sampleExpirationMilliseconds) continue;
            newMeasurements.add(measurement);
        }
        this.measurements = newMeasurements;
        Collections.sort(this.measurements);
    }

    private double calculateRunningAverage() {
        this.refreshMeasurements();
        int size = this.measurements.size();
        int startIndex = 0;
        int endIndex = size - 1;
        if (size > 2) {
            startIndex = size / 10 + 1;
            endIndex = size - size / 10 - 2;
        }
        int sum = 0;
        for (int i = startIndex; i <= endIndex; ++i) {
            sum += this.measurements.get((int)i).rssi.intValue();
        }
        double runningAverage = sum / (endIndex - startIndex + 1);
        if (IBeaconManager.LOG_DEBUG) {
            Log.d((String)TAG, (String)("Running average rssi based on " + size + " measurements: " + runningAverage));
        }
        return runningAverage;
    }

    protected void addRangeMeasurement(Integer rssi) {
        this.rssi = rssi;
        this.addMeasurement(rssi);
        if (IBeaconManager.LOG_DEBUG) {
            Log.d((String)TAG, (String)("calculating new range measurement with new rssi measurement:" + rssi));
        }
        this.runningAverageRssi = this.calculateRunningAverage();
        this.accuracy = null;
        this.proximity = null;
    }

    private class Measurement
    implements Comparable<Measurement> {
        Integer rssi;
        long timestamp;

        private Measurement() {
        }

        @Override
        public int compareTo(Measurement arg0) {
            return this.rssi.compareTo(arg0.rssi);
        }
    }
}

