/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.beacon;

import android.util.Log;
import io.glimr.sdk.beacon.IBeacon;
import io.glimr.sdk.beacon.IBeaconManager;

public class Region {
    private static final String TAG = "Region";
    protected Integer major;
    protected Integer minor;
    protected String proximityUuid;
    protected String uniqueId;

    protected Region(String uniqueId, String proximityUuid, Integer major, Integer minor) {
        this.major = major;
        this.minor = minor;
        this.proximityUuid = Region.normalizeProximityUuid(proximityUuid);
        this.uniqueId = uniqueId;
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId may not be null");
        }
    }

    protected Region(Region otherRegion) {
        this.major = otherRegion.major;
        this.minor = otherRegion.minor;
        this.proximityUuid = otherRegion.proximityUuid;
        this.uniqueId = otherRegion.uniqueId;
    }

    protected Region() {
    }

    public static String normalizeProximityUuid(String proximityUuid) {
        if (proximityUuid == null) {
            return null;
        }
        String dashlessUuid = proximityUuid.toLowerCase().replaceAll("[\\-\\s]", "");
        if (dashlessUuid.length() != 32) {
            throw new RuntimeException("UUID: " + proximityUuid + " is too short.  Must contain exactly 32 hex digits, and there are this value has " + dashlessUuid.length() + " digits.");
        }
        if (!dashlessUuid.matches("^[a-fA-F0-9]*$")) {
            throw new RuntimeException("UUID: " + proximityUuid + " contains invalid characters.  Must be dashes, a-f and 0-9 characters only.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(dashlessUuid.substring(0, 8));
        sb.append('-');
        sb.append(dashlessUuid.substring(8, 12));
        sb.append('-');
        sb.append(dashlessUuid.substring(12, 16));
        sb.append('-');
        sb.append(dashlessUuid.substring(16, 20));
        sb.append('-');
        sb.append(dashlessUuid.substring(20, 32));
        return sb.toString();
    }

    public Integer getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public String getProximityUuid() {
        return this.proximityUuid;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public boolean matchesIBeacon(IBeacon iBeacon) {
        if (this.proximityUuid != null && !iBeacon.getProximityUuid().equals(this.proximityUuid)) {
            if (IBeaconManager.LOG_DEBUG) {
                Log.d((String)TAG, (String)("unmatching proxmityUuids: " + iBeacon.getProximityUuid() + " != " + this.proximityUuid));
            }
            return false;
        }
        if (this.major != null && iBeacon.getMajor() != this.major.intValue()) {
            if (IBeaconManager.LOG_DEBUG) {
                Log.d((String)TAG, (String)("unmatching major: " + iBeacon.getMajor() + " != " + this.major));
            }
            return false;
        }
        if (this.minor != null && iBeacon.getMinor() != this.minor.intValue()) {
            if (IBeaconManager.LOG_DEBUG) {
                Log.d((String)TAG, (String)("unmatching minor: " + iBeacon.getMajor() + " != " + this.minor));
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Region) {
            return ((Region)other).uniqueId.equals(this.uniqueId);
        }
        return false;
    }

    public String toString() {
        return "proximityUuid: " + this.proximityUuid + " major: " + this.major + " minor:" + this.minor;
    }

    public Object clone() {
        return new Region(this);
    }
}

