/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.beacon;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import io.glimr.sdk.beacon.BleNotAvailableException;
import io.glimr.sdk.beacon.IBeaconConsumer;
import io.glimr.sdk.beacon.MonitorNotifier;
import io.glimr.sdk.beacon.RangeNotifier;
import io.glimr.sdk.beacon.Region;
import io.glimr.sdk.beacon.service.IBeaconService;
import io.glimr.sdk.beacon.service.RegionData;
import io.glimr.sdk.beacon.service.StartRMData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class IBeaconManager {
    private static final String TAG = "IBeaconManager";
    public static boolean LOG_DEBUG = false;
    protected static IBeaconManager client = null;
    protected RangeNotifier rangeNotifier = null;
    protected RangeNotifier dataRequestNotifier = null;
    protected MonitorNotifier monitorNotifier = null;
    private Context context;
    private Map<IBeaconConsumer, ConsumerInfo> consumers = new HashMap<IBeaconConsumer, ConsumerInfo>();
    private Messenger serviceMessenger = null;
    private ArrayList<Region> monitoredRegions = new ArrayList();
    private ArrayList<Region> rangedRegions = new ArrayList();
    private ServiceConnection iBeaconServiceConnection = new ServiceConnection(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName className, IBinder service) {
            IBeaconManager.this.serviceMessenger = new Messenger(service);
            Map map = IBeaconManager.this.consumers;
            synchronized (map) {
                for (IBeaconConsumer consumer : IBeaconManager.this.consumers.keySet()) {
                    Boolean alreadyConnected = ((ConsumerInfo)((IBeaconManager)IBeaconManager.this).consumers.get((Object)consumer)).isConnected;
                    if (alreadyConnected.booleanValue()) continue;
                    consumer.onIBeaconServiceConnect();
                    ConsumerInfo consumerInfo = (ConsumerInfo)IBeaconManager.this.consumers.get(consumer);
                    consumerInfo.isConnected = true;
                    IBeaconManager.this.consumers.put(consumer, consumerInfo);
                }
            }
        }

        public void onServiceDisconnected(ComponentName className) {
            Log.e((String)IBeaconManager.TAG, (String)"#Beacon onServiceDisconnected");
        }
    };

    protected IBeaconManager(Context context) {
        this.context = context;
    }

    protected static IBeaconManager getInstanceForApplication(Context context) {
        if (client == null) {
            if (LOG_DEBUG) {
                Log.d((String)TAG, (String)"#Beacon IBeaconManager instance creation");
            }
            client = new IBeaconManager(context);
        }
        return client;
    }

    public boolean checkAvailability() {
        if (!this.context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            throw new BleNotAvailableException("Bluetooth LE not supported by this device");
        }
        return ((BluetoothManager)this.context.getSystemService("bluetooth")).getAdapter().isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bind(IBeaconConsumer consumer) {
        Map<IBeaconConsumer, ConsumerInfo> map = this.consumers;
        synchronized (map) {
            if (this.consumers.keySet().contains(consumer)) {
                if (LOG_DEBUG) {
                    Log.d((String)TAG, (String)"This consumer is already bound");
                }
            } else {
                this.consumers.put(consumer, new ConsumerInfo());
                Intent intent = new Intent(consumer.getApplicationContext(), IBeaconService.class);
                consumer.bindService(intent, this.iBeaconServiceConnection, 1);
                if (LOG_DEBUG) {
                    Log.d((String)TAG, (String)("#Beacon consumer count is now:" + this.consumers.size()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unBind(IBeaconConsumer consumer) {
        Map<IBeaconConsumer, ConsumerInfo> map = this.consumers;
        synchronized (map) {
            if (this.consumers.keySet().contains(consumer)) {
                consumer.unbindService(this.iBeaconServiceConnection);
                this.consumers.remove(consumer);
            } else {
                if (LOG_DEBUG) {
                    Log.d((String)TAG, (String)("This consumer is not bound to: " + consumer));
                }
                if (LOG_DEBUG) {
                    Log.d((String)TAG, (String)"Bound consumers: ");
                }
                for (int i = 0; i < this.consumers.size(); ++i) {
                    Log.i((String)TAG, (String)(" " + this.consumers.get(i)));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isBound(IBeaconConsumer consumer) {
        Map<IBeaconConsumer, ConsumerInfo> map = this.consumers;
        synchronized (map) {
            return this.consumers.keySet().contains(consumer) && this.serviceMessenger != null;
        }
    }

    @TargetApi(value=15)
    protected void startScan() throws RemoteException {
        if (this.serviceMessenger == null) {
            throw new RemoteException("The IBeaconManager is not bound to the service.  Call iBeaconManager.bind(IBeaconConsumer consumer) and wait for a callback to onIBeaconServiceConnect()");
        }
        Message msg = Message.obtain(null, (int)7, (int)0, (int)0);
        this.serviceMessenger.send(msg);
    }

    @TargetApi(value=15)
    protected void stopScan() throws RemoteException {
        if (this.serviceMessenger == null) {
            return;
        }
        Message msg = Message.obtain(null, (int)8, (int)0, (int)0);
        this.serviceMessenger.send(msg);
    }

    protected void setRangeNotifier(RangeNotifier notifier) {
        this.rangeNotifier = notifier;
    }

    protected void setMonitorNotifier(MonitorNotifier notifier) {
        this.monitorNotifier = notifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=15)
    protected void startRangingBeaconsInRegion(Region region) throws RemoteException {
        if (this.serviceMessenger == null) {
            throw new RemoteException("The IBeaconManager is not bound to the service.  Call iBeaconManager.bind(IBeaconConsumer consumer) and wait for a callback to onIBeaconServiceConnect()");
        }
        Message msg = Message.obtain(null, (int)2, (int)0, (int)0);
        StartRMData obj = new StartRMData(new RegionData(region), this.callbackPackageName(), 0L, 0L);
        msg.obj = obj;
        this.serviceMessenger.send(msg);
        ArrayList<Region> arrayList = this.rangedRegions;
        synchronized (arrayList) {
            this.rangedRegions.add((Region)region.clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=15)
    protected void stopRangingBeaconsInRegion(Region region) throws RemoteException {
        if (this.serviceMessenger == null) {
            throw new RemoteException("The IBeaconManager is not bound to the service.  Call iBeaconManager.bind(IBeaconConsumer consumer) and wait for a callback to onIBeaconServiceConnect()");
        }
        Message msg = Message.obtain(null, (int)3, (int)0, (int)0);
        StartRMData obj = new StartRMData(new RegionData(region), this.callbackPackageName(), 0L, 0L);
        msg.obj = obj;
        this.serviceMessenger.send(msg);
        ArrayList<Region> arrayList = this.rangedRegions;
        synchronized (arrayList) {
            Region regionToRemove = null;
            for (Region rangedRegion : this.rangedRegions) {
                if (!region.getUniqueId().equals(rangedRegion.getProximityUuid())) continue;
                regionToRemove = rangedRegion;
            }
            this.rangedRegions.remove(regionToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=15)
    protected void startMonitoringBeaconsInRegion(Region region) throws RemoteException {
        if (this.serviceMessenger == null) {
            throw new RemoteException("The IBeaconManager is not bound to the service.  Call iBeaconManager.bind(IBeaconConsumer consumer) and wait for a callback to onIBeaconServiceConnect()");
        }
        Message msg = Message.obtain(null, (int)4, (int)0, (int)0);
        StartRMData obj = new StartRMData(new RegionData(region), this.callbackPackageName(), 0L, 0L);
        msg.obj = obj;
        this.serviceMessenger.send(msg);
        ArrayList<Region> arrayList = this.monitoredRegions;
        synchronized (arrayList) {
            this.monitoredRegions.add((Region)region.clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=15)
    protected void stopMonitoringBeaconsInRegion(Region region) throws RemoteException {
        if (this.serviceMessenger == null) {
            throw new RemoteException("The IBeaconManager is not bound to the service.  Call iBeaconManager.bind(IBeaconConsumer consumer) and wait for a callback to onIBeaconServiceConnect()");
        }
        Message msg = Message.obtain(null, (int)5, (int)0, (int)0);
        StartRMData obj = new StartRMData(new RegionData(region), this.callbackPackageName(), 0L, 0L);
        msg.obj = obj;
        this.serviceMessenger.send(msg);
        ArrayList<Region> arrayList = this.monitoredRegions;
        synchronized (arrayList) {
            Region regionToRemove = null;
            for (Region monitoredRegion : this.monitoredRegions) {
                if (!region.getUniqueId().equals(monitoredRegion.getProximityUuid())) continue;
                regionToRemove = monitoredRegion;
            }
            this.monitoredRegions.remove(regionToRemove);
        }
    }

    private String callbackPackageName() {
        return this.context.getPackageName();
    }

    protected MonitorNotifier getMonitoringNotifier() {
        return this.monitorNotifier;
    }

    protected RangeNotifier getRangingNotifier() {
        return this.rangeNotifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Region> getMonitoredRegions() {
        ArrayList<Region> clonedMontoredRegions = new ArrayList<Region>();
        ArrayList<Region> arrayList = this.monitoredRegions;
        synchronized (arrayList) {
            for (Region montioredRegion : this.monitoredRegions) {
                clonedMontoredRegions.add((Region)montioredRegion.clone());
            }
        }
        return clonedMontoredRegions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Region> getRangedRegions() {
        ArrayList<Region> clonedRangedRegions = new ArrayList<Region>();
        ArrayList<Region> arrayList = this.rangedRegions;
        synchronized (arrayList) {
            for (Region rangedRegion : this.rangedRegions) {
                clonedRangedRegions.add((Region)rangedRegion.clone());
            }
        }
        return clonedRangedRegions;
    }

    protected RangeNotifier getDataRequestNotifier() {
        return this.dataRequestNotifier;
    }

    protected void setDataRequestNotifier(RangeNotifier notifier) {
        this.dataRequestNotifier = notifier;
    }

    private class ConsumerInfo {
        protected boolean isConnected = false;
        protected boolean isInBackground = false;

        private ConsumerInfo() {
        }
    }
}

