/*
 * Copyright (C) 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.glimr.sdk.geofence;

/**
 * This class defines constants used by location sample apps.
 */
public final class KATGeofenceUtils {

    /*
     * Keys for flattened geofences stored in SharedPreferences
     */
    public static final String KEY_LATITUDE = "io.glimr.sdk.geofence.KEY_LATITUDE";

    public static final String KEY_LONGITUDE = "io.glimr.sdk.geofence.KEY_LONGITUDE";

    public static final String KEY_RADIUS = "io.glimr.sdk.geofence.KEY_RADIUS";

    public static final String KEY_TRANSITION_TYPE =
            "io.glimr.sdk.geofence.KEY_TRANSITION_TYPE";

    // The prefix for flattened geofence keys
    public static final String KEY_PREFIX = "io.glimr.sdk.geofence.KEY";

}
