/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import io.gitlab.arturbosch.detekt.cli.CliArgs;
import io.gitlab.arturbosch.detekt.cli.HandledArgumentViolation;
import io.gitlab.arturbosch.detekt.cli.HelpRequest;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u001b\u0010\u0000\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u001a\f\u0010\u0006\u001a\u00020\u0004*\u00020\u0007H\u0002\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\u00012\u0006\u0010\n\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"parseArguments", "Lio/gitlab/arturbosch/detekt/cli/CliArgs;", "args", "", "", "([Ljava/lang/String;)Lio/gitlab/arturbosch/detekt/cli/CliArgs;", "usageAsString", "Lcom/beust/jcommander/JCommander;", "validate", "", "jCommander", "detekt-cli"})
public final class JCommanderKt {
    @NotNull
    public static final CliArgs parseArguments(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        CliArgs cli = new CliArgs();
        JCommander jCommander = new JCommander((Object)cli);
        jCommander.setProgramName("detekt");
        try {
            jCommander.parse(Arrays.copyOf(args, args.length));
        }
        catch (ParameterException ex) {
            throw (Throwable)new HandledArgumentViolation(ex.getMessage(), JCommanderKt.usageAsString(jCommander));
        }
        if (cli.getHelp()) {
            throw (Throwable)new HelpRequest(JCommanderKt.usageAsString(jCommander));
        }
        CliArgs cliArgs = cli;
        boolean bl = false;
        boolean bl2 = false;
        CliArgs $this$apply = cliArgs;
        boolean bl3 = false;
        JCommanderKt.validate($this$apply, jCommander);
        return cliArgs;
    }

    private static final String usageAsString(@NotNull JCommander $this$usageAsString) {
        StringBuilder usage = new StringBuilder();
        $this$usageAsString.getUsageFormatter().usage(usage);
        String string = usage.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"usage.toString()");
        return string;
    }

    private static final void validate(@NotNull CliArgs $this$validate, JCommander jCommander) {
        boolean bl;
        Object object;
        StringBuilder violations = new StringBuilder();
        if ($this$validate.getCreateBaseline() && $this$validate.getBaseline() == null) {
            object = violations;
            String string = "Creating a baseline.xml requires the --baseline parameter to specify a path.";
            bl = false;
            StringBuilder stringBuilder = ((StringBuilder)object).append(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
        }
        if (!$this$validate.getCreateBaseline() && $this$validate.getBaseline() != null) {
            object = $this$validate.getBaseline();
            boolean bl2 = false;
            bl = false;
            bl = false;
            boolean bl3 = false;
            if (object == null) {
                boolean bl4 = false;
                String string = "Required value was null.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            if (Files.notExists((Path)object, new LinkOption[0])) {
                object = violations;
                String string = "The file specified by --baseline should exist '" + $this$validate.getBaseline() + "'.";
                bl = false;
                StringBuilder stringBuilder = ((StringBuilder)object).append(string);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder);
            } else {
                object = $this$validate.getBaseline();
                bl2 = false;
                bl = false;
                bl = false;
                bl3 = false;
                if (object == null) {
                    boolean bl5 = false;
                    String string = "Required value was null.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                if (!Files.isRegularFile((Path)object, new LinkOption[0])) {
                    object = violations;
                    String string = "The path specified by --baseline should be a file '" + $this$validate.getBaseline() + "'.";
                    bl = false;
                    StringBuilder stringBuilder = ((StringBuilder)object).append(string);
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder);
                }
            }
        }
        object = violations;
        boolean bl6 = false;
        if (object.length() > 0) {
            throw (Throwable)new HandledArgumentViolation(violations.toString(), JCommanderKt.usageAsString(jCommander));
        }
    }
}

