/*
 * Decompiled with CFR 0.152.
 */
package com.zsqw123.ksp.inject.plugin;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.pipeline.TransformManager;
import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.impldep.org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\t0\u0004H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0014J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\r*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007\u00a8\u0006\u001b"}, d2={"Lcom/zsqw123/ksp/inject/plugin/BaseTransform;", "Lcom/android/build/api/transform/Transform;", "()V", "getInputTypes", "", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getName", "", "getScopes", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "isIncremental", "", "onTransformed", "", "processDirectory", "inputDirFile", "Ljava/io/File;", "outputDirFile", "processJar", "inputJarFile", "outputJarFile", "transform", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "log", "Lorg/gradle/api/Project;", "msg", "plugin"})
public class BaseTransform
extends Transform {
    @NotNull
    public String getName() {
        return "InjectTrans";
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        Set set = TransformManager.CONTENT_CLASS;
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"CONTENT_CLASS");
        return set;
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getScopes() {
        Set set = TransformManager.SCOPE_FULL_PROJECT;
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"SCOPE_FULL_PROJECT");
        return set;
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(@NotNull TransformInvocation transformInvocation) {
        Intrinsics.checkNotNullParameter((Object)transformInvocation, (String)"transformInvocation");
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        if (!this.isIncremental()) {
            transformInvocation.getOutputProvider().deleteAll();
        }
        for (TransformInput transformInput : transformInvocation.getInputs()) {
            File file;
            for (JarInput jarInput : transformInput.getJarInputs()) {
                File outputJarFile = outputProvider.getContentLocation(jarInput.getName(), jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR);
                if (this.isIncremental() && jarInput.getStatus() == Status.REMOVED) {
                    FileUtils.deleteDirectory((File)outputJarFile);
                } else {
                    FileUtils.copyFile((File)jarInput.getFile(), (File)outputJarFile);
                }
                if (this.isIncremental() && jarInput.getStatus() == Status.REMOVED) continue;
                file = jarInput.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"jarInput.file");
                Intrinsics.checkNotNullExpressionValue((Object)outputJarFile, (String)"outputJarFile");
                this.processJar(file, outputJarFile);
            }
            for (DirectoryInput dirInput : transformInput.getDirectoryInputs()) {
                File outputDir = outputProvider.getContentLocation(dirInput.getName(), dirInput.getContentTypes(), dirInput.getScopes(), Format.DIRECTORY);
                FileUtils.copyDirectory((File)dirInput.getFile(), (File)outputDir);
                file = dirInput.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"dirInput.file");
                Intrinsics.checkNotNullExpressionValue((Object)outputDir, (String)"outputDir");
                this.processDirectory(file, outputDir);
            }
        }
        this.onTransformed();
    }

    protected void processJar(@NotNull File inputJarFile, @NotNull File outputJarFile) {
        Intrinsics.checkNotNullParameter((Object)inputJarFile, (String)"inputJarFile");
        Intrinsics.checkNotNullParameter((Object)outputJarFile, (String)"outputJarFile");
    }

    protected void processDirectory(@NotNull File inputDirFile, @NotNull File outputDirFile) {
        Intrinsics.checkNotNullParameter((Object)inputDirFile, (String)"inputDirFile");
        Intrinsics.checkNotNullParameter((Object)outputDirFile, (String)"outputDirFile");
    }

    protected void onTransformed() {
    }

    public final void log(@NotNull Project $this$log, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)$this$log, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        $this$log.getLogger().log(LogLevel.INFO, msg);
    }
}

