/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhangbinhub.acp.boot.component;

import io.github.zhangbinhub.acp.boot.exceptions.ServerException;
import io.github.zhangbinhub.acp.boot.interfaces.LogAdapter;
import io.github.zhangbinhub.acp.core.CommonTools;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpStatus;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JM\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007\u00a2\u0006\u0002\u0010\u0013JM\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\f2\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007\u00a2\u0006\u0002\u0010\u0013J\u001e\u0010\u0016\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u0015\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/github/zhangbinhub/acp/boot/component/FileDownLoadHandle;", "", "logAdapter", "Lio/github/zhangbinhub/acp/boot/interfaces/LogAdapter;", "(Lio/github/zhangbinhub/acp/boot/interfaces/LogAdapter;)V", "downLoadFile", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "response", "Ljavax/servlet/http/HttpServletResponse;", "filePath", "", "allowPathRegexList", "", "isDelete", "", "deleteWaitTime", "", "(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;Ljava/lang/String;Ljava/util/List;ZLjava/lang/Long;)V", "downLoadForWeb", "path", "pathFilter", "filterRegex", "acp-spring-boot-starter"})
public final class FileDownLoadHandle {
    @NotNull
    private final LogAdapter logAdapter;

    public FileDownLoadHandle(@NotNull LogAdapter logAdapter) {
        Intrinsics.checkNotNullParameter((Object)logAdapter, (String)"logAdapter");
        this.logAdapter = logAdapter;
    }

    @JvmOverloads
    public final void downLoadForWeb(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull String path, @Nullable List<String> allowPathRegexList, boolean isDelete, @Nullable Long deleteWaitTime) throws ServerException {
        String webRootPath;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        String string2 = StringsKt.replace$default((String)path, (String)"/", (String)string, (boolean)false, (int)4, null);
        string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        Object filePath = StringsKt.replace$default((String)string2, (String)"\\", (String)string, (boolean)false, (int)4, null);
        string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        if (!StringsKt.startsWith$default((String)filePath, (String)string, (boolean)false, (int)2, null)) {
            filePath = File.separator + (String)filePath;
        }
        if (!Intrinsics.areEqual((Object)(webRootPath = CommonTools.getWebRootAbsPath()), (Object)File.separator)) {
            filePath = webRootPath + (String)filePath;
        }
        this.downLoadFile(request, response, (String)filePath, allowPathRegexList, isDelete, deleteWaitTime);
    }

    public static /* synthetic */ void downLoadForWeb$default(FileDownLoadHandle fileDownLoadHandle, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, List list, boolean bl, Long l, int n, Object object) throws ServerException {
        if ((n & 8) != 0) {
            list = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            l = null;
        }
        fileDownLoadHandle.downLoadForWeb(httpServletRequest, httpServletResponse, string, list, bl, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmOverloads
    public final void downLoadFile(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull String filePath, @Nullable List<String> allowPathRegexList, boolean isDelete, @Nullable Long deleteWaitTime) throws ServerException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        String string2 = StringsKt.replace$default((String)filePath, (String)"/", (String)string, (boolean)false, (int)4, null);
        string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        String path = StringsKt.replace$default((String)string2, (String)"\\", (String)string, (boolean)false, (int)4, null);
        List filterRegex = new ArrayList();
        if (allowPathRegexList == null || allowPathRegexList.isEmpty()) {
            Object[] objectArray = new String[]{CommonTools.getWebRootAbsPath() + File.separator + "files" + File.separator + "tmp" + File.separator + ".*", CommonTools.getWebRootAbsPath() + File.separator + "files" + File.separator + "upload" + File.separator + ".*", CommonTools.getWebRootAbsPath() + File.separator + "files" + File.separator + "download" + File.separator + ".*"};
            filterRegex.addAll(CollectionsKt.mutableListOf((Object[])objectArray));
        } else {
            filterRegex.addAll((Collection)allowPathRegexList);
        }
        File file = new File(path);
        String string3 = file.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.canonicalPath");
        if (!this.pathFilter(filterRegex, string3)) throw new ServerException("download file failed,the file path is not correct");
        RandomAccessFile fis = null;
        OutputStream toClient = null;
        try {
            if (!file.exists()) {
                throw new ServerException("the file [" + filePath + "] is not exists");
            }
            String filename = file.getName();
            response.reset();
            response.setContentType("application/octet-stream");
            response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(filename, request.getCharacterEncoding()));
            response.setHeader("Accept-Ranges", "bytes");
            long downloadSize = file.length();
            long fromPos = 0L;
            long toPos = 0L;
            if (request.getHeader("Range") == null) {
                response.setContentLengthLong(downloadSize);
            } else {
                long l;
                response.setStatus(HttpStatus.PARTIAL_CONTENT.value());
                String string4 = request.getHeader("Range");
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"request.getHeader(\"Range\")");
                String bytes = StringsKt.replace$default((String)string4, (String)"bytes=", (String)"", (boolean)false, (int)4, null);
                String[] stringArray = new String[]{"-"};
                List ary = StringsKt.split$default((CharSequence)bytes, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                fromPos = Long.parseLong((String)ary.get(0));
                if (ary.size() == 2) {
                    toPos = Long.parseLong((String)ary.get(1));
                }
                if (toPos > fromPos) {
                    l = toPos - fromPos + 1L;
                } else {
                    toPos = downloadSize - 1L;
                    l = downloadSize - fromPos;
                }
                long size = l;
                response.addHeader("Content-Range", "bytes " + fromPos + "-" + toPos + "/" + downloadSize);
                response.setContentLengthLong(size);
            }
            toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            fis = new RandomAccessFile(file, "r");
            if (fromPos > 0L) {
                fis.seek(fromPos);
            }
            byte[] buffer = new byte[2048];
            int count = 0;
            int i = fis.read(buffer);
            while (i != -1) {
                ((BufferedOutputStream)toClient).write(buffer, 0, i);
                count += i;
                i = fis.read(buffer);
            }
            fis.close();
            ((BufferedOutputStream)toClient).flush();
            ((BufferedOutputStream)toClient).close();
            this.logAdapter.debug("download file Success:" + filename);
            if (!isDelete) return;
            CommonTools.doDeleteFile((File)file, (boolean)true, (Long)deleteWaitTime);
            return;
        }
        catch (Exception e) {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    this.logAdapter.error(ex.getMessage(), ex);
                }
            }
            if (toClient != null) {
                try {
                    toClient.close();
                }
                catch (IOException ex) {
                    this.logAdapter.error(ex.getMessage(), ex);
                }
            }
            this.logAdapter.error(e.getMessage(), e);
            throw new ServerException(e.getMessage());
        }
    }

    public static /* synthetic */ void downLoadFile$default(FileDownLoadHandle fileDownLoadHandle, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, List list, boolean bl, Long l, int n, Object object) throws ServerException {
        if ((n & 8) != 0) {
            list = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            l = null;
        }
        fileDownLoadHandle.downLoadFile(httpServletRequest, httpServletResponse, string, list, bl, l);
    }

    private final boolean pathFilter(List<String> filterRegex, String path) {
        String string;
        String $this$pathFilter_u24lambda_u2d0 = string = path;
        boolean bl = false;
        for (String regex : filterRegex) {
            if (!CommonTools.regexPattern((String)StringsKt.replace$default((String)regex, (String)"\\", (String)"/", (boolean)false, (int)4, null), (String)StringsKt.replace$default((String)$this$pathFilter_u24lambda_u2d0, (String)"\\", (String)"/", (boolean)false, (int)4, null))) continue;
            return true;
        }
        return false;
    }

    @JvmOverloads
    public final void downLoadForWeb(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull String path, @Nullable List<String> allowPathRegexList, boolean isDelete) throws ServerException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FileDownLoadHandle.downLoadForWeb$default(this, request, response, path, allowPathRegexList, isDelete, null, 32, null);
    }

    @JvmOverloads
    public final void downLoadForWeb(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull String path, @Nullable List<String> allowPathRegexList) throws ServerException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FileDownLoadHandle.downLoadForWeb$default(this, request, response, path, allowPathRegexList, false, null, 48, null);
    }

    @JvmOverloads
    public final void downLoadForWeb(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull String path) throws ServerException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FileDownLoadHandle.downLoadForWeb$default(this, request, response, path, null, false, null, 56, null);
    }

    @JvmOverloads
    public final void downLoadFile(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull String filePath, @Nullable List<String> allowPathRegexList, boolean isDelete) throws ServerException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        FileDownLoadHandle.downLoadFile$default(this, request, response, filePath, allowPathRegexList, isDelete, null, 32, null);
    }

    @JvmOverloads
    public final void downLoadFile(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull String filePath, @Nullable List<String> allowPathRegexList) throws ServerException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        FileDownLoadHandle.downLoadFile$default(this, request, response, filePath, allowPathRegexList, false, null, 48, null);
    }

    @JvmOverloads
    public final void downLoadFile(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull String filePath) throws ServerException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        FileDownLoadHandle.downLoadFile$default(this, request, response, filePath, null, false, null, 56, null);
    }
}

