/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhangbinhub.acp.boot.tools;

import io.github.zhangbinhub.acp.core.log.LogFactory;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lio/github/zhangbinhub/acp/boot/tools/SpringBeanFactory;", "Lorg/springframework/context/ApplicationContextAware;", "()V", "setApplicationContext", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "Companion", "acp-spring-boot-starter"})
public final class SpringBeanFactory
implements ApplicationContextAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final LogFactory log = LogFactory.Companion.getInstance$default((LogFactory.Companion)LogFactory.Companion, SpringBeanFactory.class, (int)0, (int)2, null);
    @Nullable
    private static WebApplicationContext webApplicationContext;
    @Nullable
    private static ApplicationContext applicationContext;

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        if (SpringBeanFactory.applicationContext == null) {
            SpringBeanFactory.applicationContext = applicationContext;
        }
        log.info("Spring Boot ApplicationContext configuration Success, can be used in a normal class");
    }

    @JvmStatic
    public static final void setWebApplicationContext(@NotNull WebApplicationContext webApplicationContext) {
        Companion.setWebApplicationContext(webApplicationContext);
    }

    @JvmStatic
    @Nullable
    public static final ApplicationContext getApplicationContext() {
        return Companion.getApplicationContext();
    }

    @JvmStatic
    @Nullable
    public static final WebApplicationContext getWebApplicationContext() {
        return Companion.getWebApplicationContext();
    }

    @JvmStatic
    @Nullable
    public static final Object getBean(@NotNull String name) {
        return Companion.getBean(name);
    }

    @JvmStatic
    @Nullable
    public static final <T> T getBean(@NotNull Class<T> clazz) {
        return Companion.getBean(clazz);
    }

    @JvmStatic
    @Nullable
    public static final <T> T getBean(@NotNull String name, @NotNull Class<T> clazz) {
        return Companion.getBean(name, clazz);
    }

    @JvmStatic
    @Nullable
    public static final Object getBean(@NotNull String name, Object ... args) {
        return Companion.getBean(name, args);
    }

    @JvmStatic
    @Nullable
    public static final <T> T getBean(@NotNull Class<T> clazz, Object ... args) {
        return Companion.getBean(clazz, args);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0007J#\u0010\n\u001a\u0004\u0018\u0001H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\rH\u0007\u00a2\u0006\u0002\u0010\u000eJ7\u0010\n\u001a\u0004\u0018\u0001H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\r2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0010\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J+\u0010\n\u001a\u0004\u0018\u0001H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\rH\u0007\u00a2\u0006\u0002\u0010\u0014J+\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0010\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u0015J\n\u0010\u0016\u001a\u0004\u0018\u00010\bH\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/github/zhangbinhub/acp/boot/tools/SpringBeanFactory$Companion;", "", "()V", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "log", "Lio/github/zhangbinhub/acp/core/log/LogFactory;", "webApplicationContext", "Lorg/springframework/web/context/WebApplicationContext;", "getApplicationContext", "getBean", "T", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "args", "", "(Ljava/lang/Class;[Ljava/lang/Object;)Ljava/lang/Object;", "name", "", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", "getWebApplicationContext", "setWebApplicationContext", "", "acp-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void setWebApplicationContext(@NotNull WebApplicationContext webApplicationContext) {
            Intrinsics.checkNotNullParameter((Object)webApplicationContext, (String)"webApplicationContext");
            if (webApplicationContext == null) {
                SpringBeanFactory.webApplicationContext = webApplicationContext;
            }
            log.info("Spring Boot WebApplicationContext configuration Success, can be used in a normal class");
        }

        @JvmStatic
        @Nullable
        public final ApplicationContext getApplicationContext() {
            return applicationContext;
        }

        @JvmStatic
        @Nullable
        public final WebApplicationContext getWebApplicationContext() {
            return webApplicationContext;
        }

        @JvmStatic
        @Nullable
        public final Object getBean(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            ApplicationContext applicationContext = applicationContext;
            if (applicationContext != null) {
                ApplicationContext it = applicationContext;
                boolean bl = false;
                return it.getBean(name);
            }
            WebApplicationContext webApplicationContext = webApplicationContext;
            if (webApplicationContext != null) {
                WebApplicationContext it = webApplicationContext;
                boolean bl = false;
                return it.getBean(name);
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final <T> T getBean(@NotNull Class<T> clazz) {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            ApplicationContext applicationContext = applicationContext;
            if (applicationContext != null) {
                ApplicationContext it = applicationContext;
                boolean bl = false;
                return (T)it.getBean(clazz);
            }
            WebApplicationContext webApplicationContext = webApplicationContext;
            if (webApplicationContext != null) {
                WebApplicationContext it = webApplicationContext;
                boolean bl = false;
                return (T)it.getBean(clazz);
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final <T> T getBean(@NotNull String name, @NotNull Class<T> clazz) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            ApplicationContext applicationContext = applicationContext;
            if (applicationContext != null) {
                ApplicationContext it = applicationContext;
                boolean bl = false;
                return (T)it.getBean(name, clazz);
            }
            WebApplicationContext webApplicationContext = webApplicationContext;
            if (webApplicationContext != null) {
                WebApplicationContext it = webApplicationContext;
                boolean bl = false;
                return (T)it.getBean(name, clazz);
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final Object getBean(@NotNull String name, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            ApplicationContext applicationContext = applicationContext;
            if (applicationContext != null) {
                ApplicationContext it = applicationContext;
                boolean bl = false;
                return it.getBean(name, Arrays.copyOf(args, args.length));
            }
            WebApplicationContext webApplicationContext = webApplicationContext;
            if (webApplicationContext != null) {
                WebApplicationContext it = webApplicationContext;
                boolean bl = false;
                return it.getBean(name, Arrays.copyOf(args, args.length));
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final <T> T getBean(@NotNull Class<T> clazz, Object ... args) {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            ApplicationContext applicationContext = applicationContext;
            if (applicationContext != null) {
                ApplicationContext it = applicationContext;
                boolean bl = false;
                return (T)it.getBean(clazz, Arrays.copyOf(args, args.length));
            }
            WebApplicationContext webApplicationContext = webApplicationContext;
            if (webApplicationContext != null) {
                WebApplicationContext it = webApplicationContext;
                boolean bl = false;
                return (T)it.getBean(clazz, Arrays.copyOf(args, args.length));
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

