/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhangbinhub.acp.boot.tools;

import io.github.zhangbinhub.acp.core.CommonTools;
import io.github.zhangbinhub.acp.core.log.LogFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0013\u001a\u00020\nH\u0007J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/github/zhangbinhub/acp/boot/tools/IpTools;", "", "()V", "log", "Lio/github/zhangbinhub/acp/core/log/LogFactory;", "addressEqual", "", "address", "Ljava/net/InetAddress;", "ipAddress", "", "getIpFromInetAddresses", "getMACAddress", "request", "Ljavax/servlet/http/HttpServletRequest;", "getMACAddressFromIp", "ip", "getRemoteIP", "getRemoteRealIP", "getServerIpStr", "getServerIps", "", "getWebServerIp", "parseByte", "b", "", "acp-spring-boot-starter"})
public final class IpTools {
    @NotNull
    public static final IpTools INSTANCE = new IpTools();
    @NotNull
    private static final LogFactory log = LogFactory.Companion.getInstance$default((LogFactory.Companion)LogFactory.Companion, IpTools.class, (int)0, (int)2, null);

    private IpTools() {
    }

    @JvmStatic
    @NotNull
    public static final List<String> getServerIps() {
        List list;
        List $this$getServerIps_u24lambda_u2d0 = list = (List)new ArrayList();
        boolean bl = false;
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress inetAddress = addresses.nextElement();
                    Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"addresses.nextElement()");
                    $this$getServerIps_u24lambda_u2d0.add(INSTANCE.getIpFromInetAddresses(inetAddress));
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    @JvmStatic
    @NotNull
    public static final String getServerIpStr() {
        return CollectionsKt.joinToString$default((Iterable)INSTANCE.getServerIps(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    @JvmStatic
    @Nullable
    public static final String getRemoteIP(@NotNull HttpServletRequest request) {
        String ipAddress;
        block21: {
            block20: {
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    block14: {
                                        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                                        ipAddress = request.getHeader("X-Forwarded-For");
                                        if (CommonTools.isNullStr((String)ipAddress)) break block14;
                                        String string = ipAddress;
                                        Intrinsics.checkNotNull((Object)string);
                                        if (!StringsKt.equals((String)"unknown", (String)string, (boolean)true)) break block15;
                                    }
                                    ipAddress = request.getHeader("Citrix-Client-IP");
                                }
                                if (CommonTools.isNullStr((String)ipAddress)) break block16;
                                String string = ipAddress;
                                Intrinsics.checkNotNull((Object)string);
                                if (!StringsKt.equals((String)"unknown", (String)string, (boolean)true)) break block17;
                            }
                            ipAddress = request.getHeader("Proxy-Client-IP");
                        }
                        if (CommonTools.isNullStr((String)ipAddress)) break block18;
                        String string = ipAddress;
                        Intrinsics.checkNotNull((Object)string);
                        if (!StringsKt.equals((String)"unknown", (String)string, (boolean)true)) break block19;
                    }
                    ipAddress = request.getHeader("WL-Proxy-Client-IP");
                }
                if (CommonTools.isNullStr((String)ipAddress)) break block20;
                String string = ipAddress;
                Intrinsics.checkNotNull((Object)string);
                if (!StringsKt.equals((String)"unknown", (String)string, (boolean)true)) break block21;
            }
            ipAddress = INSTANCE.getRemoteRealIP(request);
        }
        if (!CommonTools.isNullStr((String)ipAddress)) {
            String string = ipAddress;
            Intrinsics.checkNotNull((Object)string);
            if (string.length() > 15 && StringsKt.contains$default((CharSequence)ipAddress, (CharSequence)",", (boolean)false, (int)2, null)) {
                String string2 = ipAddress.substring(0, StringsKt.indexOf$default((CharSequence)ipAddress, (String)",", (int)0, (boolean)false, (int)6, null));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                ipAddress = string2;
            }
        }
        return ipAddress;
    }

    private final String getRemoteRealIP(HttpServletRequest request) {
        String[] stringArray;
        String ipAddress;
        block15: {
            ipAddress = request.getRemoteAddr();
            if (ipAddress == null) break block15;
            int n = -1;
            switch (ipAddress.hashCode()) {
                case 57585: {
                    if (ipAddress.equals("::1")) {
                        n = 1;
                    }
                    break;
                }
                case 1719016235: {
                    if (ipAddress.equals("0:0:0:0:0:0:0:1")) {
                        n = 1;
                    }
                    break;
                }
                case 1505998205: {
                    if (ipAddress.equals("127.0.0.1")) {
                        n = 1;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    try {
                        stringArray = InetAddress.getLocalHost();
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getLocalHost()");
                        ipAddress = this.getIpFromInetAddresses((InetAddress)stringArray);
                        break;
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        if (!CommonTools.isNullStr((String)ipAddress)) {
            String string = ipAddress;
            Intrinsics.checkNotNull((Object)string);
            if (string.length() > 15 && StringsKt.contains$default((CharSequence)ipAddress, (CharSequence)",", (boolean)false, (int)2, null)) {
                stringArray = new String[]{","};
                ipAddress = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)ipAddress, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            }
        }
        return ipAddress;
    }

    @JvmStatic
    @NotNull
    public static final String getWebServerIp(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = request.getLocalAddr();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.localAddr");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String getMACAddress(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String mac = IpTools.getMACAddressFromIp(IpTools.getWebServerIp(request));
        if (CommonTools.isNullStr((String)mac)) {
            mac = CommonTools.getUuid();
        }
        return mac;
    }

    @JvmStatic
    @NotNull
    public static final String getMACAddressFromIp(@NotNull String ip) {
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        String result = "";
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getNetworkInterfaces()");
            Enumeration<NetworkInterface> netInterfaces = enumeration;
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                boolean isGet = false;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress inetAddress = addresses.nextElement();
                    Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"addresses.nextElement()");
                    if (!INSTANCE.addressEqual(inetAddress, ip)) continue;
                    isGet = true;
                    break;
                }
                if (!isGet) continue;
                StringBuilder sb = new StringBuilder();
                if (ni.getHardwareAddress() != null) {
                    byte[] it;
                    boolean bl = false;
                    if (it.length > 1) {
                        sb.append(INSTANCE.parseByte(it[0])).append("-").append(INSTANCE.parseByte(it[1])).append("-").append(INSTANCE.parseByte(it[2])).append("-").append(INSTANCE.parseByte(it[3])).append("-").append(INSTANCE.parseByte(it[4])).append("-").append(INSTANCE.parseByte(it[5]));
                    }
                }
                String string = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
                String string2 = string.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                result = string2;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result = "";
        }
        return result;
    }

    private final String getIpFromInetAddresses(InetAddress address) {
        String string;
        String hostAddress = address.getHostAddress();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)hostAddress, (String)"hostAddress");
        if (StringsKt.contains$default((CharSequence)hostAddress, (CharSequence)"%", (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{"%"};
            string = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)hostAddress, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        } else {
            string = hostAddress;
        }
        String string2 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"address.hostAddress.let \u2026stAddress\n        }\n    }");
        return string2;
    }

    private final boolean addressEqual(InetAddress address, String ipAddress) {
        String string = this.getIpFromInetAddresses(address);
        InetAddress inetAddress = InetAddress.getByName(ipAddress);
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByName(ipAddress)");
        return Intrinsics.areEqual((Object)string, (Object)this.getIpFromInetAddresses(inetAddress));
    }

    private final String parseByte(byte b) {
        int intValue = b >= 0 ? b : 256 + b;
        String string = Integer.toHexString(intValue);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(intValue)");
        return CommonTools.strFillIn((String)string, (int)2, (int)0, (String)"0");
    }
}

