/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhangbinhub.acp.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import io.github.zhangbinhub.acp.boot.AcpComponentAutoConfiguration;
import io.github.zhangbinhub.acp.boot.aspect.RestControllerAspect;
import io.github.zhangbinhub.acp.boot.component.FileDownLoadHandle;
import io.github.zhangbinhub.acp.boot.component.ServerTools;
import io.github.zhangbinhub.acp.boot.conf.ControllerLogConfiguration;
import io.github.zhangbinhub.acp.boot.interfaces.LogAdapter;
import io.github.zhangbinhub.acp.boot.tools.PackageTools;
import io.github.zhangbinhub.acp.boot.tools.SpringBeanFactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.JacksonProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;
import springfox.documentation.spring.web.plugins.WebFluxRequestHandlerProvider;
import springfox.documentation.spring.web.plugins.WebMvcRequestHandlerProvider;

@Configuration(proxyBeanMethods=false)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0017J\b\u0010\u0010\u001a\u00020\u0011H\u0017J\b\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u0010\u0014\u001a\u00020\u0015H\u0017\u00a8\u0006\u0016"}, d2={"Lio/github/zhangbinhub/acp/boot/AcpComponentAutoConfiguration;", "", "()V", "fileDownLoadHandle", "Lio/github/zhangbinhub/acp/boot/component/FileDownLoadHandle;", "logAdapter", "Lio/github/zhangbinhub/acp/boot/interfaces/LogAdapter;", "jacksonObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "jacksonProperties", "Lorg/springframework/boot/autoconfigure/jackson/JacksonProperties;", "restControllerAspect", "Lio/github/zhangbinhub/acp/boot/aspect/RestControllerAspect;", "controllerLogConfiguration", "Lio/github/zhangbinhub/acp/boot/conf/ControllerLogConfiguration;", "objectMapper", "serverTools", "Lio/github/zhangbinhub/acp/boot/component/ServerTools;", "springBeanFactory", "Lio/github/zhangbinhub/acp/boot/tools/SpringBeanFactory;", "springfoxHandlerProviderBeanPostProcessor", "Lorg/springframework/beans/factory/config/BeanPostProcessor;", "acp-spring-boot-starter"})
public class AcpComponentAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={SpringBeanFactory.class})
    @NotNull
    public SpringBeanFactory springBeanFactory() {
        return new SpringBeanFactory();
    }

    @Primary
    @Bean
    @ConditionalOnMissingBean(value={ObjectMapper.class})
    @ConditionalOnBean(value={JacksonProperties.class})
    @NotNull
    public ObjectMapper jacksonObjectMapper(@NotNull JacksonProperties jacksonProperties) {
        ObjectMapper objectMapper;
        Intrinsics.checkNotNullParameter((Object)jacksonProperties, (String)"jacksonProperties");
        ObjectMapper $this$jacksonObjectMapper_u24lambda_u2d1 = objectMapper = PackageTools.buildJacksonObjectMapper(jacksonProperties);
        boolean bl = false;
        try {
            Class<?> clazz;
            Class<?> clazz2 = clazz = Class.forName("com.fasterxml.jackson.module.kotlin.KotlinModule");
            if (clazz2 != null) {
                Class<?> clazz3;
                Class<?> it = clazz3 = clazz2;
                boolean bl2 = false;
                ExtensionsKt.registerKotlinModule((ObjectMapper)$this$jacksonObjectMapper_u24lambda_u2d1);
            }
        }
        catch (Throwable throwable) {
        }
        return objectMapper;
    }

    @Bean
    @NotNull
    public RestControllerAspect restControllerAspect(@NotNull ControllerLogConfiguration controllerLogConfiguration, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)controllerLogConfiguration, (String)"controllerLogConfiguration");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        return new RestControllerAspect(controllerLogConfiguration, objectMapper);
    }

    @Bean
    @ConditionalOnMissingBean(value={FileDownLoadHandle.class})
    @NotNull
    public FileDownLoadHandle fileDownLoadHandle(@NotNull LogAdapter logAdapter) {
        Intrinsics.checkNotNullParameter((Object)logAdapter, (String)"logAdapter");
        return new FileDownLoadHandle(logAdapter);
    }

    @Bean
    @NotNull
    public ServerTools serverTools() {
        return new ServerTools();
    }

    @Bean
    @ConditionalOnClass(value={WebMvcRequestHandlerProvider.class, WebFluxRequestHandlerProvider.class})
    @NotNull
    public BeanPostProcessor springfoxHandlerProviderBeanPostProcessor() {
        return new BeanPostProcessor(){

            @NotNull
            public Object postProcessAfterInitialization(@NotNull Object bean, @NotNull String beanName) throws BeansException {
                Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
                Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
                if (bean instanceof WebMvcRequestHandlerProvider || bean instanceof WebFluxRequestHandlerProvider) {
                    this.customizeSpringfoxHandlerMappings(this.getHandlerMappings(bean));
                }
                return bean;
            }

            private final void customizeSpringfoxHandlerMappings(Object mappings) {
                if (mappings instanceof ArrayList) {
                    ((ArrayList)mappings).removeIf(springfoxHandlerProviderBeanPostProcessor.1::customizeSpringfoxHandlerMappings$lambda-0);
                }
            }

            private final Object getHandlerMappings(Object bean) {
                Object object;
                try {
                    Object object2;
                    Field field = ReflectionUtils.findField(bean.getClass(), (String)"handlerMappings");
                    if (field == null) {
                        object2 = null;
                    } else {
                        Field it = field;
                        boolean bl = false;
                        it.setAccessible(true);
                        object2 = it.get(bean);
                    }
                    object = object2;
                    object = object == null ? (List)new ArrayList<E>() : object;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                return object;
            }

            private static final boolean customizeSpringfoxHandlerMappings$lambda-0(Object mapping) {
                return mapping instanceof RequestMappingInfoHandlerMapping ? ((RequestMappingInfoHandlerMapping)mapping).getPatternParser() != null : false;
            }
        };
    }
}

