/*
 * Decompiled with CFR 0.152.
 */
package com.youth.banner.transformer;

import android.view.View;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;
import com.youth.banner.transformer.BasePageTransformer;

public class MZScaleInTransformer
extends BasePageTransformer {
    private static final float DEFAULT_MIN_SCALE = 0.85f;
    private float mMinScale = 0.85f;

    public MZScaleInTransformer() {
    }

    public MZScaleInTransformer(float minScale) {
        this.mMinScale = minScale;
    }

    public void transformPage(@NonNull View view, float position) {
        ViewPager2 viewPager = this.requireViewPager(view);
        float paddingLeft = viewPager.getPaddingLeft();
        float paddingRight = viewPager.getPaddingRight();
        float width = viewPager.getMeasuredWidth();
        float offsetPosition = paddingLeft / (width - paddingLeft - paddingRight);
        float currentPos = position - offsetPosition;
        float reduceX = 0.0f;
        float itemWidth = view.getWidth();
        reduceX = (1.0f - this.mMinScale) * itemWidth / 2.0f;
        if (currentPos <= -1.0f) {
            view.setTranslationX(reduceX);
            view.setScaleX(this.mMinScale);
            view.setScaleY(this.mMinScale);
        } else if ((double)currentPos <= 1.0) {
            float scale = (1.0f - this.mMinScale) * Math.abs(1.0f - Math.abs(currentPos));
            float translationX = currentPos * -reduceX;
            if ((double)currentPos <= -0.5) {
                view.setTranslationX(translationX + Math.abs(Math.abs(currentPos) - 0.5f) / 0.5f);
            } else if (currentPos <= 0.0f) {
                view.setTranslationX(translationX);
            } else if ((double)currentPos >= 0.5) {
                view.setTranslationX(translationX - Math.abs(Math.abs(currentPos) - 0.5f) / 0.5f);
            } else {
                view.setTranslationX(translationX);
            }
            view.setScaleX(scale + this.mMinScale);
            view.setScaleY(scale + this.mMinScale);
        } else {
            view.setScaleX(this.mMinScale);
            view.setScaleY(this.mMinScale);
            view.setTranslationX(-reduceX);
        }
    }

    private ViewPager2 requireViewPager(@NonNull View page) {
        ViewParent parent = page.getParent();
        ViewParent parentParent = parent.getParent();
        if (parent instanceof RecyclerView && parentParent instanceof ViewPager2) {
            return (ViewPager2)parentParent;
        }
        throw new IllegalStateException("Expected the page view to be managed by a ViewPager2 instance.");
    }
}

