/*
 * Decompiled with CFR 0.152.
 */
package com.youth.banner.indicator;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.youth.banner.indicator.BaseIndicator;

public class RectangleIndicator
extends BaseIndicator {
    RectF rectF = new RectF();

    public RectangleIndicator(Context context) {
        this(context, null);
    }

    public RectangleIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RectangleIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int count = this.config.getIndicatorSize();
        if (count <= 1) {
            return;
        }
        int space = this.config.getIndicatorSpace() * (count - 1);
        int normal = this.config.getNormalWidth() * (count - 1);
        this.setMeasuredDimension(space + normal + this.config.getSelectedWidth(), this.config.getHeight());
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int count = this.config.getIndicatorSize();
        if (count <= 1) {
            return;
        }
        float left = 0.0f;
        for (int i = 0; i < count; ++i) {
            this.mPaint.setColor(this.config.getCurrentPosition() == i ? this.config.getSelectedColor() : this.config.getNormalColor());
            int indicatorWidth = this.config.getCurrentPosition() == i ? this.config.getSelectedWidth() : this.config.getNormalWidth();
            this.rectF.set(left, 0.0f, left + (float)indicatorWidth, (float)this.config.getHeight());
            left += (float)(indicatorWidth + this.config.getIndicatorSpace());
            canvas.drawRoundRect(this.rectF, (float)this.config.getRadius(), (float)this.config.getRadius(), this.mPaint);
        }
    }
}

