/*
 * Decompiled with CFR 0.152.
 */
package com.youth.banner.indicator;

import android.content.Context;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.youth.banner.config.IndicatorConfig;
import com.youth.banner.indicator.Indicator;

public class BaseIndicator
extends View
implements Indicator {
    protected IndicatorConfig config = new IndicatorConfig();
    protected Paint mPaint = new Paint();
    protected float offset;

    public BaseIndicator(Context context) {
        this(context, null);
    }

    public BaseIndicator(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BaseIndicator(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(0);
        this.mPaint.setColor(this.config.getNormalColor());
    }

    @Override
    @NonNull
    public View getIndicatorView() {
        if (this.config.isAttachToBanner()) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
            switch (this.config.getGravity()) {
                case 0: {
                    layoutParams.gravity = 8388691;
                    break;
                }
                case 1: {
                    layoutParams.gravity = 81;
                    break;
                }
                case 2: {
                    layoutParams.gravity = 0x800055;
                }
            }
            layoutParams.leftMargin = this.config.getMargins().leftMargin;
            layoutParams.rightMargin = this.config.getMargins().rightMargin;
            layoutParams.topMargin = this.config.getMargins().topMargin;
            layoutParams.bottomMargin = this.config.getMargins().bottomMargin;
            this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        return this;
    }

    @Override
    public IndicatorConfig getIndicatorConfig() {
        return this.config;
    }

    @Override
    public void onPageChanged(int count, int currentPosition) {
        this.config.setIndicatorSize(count);
        this.config.setCurrentPosition(currentPosition);
        this.requestLayout();
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        this.offset = positionOffset;
        this.invalidate();
    }

    @Override
    public void onPageSelected(int position) {
        this.config.setCurrentPosition(position);
        this.invalidate();
    }

    @Override
    public void onPageScrollStateChanged(int state) {
    }
}

