/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.searchbar.adapter;

import android.content.Context;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.xm.uilibrary.R;
import java.util.List;

public class SearchResultAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<String> resultList;
    private String startColorStr;
    private String endColorStr;
    private int selectColorId;
    private String currentContent;
    private OnSearchResultClickListener listener;

    public void setCurrentContent(String content) {
        this.currentContent = content;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.xm_ui_adapter_search_result, null));
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        holder.tvResult.setText((CharSequence)Html.fromHtml((String)this.resultList.get(position)));
        if (holder.tvResult.getText().toString().equals(this.currentContent)) {
            holder.ivCheck.setVisibility(0);
        } else {
            holder.ivCheck.setVisibility(8);
        }
    }

    public int getItemCount() {
        return this.resultList == null ? 0 : this.resultList.size();
    }

    public void setData(List<String> dataList, String startColorStr, String endColorStr) {
        this.resultList = dataList;
        this.startColorStr = startColorStr;
        this.endColorStr = endColorStr;
        this.notifyDataSetChanged();
    }

    public void setOnSearchResultClickListener(OnSearchResultClickListener listener) {
        this.listener = listener;
    }

    public static interface OnSearchResultClickListener {
        public void onResultClick(String var1);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView tvResult;
        ImageView ivCheck;

        public ViewHolder(View itemView) {
            super(itemView);
            this.tvResult = (TextView)itemView.findViewById(R.id.tv_result);
            this.ivCheck = (ImageView)itemView.findViewById(R.id.iv_check);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    String content;
                    if (ViewHolder.this.getAdapterPosition() < SearchResultAdapter.this.resultList.size() && SearchResultAdapter.this.listener != null && (content = (String)SearchResultAdapter.this.resultList.get(ViewHolder.this.getAdapterPosition())) != null) {
                        content = content.replace(SearchResultAdapter.this.startColorStr, "");
                        content = content.replace(SearchResultAdapter.this.endColorStr, "");
                        SearchResultAdapter.this.listener.onResultClick(content);
                    }
                }
            });
        }
    }
}

