/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.rectloadingview.animcontroller;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import com.xm.ui.widget.dialog.IAnimController;
import com.xm.ui.widget.rectloadingview.RectLoadingView;

public class DefaultAnimController
implements IAnimController<RectLoadingView> {
    private RectLoadingView view;
    private ValueAnimator[] upAnims;
    private ValueAnimator[] downAnims;
    private long upDuration;
    private long upDelay;
    private long[] downDurations;
    private float[] fractions;
    private boolean needCancel;

    @Override
    public void createAnim(RectLoadingView view) {
        this.view = view;
        this.fractions = view.getFractions();
        this.initDurations(view.getDuration(), this.fractions.length);
        this.upAnims = new ValueAnimator[this.fractions.length];
        this.downAnims = new ValueAnimator[this.fractions.length];
        for (int i = 0; i < this.fractions.length; ++i) {
            this.createUpAnim(i, view);
            this.createDownAnim(i, view);
        }
    }

    private void createUpAnim(final int index, final RectLoadingView view) {
        this.upAnims[index] = ValueAnimator.ofFloat((float[])new float[]{0.1f, 1.0f});
        this.upAnims[index].setDuration(1000L);
        this.upAnims[index].setStartDelay(this.upDelay * (long)index);
        this.upAnims[index].setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        this.upAnims[index].addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                view.setFraction(index, ((Float)animation.getAnimatedValue()).floatValue());
            }
        });
        this.upAnims[index].addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (DefaultAnimController.this.downAnims[index] != null && !DefaultAnimController.this.needCancel) {
                    DefaultAnimController.this.downAnims[index].start();
                }
            }
        });
    }

    private void createDownAnim(final int index, final RectLoadingView view) {
        this.downAnims[index] = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.1f});
        this.downAnims[index].setDuration(this.downDurations[index]);
        this.downAnims[index].setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.downAnims[index].addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                view.setFraction(index, ((Float)animation.getAnimatedValue()).floatValue());
            }
        });
        if (index == 0) {
            this.downAnims[index].addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    if (!DefaultAnimController.this.needCancel) {
                        DefaultAnimController.this.startAnim();
                    }
                }
            });
        }
    }

    private void initDurations(long duration, int rectCount) {
        this.upDuration = 2L * duration / (long)(rectCount + 3);
        this.upDelay = this.upDuration / 2L;
        this.downDurations = new long[rectCount];
        for (int i = 0; i < this.downDurations.length; ++i) {
            this.downDurations[i] = duration - this.upDuration - this.upDelay * (long)i;
        }
    }

    @Override
    public void startAnim() {
        this.needCancel = false;
        if (this.view != null) {
            float[] fractions = this.view.getFractions();
            for (int i = 0; i < fractions.length; ++i) {
                fractions[i] = 0.1f;
            }
            this.view.setFractions(fractions);
        }
        if (this.upAnims != null) {
            for (int i = 0; i < this.upAnims.length; ++i) {
                if (this.upAnims[i] == null) continue;
                this.upAnims[i].start();
            }
        }
    }

    @Override
    public void stopAnim() {
        int i;
        this.needCancel = true;
        if (this.upAnims != null) {
            for (i = 0; i < this.upAnims.length; ++i) {
                if (this.upAnims[i] == null) continue;
                this.upAnims[i].cancel();
            }
        }
        if (this.downAnims != null) {
            for (i = 0; i < this.downAnims.length; ++i) {
                if (this.downAnims[i] == null) continue;
                this.downAnims[i].cancel();
            }
        }
    }

    @Override
    public RectLoadingView getLoadingView() {
        return this.view;
    }
}

