/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.drawgeometry.utils;

import com.xm.ui.widget.drawgeometry.model.GeometryPoints;

public class GeometryUtils {
    public static GeometryPoints getSameAngleDifferRadius(float angle, float radius, GeometryPoints centerPoints) {
        GeometryPoints points = new GeometryPoints(0.0f, 0.0f);
        if (angle >= 0.0f && angle < 90.0f) {
            points.x = (float)Math.sin(Math.toRadians(angle)) * radius + centerPoints.x;
            points.y = -1.0f * (float)Math.cos(Math.toRadians(angle)) * radius + centerPoints.y;
        } else if (angle >= 90.0f && angle < 180.0f) {
            points.x = (float)Math.sin(Math.toRadians(angle)) * radius + centerPoints.x;
            points.y = -1.0f * (float)Math.cos(Math.toRadians(angle)) * radius + centerPoints.y;
        } else if (angle >= 180.0f && angle < 270.0f) {
            points.x = (float)Math.sin(Math.toRadians(angle)) * radius + centerPoints.x;
            points.y = -1.0f * (float)Math.cos(Math.toRadians(angle)) * radius + centerPoints.y;
        } else if (angle >= 270.0f && angle < 360.0f) {
            points.x = (float)Math.sin(Math.toRadians(angle)) * radius + centerPoints.x;
            points.y = -1.0f * (float)Math.cos(Math.toRadians(angle)) * radius + centerPoints.y;
        }
        return points;
    }

    public static double getAngle(double x, double y) {
        switch (GeometryUtils.getQuadrant(x, y)) {
            case 1: {
                return Math.asin(x / Math.hypot(x, y)) * 180.0 / Math.PI;
            }
            case 2: {
                return 360.0 + Math.asin(x / Math.hypot(x, y)) * 180.0 / Math.PI;
            }
            case 3: {
                return 180.0 - Math.asin(x / Math.hypot(x, y)) * 180.0 / Math.PI;
            }
            case 4: {
                return 180.0 - Math.asin(x / Math.hypot(x, y)) * 180.0 / Math.PI;
            }
        }
        return 0.0;
    }

    public static int getQuadrant(double x, double y) {
        if (x >= 0.0) {
            return y >= 0.0 ? 4 : 1;
        }
        return y >= 0.0 ? 3 : 2;
    }

    public static boolean isRotate(GeometryPoints points, GeometryPoints fingerPoints) {
        if (null == points || null == points) {
            return false;
        }
        double distance = Math.hypot(points.x - fingerPoints.x, points.y - fingerPoints.y);
        return distance <= 50.0;
    }

    public static boolean pointInCircular(GeometryPoints centerPoints, GeometryPoints points) {
        double distance = Math.hypot(points.x - centerPoints.x, points.y - centerPoints.y);
        return distance <= (double)centerPoints.radius;
    }
}

