/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xm.UIUtils;
import com.xm.uilibrary.R;

public class ErrorPromptDlg
implements View.OnClickListener {
    Dialog mDlg;
    Activity mActivity;
    View mLayout;
    ViewHolder mViewHolder;
    static ErrorPromptDlg mErrorPromptDlg;
    boolean needFinish = false;

    public static synchronized ErrorPromptDlg getInstance(Activity activity) {
        if (mErrorPromptDlg == null || ErrorPromptDlg.mErrorPromptDlg.mActivity != activity) {
            mErrorPromptDlg = new ErrorPromptDlg(activity);
        }
        return mErrorPromptDlg;
    }

    private ErrorPromptDlg(Activity activity) {
        this.mActivity = activity;
        this.initView();
    }

    void initView() {
        this.mDlg = new Dialog((Context)this.mActivity, R.style.ErrorDialogStyle);
        this.mDlg.setCancelable(true);
        this.mDlg.setCanceledOnTouchOutside(true);
        this.mLayout = LayoutInflater.from((Context)this.mActivity).inflate(R.layout.xm_ui_dlg_error_prompt, null);
        this.mDlg.setContentView(this.mLayout);
        this.mViewHolder = new ViewHolder();
    }

    public ErrorPromptDlg setErrorMsg(String error, String detail, String source, boolean needFinish) {
        this.mViewHolder.error_info_tv.setText((CharSequence)error);
        this.mViewHolder.error_detail_info_text_tv.setText((CharSequence)(this.mActivity.getString(R.string.error) + detail + "(" + source + ")"));
        this.needFinish = needFinish;
        return mErrorPromptDlg;
    }

    public ErrorPromptDlg setErrorMsg(String error, String detail, boolean needFinish) {
        this.mViewHolder.error_info_tv.setText((CharSequence)error);
        this.mViewHolder.error_detail_info_text_tv.setText((CharSequence)(this.mActivity.getString(R.string.error) + detail));
        this.needFinish = needFinish;
        return mErrorPromptDlg;
    }

    public void onDismiss() {
        if (this.mDlg == null || !UIUtils.isTopActivity((Context)this.mActivity)) {
            return;
        }
        if (this.mDlg.isShowing()) {
            this.mDlg.dismiss();
        }
    }

    public void onShow() {
        if (this.mDlg == null || !UIUtils.isTopActivity((Context)this.mActivity)) {
            return;
        }
        if (!this.mDlg.isShowing()) {
            this.mDlg.show();
        }
        ErrorPromptDlg.mErrorPromptDlg.mViewHolder.error_detail_info_text_tv.setVisibility(8);
        ErrorPromptDlg.mErrorPromptDlg.mViewHolder.error_detail_top_line_v.setVisibility(8);
        ErrorPromptDlg.mErrorPromptDlg.mViewHolder.error_detail_info_tv.setVisibility(0);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.error_detail_info_tv) {
            this.mViewHolder.error_detail_info_tv.setVisibility(8);
            this.mViewHolder.error_detail_info_text_tv.setVisibility(0);
            this.mViewHolder.error_detail_top_line_v.setVisibility(0);
        } else if (v.getId() == R.id.layoutRoot || v.getId() == R.id.ok_tv) {
            if (this.needFinish) {
                this.needFinish = false;
                this.mActivity.finish();
            }
            this.onDismiss();
        }
    }

    class ViewHolder {
        TextView error_info_tv;
        TextView error_detail_info_text_tv;
        TextView error_detail_info_tv;
        TextView ok_tv;
        View error_detail_top_line_v;
        LinearLayout error_outside_ll;
        LinearLayout error_inside_ll;

        public ViewHolder() {
            this.error_info_tv = (TextView)ErrorPromptDlg.this.mLayout.findViewById(R.id.error_info_tv);
            this.error_detail_info_text_tv = (TextView)ErrorPromptDlg.this.mLayout.findViewById(R.id.error_detail_info_text_tv);
            this.error_detail_info_tv = (TextView)ErrorPromptDlg.this.mLayout.findViewById(R.id.error_detail_info_tv);
            this.ok_tv = (TextView)ErrorPromptDlg.this.mLayout.findViewById(R.id.ok_tv);
            this.error_detail_top_line_v = ErrorPromptDlg.this.mLayout.findViewById(R.id.error_detail_top_line_v);
            this.error_outside_ll = (LinearLayout)ErrorPromptDlg.this.mLayout.findViewById(R.id.layoutRoot);
            this.error_outside_ll.setOnClickListener((View.OnClickListener)ErrorPromptDlg.this);
            this.error_inside_ll = (LinearLayout)ErrorPromptDlg.this.mLayout.findViewById(R.id.error_inside_ll);
            this.error_inside_ll.setOnClickListener((View.OnClickListener)ErrorPromptDlg.this);
            this.error_detail_info_tv.setOnClickListener((View.OnClickListener)ErrorPromptDlg.this);
            this.ok_tv.setOnClickListener((View.OnClickListener)ErrorPromptDlg.this);
        }
    }
}

