/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.ScaleAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xm.UIUtils;
import com.xm.uilibrary.R;

public class RippleButton
extends RelativeLayout
implements View.OnTouchListener {
    private static final float TEXT_DEFAULT_SIZE = 12.0f;
    private ImageView mNormal;
    private ImageView mWave1;
    private ImageView mWave2;
    private ImageView mWave3;
    private ImageView mBack;
    private TextView mTextView;
    private ViewGroup mLayoutContent;
    private AnimationSet mAnimationSet1;
    private AnimationSet mAnimationSet2;
    private AnimationSet mAnimationSet3;
    private static final int OFFSET = 600;
    private static final int MSG_WAVE2_ANIMATION = 2;
    private static final int MSG_WAVE3_ANIMATION = 3;
    private int[] mImageId = new int[3];
    private int[] mTextId = new int[2];
    private float mTextSize;
    private String mText;
    private int mBtnValue = 0;
    private boolean mUpGestureEnable = true;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    RippleButton.this.mWave2.startAnimation((Animation)RippleButton.this.mAnimationSet2);
                    break;
                }
                case 3: {
                    RippleButton.this.mWave3.startAnimation((Animation)RippleButton.this.mAnimationSet3);
                }
            }
        }
    };
    private View.OnTouchListener mOnTouchLs;

    public RippleButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    public RippleButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    private void initView(Context context, AttributeSet attrs) {
        LayoutInflater.from((Context)context).inflate(R.layout.xm_ui_ripple_tab_btn, (ViewGroup)this, true);
        TypedArray params = context.obtainStyledAttributes(attrs, R.styleable.ButtonCheck);
        this.mImageId[0] = params.getResourceId(R.styleable.ButtonCheck_NormalBkg, 0);
        this.mImageId[1] = params.getResourceId(R.styleable.ButtonCheck_SelectedBkg, 0);
        this.mImageId[2] = params.getResourceId(R.styleable.ButtonCheck_RippleRes, 0);
        this.mTextId[0] = params.getColor(R.styleable.ButtonCheck_TextNormalColor, -16777216);
        this.mTextId[1] = params.getColor(R.styleable.ButtonCheck_TextSelectedColor, -16777216);
        this.mTextSize = params.getDimension(R.styleable.ButtonCheck_TextSize, (float)UIUtils.sp2px(context, 12.0f));
        this.mText = params.getString(R.styleable.ButtonCheck_Text);
        params.recycle();
        this.mAnimationSet1 = this.initAnimationSet();
        this.mAnimationSet2 = this.initAnimationSet();
        this.mAnimationSet3 = this.initAnimationSet();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mNormal = (ImageView)this.findViewById(R.id.iv_ripple_bg);
        this.mWave1 = (ImageView)this.findViewById(R.id.iv_ripple_action_1);
        this.mWave2 = (ImageView)this.findViewById(R.id.iv_ripple_action_2);
        this.mWave3 = (ImageView)this.findViewById(R.id.iv_ripple_action_3);
        this.mTextView = (TextView)this.findViewById(R.id.tab_tv);
        this.mLayoutContent = (ViewGroup)this.findViewById(R.id.fl_content);
        if (this.mText != null) {
            this.mTextView.setText((CharSequence)this.mText);
            this.mTextView.setTextSize(0, this.mTextSize);
            this.mTextView.setTextColor(this.mTextId[this.mBtnValue]);
        } else {
            this.mTextView.setVisibility(8);
        }
        this.mNormal.setOnTouchListener((View.OnTouchListener)this);
        this.mNormal.setImageResource(this.mImageId[0]);
        this.mWave1.setImageResource(this.mImageId[2]);
        this.mWave2.setImageResource(this.mImageId[2]);
        this.mWave3.setImageResource(this.mImageId[2]);
    }

    public void actionDown() {
        this.mBtnValue = 1;
        this.mNormal.setImageResource(this.mImageId[1]);
        this.mWave1.setVisibility(0);
        this.mWave2.setVisibility(0);
        this.mWave3.setVisibility(0);
        this.setPressed(true);
        this.showWaveAnimation();
    }

    public void actionUp() {
        this.mBtnValue = 0;
        this.mNormal.setImageResource(this.mImageId[0]);
        this.mWave1.setVisibility(4);
        this.mWave2.setVisibility(4);
        this.mWave3.setVisibility(4);
        this.setPressed(false);
        this.clearWaveAnimation();
    }

    public void setRippleButtonTextShadowStyle(float shadowX, float shadowY, int shadowColor, float shadowRadius) {
        if (this.mTextView != null) {
            this.mTextView.setShadowLayer(shadowRadius, shadowX, shadowY, shadowColor);
        }
    }

    public void actionCancel() {
        this.mBtnValue = 0;
        this.mNormal.setImageResource(this.mImageId[0]);
        this.mWave1.setVisibility(4);
        this.mWave2.setVisibility(4);
        this.mWave3.setVisibility(4);
        this.setPressed(false);
        this.clearWaveAnimation();
    }

    private AnimationSet initAnimationSet() {
        AnimationSet as = new AnimationSet(true);
        ScaleAnimation sa = new ScaleAnimation(1.0f, 1.5f, 1.0f, 1.5f, 1, 0.5f, 1, 0.5f);
        sa.setDuration(1800L);
        sa.setRepeatCount(-1);
        AlphaAnimation aa = new AlphaAnimation(1.0f, 0.1f);
        aa.setDuration(1800L);
        aa.setRepeatCount(-1);
        as.addAnimation((Animation)sa);
        as.addAnimation((Animation)aa);
        return as;
    }

    public void showWaveAnimation() {
        this.mWave1.startAnimation((Animation)this.mAnimationSet1);
        this.mHandler.sendEmptyMessageDelayed(2, 600L);
        this.mHandler.sendEmptyMessageDelayed(3, 1200L);
    }

    public void clearWaveAnimation() {
        this.mWave1.clearAnimation();
        this.mWave2.clearAnimation();
        this.mWave3.clearAnimation();
        this.mHandler.removeMessages(2);
        this.mHandler.removeMessages(3);
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.actionDown();
                break;
            }
            case 1: 
            case 3: {
                if (!this.mUpGestureEnable) break;
                this.actionCancel();
                break;
            }
        }
        return null == this.mOnTouchLs || this.mOnTouchLs.onTouch(v, event);
    }

    public void setOnTouchListener(View.OnTouchListener ls) {
        this.mOnTouchLs = ls;
    }

    public void setUpGestureEnable(boolean enable) {
        this.mUpGestureEnable = enable;
    }

    public void setTabText(String text) {
        if (this.mTextView != null) {
            this.mTextView.setText((CharSequence)text);
        }
    }

    public boolean isUpGestureEnable() {
        return this.mUpGestureEnable;
    }

    public void clearState() {
        this.mUpGestureEnable = true;
        this.actionCancel();
    }

    public void setMaxHeight(int height) {
        int textHeight = this.mTextView.getHeight();
        ViewGroup.LayoutParams layoutParams = this.mLayoutContent.getLayoutParams();
        if (layoutParams != null) {
            layoutParams.height = height > 0 ? height - textHeight : -2;
        }
        this.mLayoutContent.requestLayout();
    }

    public void setTabTextMargin(int leftMargin, int topMargin, int rightMargin, int bottomMargin) {
        if (this.mTextView != null) {
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.mTextView.getLayoutParams();
            params.setMargins(leftMargin, topMargin, rightMargin, bottomMargin);
            this.mTextView.setLayoutParams((ViewGroup.LayoutParams)params);
            this.mTextView.requestLayout();
        }
    }
}

