/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xm.UIUtils;
import com.xm.uilibrary.R;

public class ButtonTouch
extends LinearLayout {
    private static final float TITLE_TEXT_DEFAULT_SIZE = 12.0f;
    private static final long CLICK_TIMES = 1000L;
    private LinearLayout mLayout;
    private ViewGroup mContentLayout;
    private ImageView mImage = null;
    private TextView mText = null;
    private ImageView mRedTip = null;
    private ImageView mRedSecondTip = null;
    private int[] mImageId = new int[2];
    private int[] mTextId = new int[2];
    private int[] mBgId = new int[2];
    private int[] mPadding = new int[4];
    private int mBtnValue = 0;
    private float bottomTextTopPadding;
    private float mTextSize;
    private String mTextStr;
    private OnTabClickListener mOnTabClickListener;
    private int mPosition;
    private long mCurClickDownTime;
    private int maxLines;
    private int orientation;

    public ButtonTouch(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.xm_ui_bottom_touch_btn, (ViewGroup)this);
        TypedArray params = context.obtainStyledAttributes(attrs, R.styleable.ButtonTouch);
        this.mBtnValue = params.getInteger(R.styleable.ButtonTouch_BtValue, 0);
        this.mImageId[0] = params.getResourceId(R.styleable.ButtonTouch_BtImageNormalBg, 0);
        this.mImageId[1] = params.getResourceId(R.styleable.ButtonTouch_BtImageSelectedBg, 0);
        this.mTextId[0] = params.getColor(R.styleable.ButtonTouch_BtTextNormalColor, 0);
        this.mTextId[1] = params.getColor(R.styleable.ButtonTouch_BtTextSelectedColor, 0);
        this.mBgId[0] = params.getResourceId(R.styleable.ButtonTouch_BtBackgroundNor, 0);
        this.mBgId[1] = params.getResourceId(R.styleable.ButtonTouch_BtBackgroundSel, 0);
        this.mPadding[0] = (int)params.getDimension(R.styleable.ButtonTouch_BtPaddingStart, 0.0f);
        this.mPadding[1] = (int)params.getDimension(R.styleable.ButtonTouch_BtPaddingEnd, 0.0f);
        this.mPadding[2] = (int)params.getDimension(R.styleable.ButtonTouch_BtPaddingTop, 0.0f);
        this.mPadding[3] = (int)params.getDimension(R.styleable.ButtonTouch_BtPaddingBottom, 0.0f);
        this.mTextSize = params.getDimension(R.styleable.ButtonTouch_BtTextSize, (float)UIUtils.sp2px(context, 12.0f));
        this.mTextStr = params.getString(R.styleable.ButtonTouch_BtText);
        this.maxLines = params.getInt(R.styleable.ButtonTouch_BtMaxLines, Integer.MAX_VALUE);
        this.orientation = params.getInt(R.styleable.ButtonTouch_android_orientation, 0);
        this.bottomTextTopPadding = params.getDimension(R.styleable.ButtonTouch_BtBottomTextTopPadding, 0.0f);
        params.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mContentLayout = (ViewGroup)this.findViewById(R.id.rl_button_touch);
        this.mLayout = (LinearLayout)this.findViewById(R.id.ll_layout);
        this.mImage = (ImageView)this.findViewById(R.id.btn_iv);
        this.mText = (TextView)this.findViewById(R.id.btn_tv);
        this.mRedTip = (ImageView)this.findViewById(R.id.red_tip);
        this.mRedSecondTip = (ImageView)this.findViewById(R.id.red_second_tip);
        if (this.mBgId[this.mBtnValue] != 0) {
            this.mContentLayout.setBackgroundResource(this.mBgId[this.mBtnValue]);
        }
        if (this.mTextStr != null) {
            this.mText.setText((CharSequence)this.mTextStr);
            this.mText.setTextSize(0, this.mTextSize);
            this.mText.setTextColor(this.mTextId[this.mBtnValue]);
            this.mText.setMaxLines(this.maxLines);
            this.mText.setEllipsize(TextUtils.TruncateAt.END);
            if (this.bottomTextTopPadding != 0.0f) {
                this.mText.setPadding(0, (int)this.bottomTextTopPadding, 0, 0);
            }
        }
        this.mImage.setImageResource(this.mImageId[this.mBtnValue]);
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                System.out.println("event.getAction()--" + event.getAction());
                switch (event.getAction()) {
                    case 0: {
                        ButtonTouch.this.mCurClickDownTime = System.currentTimeMillis();
                        ButtonTouch.this.mImage.setImageResource(ButtonTouch.this.mImageId[1]);
                        ButtonTouch.this.mText.setTextColor(ButtonTouch.this.mTextId[1]);
                        if (ButtonTouch.this.mBgId[1] == 0) break;
                        ButtonTouch.this.mContentLayout.setBackgroundResource(ButtonTouch.this.mBgId[1]);
                        break;
                    }
                    case 3: {
                        ButtonTouch.this.mImage.setImageResource(ButtonTouch.this.mImageId[ButtonTouch.this.mBtnValue]);
                        ButtonTouch.this.mText.setTextColor(ButtonTouch.this.mTextId[ButtonTouch.this.mBtnValue]);
                        if (ButtonTouch.this.mBgId[0] == 0) break;
                        ButtonTouch.this.mContentLayout.setBackgroundResource(ButtonTouch.this.mBgId[0]);
                        break;
                    }
                    case 1: {
                        ButtonTouch.this.mImage.setImageResource(ButtonTouch.this.mImageId[ButtonTouch.this.mBtnValue]);
                        ButtonTouch.this.mText.setTextColor(ButtonTouch.this.mTextId[ButtonTouch.this.mBtnValue]);
                        if (ButtonTouch.this.mBgId[0] != 0) {
                            ButtonTouch.this.mContentLayout.setBackgroundResource(ButtonTouch.this.mBgId[0]);
                        }
                        long clickTimes = System.currentTimeMillis() - ButtonTouch.this.mCurClickDownTime;
                        System.out.println("event.getAction()--" + clickTimes);
                        if (ButtonTouch.this.mOnTabClickListener == null || clickTimes > 1000L) break;
                        ButtonTouch.this.mOnTabClickListener.onTabClick(v, ButtonTouch.this.mPosition);
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                return true;
            }
        });
        this.mLayout.setOrientation(this.orientation);
        this.mContentLayout.setPadding(this.mPadding[0], this.mPadding[1], this.mPadding[2], this.mPadding[3]);
    }

    public void setValue(int value) {
        this.mBtnValue = value;
        this.mText.setTextColor(this.mTextId[this.mBtnValue]);
        this.mImage.setImageResource(this.mImageId[this.mBtnValue]);
    }

    public int getValue() {
        return this.mBtnValue;
    }

    public void setPosition(int pos) {
        this.mPosition = pos;
    }

    public void setShowRightTopRedTip(boolean isShow) {
        if (this.mRedTip != null) {
            this.mRedTip.setVisibility(isShow ? 0 : 8);
        }
    }

    public void setShowRightRecondRedTip(boolean isShow) {
        if (this.mRedSecondTip != null) {
            this.mRedSecondTip.setVisibility(isShow ? 0 : 8);
        }
    }

    public void setText(CharSequence text) {
        this.mText.setText(text);
    }

    public void setTextColor(int color2) {
        this.mText.setTextColor(color2);
    }

    public void setNormalResource(int resId) {
        this.mImageId[0] = resId;
    }

    public void setSelectResource(int resId) {
        this.mImageId[1] = resId;
    }

    public void setNormalBackground(int resId) {
        this.mBgId[0] = resId;
        this.mContentLayout.setBackgroundResource(this.mBgId[this.mBtnValue]);
    }

    public void setSelectBackground(int resId) {
        this.mBgId[1] = resId;
        this.mContentLayout.setBackgroundResource(this.mBgId[this.mBtnValue]);
    }

    public void setNormalTextColor(int color2) {
        this.mTextId[0] = color2;
    }

    public void setSelectTextColor(int color2) {
        this.mTextId[1] = color2;
    }

    public void setImageResource(int resId) {
        this.mImageId[0] = resId;
        this.mImageId[1] = resId;
        this.mImage.setImageResource(resId);
    }

    public void setOnClick(OnTabClickListener mOnTabClickListener) {
        this.mOnTabClickListener = mOnTabClickListener;
    }

    public static interface OnTabClickListener {
        public void onTabClick(View var1, int var2);
    }
}

