/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.appcompat.widget.AppCompatButton;
import com.xm.uilibrary.R;

public class BtnColorBK
extends AppCompatButton {
    private GradientDrawable[] gradientDrawables = new GradientDrawable[3];

    public BtnColorBK(Context context) {
        super(context, null);
    }

    public BtnColorBK(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray params = context.obtainStyledAttributes(attrs, R.styleable.BtnColorBK);
        float corners = params.getDimension(R.styleable.BtnColorBK_corners, 5.0f);
        int[] colors = new int[]{params.getInteger(R.styleable.BtnColorBK_no_press_solid, this.getResources().getColor(R.color.line_color)), params.getInteger(R.styleable.BtnColorBK_pressed_solid, this.getResources().getColor(R.color.theme_color)), params.getInteger(R.styleable.BtnColorBK_disable_solid, this.getResources().getColor(R.color.hint_color))};
        int strokeColor = params.getInteger(R.styleable.BtnColorBK_stroke_color, -1);
        for (int i = 0; i < colors.length; ++i) {
            this.gradientDrawables[i] = new GradientDrawable();
            this.gradientDrawables[i].setColor(colors[i]);
            this.gradientDrawables[i].setCornerRadius(corners);
            this.gradientDrawables[i].setStroke(1, strokeColor);
        }
        this.setBackground((Drawable)this.gradientDrawables[0]);
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        BtnColorBK.this.setBackground((Drawable)BtnColorBK.this.gradientDrawables[1]);
                        break;
                    }
                    case 1: 
                    case 3: {
                        BtnColorBK.this.setBackground((Drawable)BtnColorBK.this.gradientDrawables[BtnColorBK.this.isSelected() ? 1 : 0]);
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                return false;
            }
        });
        params.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
    }

    public void setEnabled(boolean enabled) {
        try {
            if (enabled) {
                this.setBackgroundDrawable((Drawable)this.gradientDrawables[0]);
            } else {
                this.setBackgroundDrawable((Drawable)this.gradientDrawables[2]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.setEnabled(enabled);
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.setBackgroundDrawable((Drawable)this.gradientDrawables[1]);
        } else {
            this.setBackgroundDrawable((Drawable)this.gradientDrawables[0]);
        }
        super.setSelected(selected);
    }

    public void setNoPressColor(int color2) {
        this.gradientDrawables[0].setColor(color2);
    }

    public void setPressColor(int color2) {
        this.gradientDrawables[1].setColor(color2);
    }
}

