/*
 * Decompiled with CFR 0.152.
 */
package com.xm;

import android.app.ActivityManager;
import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import java.util.List;

public class UIUtils {
    public static int dp2px(Context context, float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static final int sp2px(Context context, float sp) {
        float scale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(sp * scale + 0.5f);
    }

    public static boolean isTopActivity(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List tasksInfo = am.getRunningTasks(100);
        if (tasksInfo.size() > 0) {
            String _className = ((ActivityManager.RunningTaskInfo)tasksInfo.get((int)0)).topActivity.getClassName();
            if (context.getClass().getName().equals(_className)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isTopActivity(Context context, String className) {
        String _className;
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List tasksInfo = am.getRunningTasks(100);
        return tasksInfo.size() > 0 && UIUtils.contains(className, _className = ((ActivityManager.RunningTaskInfo)tasksInfo.get((int)0)).topActivity.getClassName());
    }

    public static boolean contains(CharSequence seq, CharSequence searchSeq) {
        if (seq != null && searchSeq != null) {
            return UIUtils.indexOf(seq, searchSeq, 0) >= 0;
        }
        return false;
    }

    public static int indexOf(CharSequence cs, CharSequence searchChar, int start) {
        return cs.toString().indexOf(searchChar.toString(), start);
    }

    public static boolean contrast(String str1, String str2) {
        if (str1 == null && str2 != null) {
            return false;
        }
        if (str1 != null && str2 == null) {
            return false;
        }
        if (str1 == null && str2 == null) {
            return true;
        }
        return str1.equals(str2);
    }

    public static boolean isStringNULL(String str) {
        return str == null || str.equals("") || str.equals("null");
    }
}

