/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.xm.ui.widget.TreeNode;
import demo.xm.com.libxmfunsdk.R;
import java.util.ArrayList;
import java.util.List;

public class TreeCtrlAdapter
extends BaseAdapter {
    private Context context = null;
    private List<TreeNode> nodeList = new ArrayList<TreeNode>();
    private List<TreeNode> nodeListToShow = new ArrayList<TreeNode>();
    private LayoutInflater inflater = null;
    private TreeNode root = null;

    public TreeCtrlAdapter(Context con, TreeNode Root, int layout2) {
        this.context = con;
        this.inflater = (LayoutInflater)con.getSystemService("layout_inflater");
        this.establishNodeList(Root);
        this.root = Root;
        this.setNodeListToShow();
    }

    public void establishNodeList(TreeNode node) {
        this.nodeList.add(node);
        if (node.isLeafOrNot()) {
            return;
        }
        List<TreeNode> children = node.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            this.establishNodeList(children.get(i));
        }
    }

    public void setNodeListToShow() {
        this.nodeListToShow.clear();
        this.establishNodeListToShow(this.root);
        this.notifyDataSetInvalidated();
    }

    public void establishNodeListToShow(TreeNode node) {
        this.nodeListToShow.add(node);
        if (node.getExpanded() && !node.isLeafOrNot() && node.getChildren() != null) {
            List<TreeNode> children = node.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                this.establishNodeListToShow(children.get(i));
            }
        }
    }

    public void changeNodeExpandOrFold(int position) {
        TreeNode node = this.nodeListToShow.get(position);
        if (node != null) {
            boolean flag = node.getExpanded();
            node.setExpanded(!flag);
        }
    }

    public void Expand(int position, boolean bExpand) {
        TreeNode node = this.nodeListToShow.get(position);
        if (node != null) {
            node.setExpanded(bExpand);
        }
    }

    public TreeNode OnListItemClick(int position) {
        TreeNode node = this.nodeListToShow.get(position);
        if (node.isLeafOrNot()) {
            Toast.makeText((Context)this.context, (CharSequence)"\u8be5\u8282\u70b9\u4e3a\u5b50\u8282\u70b9", (int)0).show();
            return node;
        }
        this.changeNodeExpandOrFold(position);
        this.setNodeListToShow();
        this.notifyDataSetChanged();
        return null;
    }

    public int getCount() {
        return this.nodeListToShow.size();
    }

    public TreeNode getItem(int position) {
        return this.nodeListToShow.get(position);
    }

    public long getItemId(int arg0) {
        return arg0;
    }

    public View getView(int position, View view, ViewGroup parent) {
        Holder holder = null;
        if (view != null) {
            holder = (Holder)view.getTag();
        } else {
            holder = new Holder();
            view = this.inflater.inflate(R.layout.funsdk_treeview_item, null);
            holder.title = (TextView)view.findViewById(R.id.textview_nodeDescription);
            holder.nodeIcon = (ImageView)view.findViewById(R.id.imageview_nodeImage);
            holder.expandOrFoldIcon = (ImageView)view.findViewById(R.id.imageview_expandedImage);
            view.setTag((Object)holder);
        }
        TreeNode node = this.nodeListToShow.get(position);
        holder.title.setText((CharSequence)node.getTitle());
        int icon = node.getIcon();
        if (icon != -1) {
            holder.nodeIcon.setImageResource(icon);
            holder.nodeIcon.setVisibility(0);
        } else {
            holder.nodeIcon.setVisibility(4);
        }
        if (!node.isLeafOrNot()) {
            int expandIcon = node.getExpandOrFoldIcon();
            if (expandIcon == -1) {
                holder.expandOrFoldIcon.setVisibility(4);
            } else {
                holder.expandOrFoldIcon.setImageResource(expandIcon);
                holder.expandOrFoldIcon.setVisibility(0);
            }
        } else {
            holder.expandOrFoldIcon.setVisibility(4);
        }
        view.setPadding(node.getLevel() * 35, 10, 10, 10);
        return view;
    }

    public class Holder {
        TextView title;
        ImageView nodeIcon;
        ImageView expandOrFoldIcon;
    }
}

