/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.LinearLayout;
import android.widget.TextView;
import demo.xm.com.libxmfunsdk.R;

public class XTabBar
extends LinearLayout
implements View.OnClickListener {
    public int mTextColor;
    public int mBkColor;
    OnTabBarClickListener _lister = null;
    View mVC;
    public String[] mTitles = new String[6];
    public TextView[] mTextViews = new TextView[6];
    float mFToX = 0.0f;
    boolean mInited = true;

    public XTabBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.funsdk_xtabbar, (ViewGroup)this);
        TypedArray params = context.obtainStyledAttributes(attrs, R.styleable.XTabBar);
        this.mTitles[0] = params.getString(R.styleable.XTabBar_Text1);
        this.mTitles[1] = params.getString(R.styleable.XTabBar_Text2);
        this.mTitles[2] = params.getString(R.styleable.XTabBar_Text3);
        this.mTitles[3] = params.getString(R.styleable.XTabBar_Text4);
        this.mTitles[4] = params.getString(R.styleable.XTabBar_Text5);
        this.mTitles[5] = params.getString(R.styleable.XTabBar_Text6);
        this.mTextColor = params.getColor(R.styleable.XTabBar_android_textColor, 0xFFFFFF);
        this.mBkColor = params.getColor(R.styleable.XTabBar_tb_backgroud, 4095);
        LinearLayout layout2 = (LinearLayout)this.findViewById(R.id.ll);
        if (this.mBkColor != 0) {
            layout2.setBackgroundColor(this.mBkColor);
        }
        this.setBackgroundColor(this.mBkColor);
        params.recycle();
        this.mVC = this.findViewById(R.id.viewCircle);
        this.SetTitles(this.mTitles);
    }

    public void SetTitles(String[] titles) {
        LinearLayout layout2 = (LinearLayout)this.findViewById(R.id.titleLayout);
        layout2.removeAllViews();
        for (int i = 0; i < titles.length && titles[i] != null && titles[i].length() != 0; ++i) {
            LinearLayout.LayoutParams laParams = new LinearLayout.LayoutParams(-2, -2);
            laParams.weight = 1.0f;
            TextView tv = new TextView(this.getContext());
            tv.setBackgroundColor(this.mBkColor);
            tv.setText((CharSequence)titles[i]);
            tv.setTextSize(16.0f);
            tv.setTextColor(this.mTextColor);
            tv.setGravity(17);
            tv.setLayoutParams((ViewGroup.LayoutParams)laParams);
            layout2.addView((View)tv);
            this.mTextViews[i] = tv;
            tv.setOnClickListener((View.OnClickListener)this);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mInited) {
            this.Selected(0);
            this.mInited = false;
        }
    }

    public void onClick(View v) {
        float fToX = v.getLeft() + v.getWidth() / 2 - (this.mVC.getLeft() + this.mVC.getWidth() / 2);
        TranslateAnimation at = new TranslateAnimation(this.mFToX, fToX, 0.0f, 0.0f);
        this.mFToX = fToX;
        at.setDuration(200L);
        at.setFillAfter(true);
        this.mVC.startAnimation((Animation)at);
        if (this._lister != null) {
            TextView tv = (TextView)v;
            String title = tv.getText().toString();
            int nIndex = this.GetIndexByView((View)tv);
            this._lister.onTabBarClickClick(this, nIndex, title);
        }
    }

    int GetIndexByView(View v) {
        for (int i = 0; i < this.mTextViews.length && this.mTextViews[i] != null; ++i) {
            if (!this.mTextViews[i].equals(v)) continue;
            return i;
        }
        return 0;
    }

    public void Selected(int index) {
        if (index >= 0 && index < this.mTextViews.length && this.mTextViews[index] != null) {
            this.onClick((View)this.mTextViews[index]);
        }
    }

    public void setOnTabBarClickListener(OnTabBarClickListener listener) {
        this._lister = listener;
    }

    public static interface OnTabBarClickListener {
        public void onTabBarClickClick(XTabBar var1, int var2, String var3);
    }
}

