/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xm.ui.widget.BubbleSeekBar;
import demo.xm.com.libxmfunsdk.R;

public class XMSeekBar
extends RelativeLayout {
    private String leftText;
    private String rightText;
    private int max;
    private int progress;
    private int textColor;
    private float textSize;
    private float imageWidth;
    private float imageHeight;
    private int imageLeftResId;
    private int imageRightResId;
    private BubbleSeekBar seekBar;
    private TextView tvLeft;
    private TextView tvRight;
    private ImageView ivLeft;
    private ImageView ivRight;

    public XMSeekBar(Context context) {
        this(context, null);
    }

    public XMSeekBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public XMSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public XMSeekBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        LayoutInflater.from((Context)context).inflate(R.layout.funsdk_layout_xm_seekbar, (ViewGroup)this);
        TypedArray params = context.obtainStyledAttributes(attrs, R.styleable.XMSeekBar);
        this.leftText = params.getString(R.styleable.XMSeekBar_leftText);
        this.rightText = params.getString(R.styleable.XMSeekBar_rightText);
        this.max = params.getInteger(R.styleable.XMSeekBar_android_max, 100);
        this.progress = params.getInteger(R.styleable.XMSeekBar_android_progress, 0);
        this.textColor = params.getResourceId(R.styleable.XMSeekBar_android_textColor, 0);
        this.textSize = params.getDimension(R.styleable.XMSeekBar_android_textSize, 0.0f);
        this.imageWidth = params.getDimension(R.styleable.XMSeekBar_imageWidth, 0.0f);
        this.imageHeight = params.getDimension(R.styleable.XMSeekBar_imageHeight, 0.0f);
        this.imageLeftResId = params.getResourceId(R.styleable.XMSeekBar_leftSrc, 0);
        this.imageRightResId = params.getResourceId(R.styleable.XMSeekBar_rightSrc, 0);
        params.recycle();
    }

    protected void onFinishInflate() {
        ViewGroup.LayoutParams layoutParams;
        super.onFinishInflate();
        this.tvLeft = (TextView)this.findViewById(R.id.seekbar_left_tv);
        this.tvRight = (TextView)this.findViewById(R.id.seekbar_right_tv);
        this.seekBar = (BubbleSeekBar)this.findViewById(R.id.bottom_seekbar);
        this.ivLeft = (ImageView)this.findViewById(R.id.seekbar_left_iv);
        this.ivRight = (ImageView)this.findViewById(R.id.seekbar_right_iv);
        this.tvRight.setText((CharSequence)this.rightText);
        this.tvLeft.setText((CharSequence)this.leftText);
        this.seekBar.setMax(this.max);
        this.seekBar.setProgress(this.progress);
        if (this.textSize != 0.0f) {
            this.tvRight.setTextSize(0, this.textSize);
            this.tvLeft.setTextSize(0, this.textSize);
        }
        if (this.textColor != 0) {
            this.tvRight.setTextColor(this.textColor);
            this.tvLeft.setTextColor(this.textColor);
        }
        if (this.imageWidth != 0.0f) {
            layoutParams = this.ivLeft.getLayoutParams();
            if (layoutParams != null) {
                layoutParams.width = (int)this.imageWidth;
            }
            if ((layoutParams = this.ivRight.getLayoutParams()) != null) {
                layoutParams.width = (int)this.imageWidth;
            }
        }
        if (this.imageHeight != 0.0f) {
            layoutParams = this.ivLeft.getLayoutParams();
            if (layoutParams != null) {
                layoutParams.height = (int)this.imageHeight;
            }
            if ((layoutParams = this.ivRight.getLayoutParams()) != null) {
                layoutParams.height = (int)this.imageHeight;
            }
        }
        if (this.imageLeftResId > 0) {
            this.ivLeft.setImageResource(this.imageLeftResId);
        }
        if (this.imageRightResId > 0) {
            this.ivRight.setImageResource(this.imageRightResId);
        }
    }

    public void setLeftText(String leftText) {
        if (this.tvLeft != null) {
            this.tvLeft.setText((CharSequence)leftText);
        }
    }

    public void setRightText(String rightText) {
        if (this.tvRight != null) {
            this.tvRight.setText((CharSequence)rightText);
        }
    }

    public void setMax(int max) {
        if (this.seekBar != null) {
            this.seekBar.setMax(max);
        }
    }

    public void setProgress(int progress) {
        if (this.seekBar != null) {
            this.seekBar.setProgress(progress);
        }
    }

    public int getProgress() {
        if (this.seekBar != null) {
            return this.seekBar.getProgress();
        }
        return 0;
    }

    public void setLeftSrc(int resId) {
        if (resId > 0) {
            this.imageLeftResId = resId;
            this.ivLeft.setImageResource(resId);
        }
    }

    public void setRightSrc(int resId) {
        if (resId > 0) {
            this.imageRightResId = resId;
            this.ivRight.setImageResource(resId);
        }
    }

    public BubbleSeekBar getSeekBar() {
        return this.seekBar;
    }

    public TextView getTvLeft() {
        return this.tvLeft;
    }

    public TextView getTvRight() {
        return this.tvRight;
    }
}

