/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Vibrator;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AnimationUtils;
import androidx.annotation.Nullable;
import com.utils.XUtils;
import com.xm.ui.widget.ImageTextView;
import com.xm.ui.widget.data.BubbleIndicator;
import com.xm.ui.widget.drawgeometry.model.GeometryPoints;
import demo.xm.com.libxmfunsdk.R;
import java.util.ArrayList;
import java.util.List;

public class XMScaleSeekBar
extends View {
    private Paint paint;
    private float pointRadius;
    private int curItemPos = 0;
    private int bgColorId;
    private int pointColor;
    private int subCount;
    private int smallSubCount = 5;
    private List<GeometryPoints> itemPoints;
    private BubbleIndicator mBubbleIndicator;
    private View mPopupView;
    private int vibratePos;
    private OnScaleSeekBarListener scaleSeekBarListener;

    public XMScaleSeekBar(Context context) {
        this(context, null);
    }

    public XMScaleSeekBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public XMScaleSeekBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public XMScaleSeekBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray params = context.obtainStyledAttributes(attrs, R.styleable.ScaleSeekBar);
        if (params != null) {
            this.bgColorId = params.getInteger(R.styleable.ScaleSeekBar_android_itemBackground, this.getResources().getColor(R.color.wnd_cover_gray));
            this.pointColor = params.getResourceId(R.styleable.ScaleSeekBar_pointColor, -1);
            this.subCount = params.getInteger(R.styleable.ScaleSeekBar_subCount, 7);
            this.curItemPos = params.getInteger(R.styleable.ScaleSeekBar_android_progress, 0);
            params.recycle();
        }
        this.paint = new Paint();
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setAntiAlias(true);
        this.paint.setTextSize((float)XUtils.sp2px(this.getContext(), 8.0f));
        this.itemPoints = new ArrayList<GeometryPoints>();
        this.mBubbleIndicator = new BubbleIndicator(context);
        this.mBubbleIndicator.createImageTextViewFloater(context, attrs, defStyleAttr, "100");
    }

    public void setSmallSubCount(int count) {
        this.smallSubCount = count;
        this.postInvalidate();
    }

    public int getSmallSubCount() {
        return this.smallSubCount;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.itemPoints.clear();
        this.paint.setColor(this.bgColorId);
        float itemHeight = (float)this.getHeight() / 3.0f;
        RectF rectF = new RectF((float)this.getPaddingStart(), itemHeight, (float)(this.getWidth() - this.getPaddingEnd()), itemHeight * 2.0f);
        canvas.drawRoundRect(rectF, 50.0f, 50.0f, this.paint);
        this.paint.setColor(this.pointColor);
        float itemWidth = ((float)this.getWidth() - itemHeight - (float)this.getPaddingStart() - (float)this.getPaddingEnd()) / (float)this.subCount;
        this.pointRadius = itemHeight / 2.0f - 5.0f;
        float textHeightOffset = -(this.paint.ascent() + this.paint.descent()) * 0.5f;
        for (int i = 0; i <= this.subCount; ++i) {
            float cx;
            String content;
            float itemCx = itemHeight / 2.0f + (float)i * itemWidth + (float)this.getPaddingStart();
            canvas.drawCircle(itemCx, (float)this.getHeight() / 2.0f, this.pointRadius, this.paint);
            this.itemPoints.add(new GeometryPoints(itemCx, (float)this.getHeight() / 2.0f));
            float smallPointRadius = this.pointRadius / ((float)this.smallSubCount * 1.0f);
            float smallItemWidth = (itemWidth - this.pointRadius * 2.0f) / ((float)this.smallSubCount * 1.0f);
            if (i < this.subCount) {
                for (int j = 1; j < this.smallSubCount; ++j) {
                    float itemSmallCx = this.pointRadius + itemCx + smallItemWidth * (float)j;
                    canvas.drawCircle(itemSmallCx, ((float)this.getHeight() - smallPointRadius) / 2.0f, smallPointRadius, this.paint);
                    this.itemPoints.add(new GeometryPoints(itemSmallCx, (float)this.getHeight() / 2.0f));
                }
            }
            if (i != this.curItemPos / this.smallSubCount) continue;
            if (this.curItemPos % this.smallSubCount == 0) {
                content = i + 1 + "X";
                cx = itemCx;
            } else {
                cx = this.pointRadius + itemCx + smallItemWidth * (float)(this.curItemPos % this.smallSubCount);
                content = String.format("%.1fX", Float.valueOf((float)this.curItemPos / ((float)this.smallSubCount * 1.0f) + 1.0f));
            }
            float textWidth = this.paint.measureText(content);
            this.paint.setColor(this.getResources().getColor(R.color.gray_424242));
            canvas.drawCircle(cx, (float)this.getHeight() / 2.0f, (float)this.getHeight() / 2.5f, this.paint);
            this.paint.setColor(this.pointColor);
            canvas.drawText(content, cx - textWidth / 2.0f, (float)this.getHeight() / 2.0f + textHeightOffset, this.paint);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.mBubbleIndicator != null) {
            this.mBubbleIndicator.changeScreenSize(w, h);
        }
        super.onSizeChanged(w, h, oldw, oldh);
    }

    private void vibrate() {
        Vibrator vibrator = (Vibrator)this.getContext().getSystemService("vibrator");
        vibrator.vibrate(40L);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.dealWithItemSelected(new GeometryPoints(event.getX(), event.getY()));
                this.showIndicator(0);
                break;
            }
            case 2: {
                GeometryPoints itemPos;
                boolean isSelected = this.dealWithItemSelected(new GeometryPoints(event.getX(), (float)(this.getHeight() / 2)));
                if (!isSelected || (itemPos = this.itemPoints.get(this.curItemPos)) == null) break;
                this.mBubbleIndicator.moveIndicator((float)((int)itemPos.x), String.format("%.1fX", Float.valueOf((float)this.curItemPos / ((float)this.smallSubCount * 1.0f) + 1.0f)));
                break;
            }
            case 1: 
            case 3: {
                this.vibratePos = -1;
                this.mBubbleIndicator.hideIndicator();
                if (this.scaleSeekBarListener == null) break;
                this.scaleSeekBarListener.onItemSelected(this.curItemPos, true);
                break;
            }
        }
        return true;
    }

    private boolean dealWithItemSelected(GeometryPoints touchPoint) {
        for (int i = 0; i < this.itemPoints.size(); ++i) {
            if (!this.isTouchPoint(touchPoint, this.itemPoints.get(i))) continue;
            if (this.vibratePos != i) {
                this.vibrate();
                this.vibratePos = i;
            }
            if (this.curItemPos != i) {
                this.curItemPos = i;
                this.postInvalidate();
                if (this.scaleSeekBarListener != null) {
                    this.scaleSeekBarListener.onItemSelected(this.curItemPos, false);
                }
            }
            return true;
        }
        return false;
    }

    private boolean isTouchPoint(GeometryPoints centerPoints, GeometryPoints fingerPoints) {
        if (null == centerPoints) {
            return false;
        }
        double distance = Math.hypot(centerPoints.x - fingerPoints.x, centerPoints.y - fingerPoints.y);
        return distance < (double)(this.getHeight() / 3);
    }

    public void setProgress(int progress) {
        if (progress >= 0) {
            this.curItemPos = progress;
            this.curItemPos = Math.min(this.curItemPos, this.subCount * this.smallSubCount);
            this.curItemPos = Math.max(this.curItemPos, 0);
        }
        this.postInvalidate();
    }

    public int getProgress() {
        return this.curItemPos;
    }

    public void showIndicator(int direction) {
        if (this.curItemPos < 0 || this.curItemPos >= this.itemPoints.size()) {
            return;
        }
        GeometryPoints itemPos = this.itemPoints.get(this.curItemPos);
        if (itemPos != null) {
            this.mBubbleIndicator.setDirection(direction);
            this.mPopupView = this.mBubbleIndicator.showIndicator((View)this, itemPos.x);
            if (this.mPopupView instanceof ImageTextView) {
                ((ImageTextView)this.mPopupView).setImageResource(R.drawable.ic_water);
                this.mPopupView.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.show_scale_animation));
            }
        }
    }

    public void showIndicator(int direction, int backgroundColor) {
        if (this.curItemPos < 0 || this.curItemPos >= this.itemPoints.size()) {
            return;
        }
        GeometryPoints itemPos = this.itemPoints.get(this.curItemPos);
        if (itemPos != null) {
            this.mBubbleIndicator.setDirection(direction);
            this.mBubbleIndicator.showIndicator((View)this, itemPos.x, backgroundColor);
        }
    }

    public void moveIndicator() {
        if (this.curItemPos < 0 || this.curItemPos >= this.itemPoints.size()) {
            return;
        }
        GeometryPoints itemPos = this.itemPoints.get(this.curItemPos);
        if (itemPos != null) {
            this.mBubbleIndicator.moveIndicator((float)((int)itemPos.x), this.getProgress());
        }
    }

    public void moveIndicator(String content) {
        if (this.curItemPos < 0 || this.curItemPos >= this.itemPoints.size()) {
            return;
        }
        GeometryPoints itemPos = this.itemPoints.get(this.curItemPos);
        if (itemPos != null) {
            this.mBubbleIndicator.moveIndicator(itemPos.x, content);
        }
    }

    public void hideIndicator() {
        this.mBubbleIndicator.hideIndicator();
    }

    public void setSubCount(int subCount) {
        this.subCount = subCount;
        this.postInvalidate();
    }

    public int getSubCount() {
        return this.subCount;
    }

    public void setOnScaleSeekBarListener(OnScaleSeekBarListener listener) {
        this.scaleSeekBarListener = listener;
    }

    public static interface OnScaleSeekBarListener {
        public void onItemSelected(int var1, boolean var2);
    }
}

