/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.lib.FunSDK;
import com.utils.XUtils;
import com.xm.ui.widget.ButtonCheck;
import demo.xm.com.libxmfunsdk.R;

public class XMEditText
extends LinearLayout {
    private String editHint = "";
    private String editText = "";
    private String editAfterAnimationHint = "";
    private int rightSrcNorId;
    private int rightSrcSelId;
    private int editHintColorId;
    private int editTextColorId;
    private int editBgSrcId;
    private int inputMaxLength;
    private int gravity;
    private float editTextSize;
    private float editHeight;
    private boolean isHintAnimation;
    private boolean isEditable = true;
    private boolean isHintFlashing;
    private boolean isShowTopHint = true;
    private boolean isShowRightBtn = true;
    private boolean isInitShowBtn = true;
    private EditText etInput;
    private ButtonCheck btnRight;
    private TextView tvHintAnimation;
    private TextView tvHint;
    private TextView tvHintFixed;
    private TextWatcher textWatcher;
    private RelativeLayout rlEditBg;

    public XMEditText(Context context) {
        this(context, null);
    }

    public XMEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public XMEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        LayoutInflater.from((Context)context).inflate(R.layout.funsdk_layout_xm_edittext, (ViewGroup)this, true);
        TypedArray params = context.obtainStyledAttributes(attrs, R.styleable.XMEditText);
        this.editHeight = params.getDimension(R.styleable.XMEditText_editHeight, (float)XUtils.dp2px(context, 49));
        this.editHint = params.getString(R.styleable.XMEditText_android_hint);
        this.editHintColorId = params.getColor(R.styleable.XMEditText_android_textColorHint, context.getResources().getColor(R.color.hint_color));
        this.rightSrcNorId = params.getResourceId(R.styleable.XMEditText_rightSrcNor, R.drawable.ic_close_nor);
        this.rightSrcSelId = params.getResourceId(R.styleable.XMEditText_rightSrcSel, R.drawable.ic_close_sel);
        this.editText = params.getString(R.styleable.XMEditText_android_text);
        this.editTextColorId = params.getColor(R.styleable.XMEditText_android_textColor, context.getResources().getColor(R.color.default_normal_text_color));
        this.editTextSize = params.getDimension(R.styleable.XMEditText_android_textSize, (float)XUtils.sp2px(context, 12.0f));
        this.isHintAnimation = params.getBoolean(R.styleable.XMEditText_hintAnimation, false);
        this.editAfterAnimationHint = params.getString(R.styleable.XMEditText_afterAnimationHint);
        this.inputMaxLength = params.getInteger(R.styleable.XMEditText_android_maxLength, 256);
        this.isShowTopHint = params.getBoolean(R.styleable.XMEditText_showTopHint, true);
        this.editBgSrcId = params.getResourceId(R.styleable.XMEditText_android_background, R.drawable.bg_edittext);
        this.gravity = params.getInteger(R.styleable.XMEditText_android_gravity, 8388627);
        this.isShowRightBtn = params.getBoolean(R.styleable.XMEditText_showRightBtn, true);
        this.isInitShowBtn = params.getBoolean(R.styleable.XMEditText_showBtnInit, true);
        params.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.initView();
        this.initData();
        this.initListener();
    }

    private void initView() {
        this.etInput = (EditText)this.findViewById(R.id.et_input);
        this.btnRight = (ButtonCheck)this.findViewById(R.id.btn_clear);
        this.tvHint = (TextView)this.findViewById(R.id.tv_hint);
        this.tvHintAnimation = (TextView)this.findViewById(R.id.tv_hint_animation);
        this.tvHintFixed = (TextView)this.findViewById(R.id.tv_hint_fixed);
        this.rlEditBg = (RelativeLayout)this.findViewById(R.id.rl_edit_bg);
    }

    private void initData() {
        this.etInput.setText((CharSequence)this.editText);
        this.etInput.setTextColor(this.editTextColorId);
        this.etInput.setTextSize(0, this.editTextSize);
        this.etInput.setHint((CharSequence)FunSDK.TS((String)this.editHint));
        this.etInput.setHintTextColor(this.editHintColorId);
        this.etInput.setFilters(new InputFilter[]{new InputFilter.LengthFilter(this.inputMaxLength)});
        this.tvHintAnimation.setText((CharSequence)FunSDK.TS((String)this.editHint));
        ViewGroup.LayoutParams layoutParams = this.etInput.getLayoutParams();
        if (layoutParams != null) {
            layoutParams.height = (int)this.editHeight;
        }
        this.btnRight.setNormalBg(this.rightSrcNorId);
        this.btnRight.setSelectedBg(this.rightSrcSelId);
        if (this.isShowTopHint) {
            this.tvHint.setVisibility(4);
            this.tvHintFixed.setVisibility(4);
            this.tvHint.setText((CharSequence)FunSDK.TS((String)this.editHint));
        } else {
            this.tvHint.setVisibility(8);
            this.tvHintFixed.setVisibility(8);
        }
        if (this.editBgSrcId != 0) {
            this.rlEditBg.setBackgroundResource(this.editBgSrcId);
        }
        if (this.isShowRightBtn && this.isInitShowBtn) {
            this.btnRight.setVisibility(0);
        } else {
            this.btnRight.setVisibility(8);
        }
        this.etInput.setGravity(this.gravity);
    }

    private void initListener() {
        this.btnRight.setOnButtonClick(new ButtonCheck.OnButtonClickListener(){

            public boolean onButtonClick(ButtonCheck bc, boolean bBeforeChecked) {
                XMEditText.this.etInput.setText((CharSequence)"");
                return false;
            }
        });
        this.etInput.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 0) {
                    XMEditText.this.showTitleHint();
                }
                return false;
            }
        });
        this.etInput.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                if (XMEditText.this.textWatcher != null) {
                    XMEditText.this.textWatcher.beforeTextChanged(s, start, count, after);
                }
                if (XMEditText.this.isHintFlashing) {
                    String hint = String.format("%s(%s)", FunSDK.TS((String)XMEditText.this.editHint), FunSDK.TS((String)XMEditText.this.editAfterAnimationHint));
                    XMEditText.this.tvHint.setText((CharSequence)hint);
                    XMEditText.this.tvHint.setTextColor(XMEditText.this.getResources().getColor(R.color.default_normal_text_color));
                    XMEditText.this.tvHint.clearAnimation();
                    XMEditText.this.isHintFlashing = false;
                }
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (XMEditText.this.textWatcher != null) {
                    XMEditText.this.textWatcher.onTextChanged(s, start, before, count);
                }
            }

            public void afterTextChanged(Editable editable) {
                if (XMEditText.this.textWatcher != null) {
                    XMEditText.this.textWatcher.afterTextChanged(editable);
                }
                if (!XMEditText.this.isEditable) {
                    return;
                }
                if (!XMEditText.this.isShowRightBtn || TextUtils.isEmpty((CharSequence)editable.toString())) {
                    XMEditText.this.btnRight.setVisibility(8);
                } else {
                    XMEditText.this.btnRight.setVisibility(0);
                }
            }
        });
    }

    private void showTitleHint() {
        if (!this.isHintAnimation) {
            return;
        }
        if (this.tvHint.getVisibility() != 0) {
            this.tvHint.setVisibility(0);
            final AnimationSet animationSet = new AnimationSet(true);
            TranslateAnimation translateAnimation = new TranslateAnimation((float)this.tvHintAnimation.getLeft(), (float)this.tvHint.getLeft(), (float)(this.tvHintAnimation.getTop() + this.tvHintAnimation.getHeight()), 0.0f);
            AlphaAnimation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
            animationSet.addAnimation((Animation)translateAnimation);
            animationSet.addAnimation((Animation)alphaAnimation);
            animationSet.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
            animationSet.setDuration(1000L);
            animationSet.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    if (!TextUtils.isEmpty((CharSequence)XMEditText.this.editAfterAnimationHint)) {
                        XMEditText.this.etInput.setHint((CharSequence)FunSDK.TS((String)XMEditText.this.editAfterAnimationHint));
                        String hint = String.format("%s(%s)", FunSDK.TS((String)XMEditText.this.editHint), FunSDK.TS((String)XMEditText.this.editAfterAnimationHint));
                        XMEditText.this.tvHint.setText((CharSequence)hint);
                        XMEditText.this.tvHintFixed.setText((CharSequence)hint);
                    }
                }

                public void onAnimationEnd(Animation animation) {
                    animationSet.cancel();
                    XMEditText.this.tvHint.clearAnimation();
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            animationSet.setFillAfter(true);
            this.tvHint.startAnimation((Animation)animationSet);
        }
    }

    public void setEditHint(String hint) {
        this.editHint = hint;
        this.etInput.setHint((CharSequence)hint);
    }

    public void setEditHintColor(int colorId) {
        this.editHintColorId = colorId;
        this.etInput.setTextColor(this.editHintColorId);
    }

    public void setEditText(String editText) {
        if (editText != null && this.etInput != null) {
            this.editText = editText;
            this.etInput.setText((CharSequence)editText);
            this.etInput.setSelection(this.etInput.getText().length());
        }
    }

    public String getEditText() {
        return this.etInput.getText().toString().trim();
    }

    public EditText getEditView() {
        return this.etInput;
    }

    public void setEditTextSize(int textSize) {
        this.editTextSize = textSize;
        this.etInput.setTextSize(this.editTextSize);
    }

    public void setEditTextColor(int colorId) {
        this.editTextColorId = colorId;
        this.etInput.setTextColor(this.editTextColorId);
    }

    public void setRightSrcNorId(int srcId) {
        this.rightSrcNorId = srcId;
        this.btnRight.setNormalBg(srcId);
    }

    public void setRightSrcSelId(int srcId) {
        this.rightSrcSelId = srcId;
        this.btnRight.setSelectedBg(srcId);
    }

    public void setEditAfterAnimationHint(String hint) {
        this.editAfterAnimationHint = hint;
        this.etInput.setHint((CharSequence)FunSDK.TS((String)this.editAfterAnimationHint));
        String afterHint = String.format("%s(%s)", FunSDK.TS((String)this.editHint), FunSDK.TS((String)this.editAfterAnimationHint));
        this.tvHint.setText((CharSequence)afterHint);
        this.tvHintFixed.setText((CharSequence)afterHint);
    }

    public void addTextChangedListener(TextWatcher textWatcher) {
        this.textWatcher = textWatcher;
    }

    public void setInputType(int inputType) {
        this.etInput.setInputType(inputType);
    }

    public void setEditable(boolean editable) {
        this.isEditable = editable;
        this.etInput.setEnabled(editable);
        this.etInput.setFocusable(editable);
        this.etInput.setFocusableInTouchMode(editable);
        this.btnRight.setVisibility(editable && this.isShowRightBtn ? 0 : 8);
        if (!editable) {
            this.showTitleHint();
        }
    }

    public void setHintAndFlashing(String hint, boolean flashing) {
        this.tvHint.setText((CharSequence)hint);
        if (flashing) {
            this.isHintFlashing = flashing;
            this.tvHint.setTextColor(this.getResources().getColor(R.color.invalid_red));
            this.tvHint.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.hint_alpha_animation));
        }
    }
}

