/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.XImages;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.ThumbnailUtils;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import com.xm.ui.base.APP;
import com.xm.ui.widget.XImages.IImagesAdapter;
import com.xm.ui.widget.listener.OnSelectedImageListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;

public class XImagesAdapter
extends BaseAdapter
implements View.OnClickListener {
    static int N_IMAGE_SIZE = 0;
    View[] _images = null;
    ImageItem[] _tags = null;
    ArrayList<ImageItem> _tasks = new ArrayList();
    ArrayList<String> _fileList = new ArrayList();
    int _index = 0;
    final int SELECTED_ALPHA = 196;
    OnSelectedImageListener _listener;
    Context _context;
    Handler _handler;
    boolean _bRunning = true;
    IImagesAdapter _adapter;
    static final int N_BUF_PAGE_COUNT = 3;
    static final int N_COLUM_COUNT = 4;
    int _nOnePage = 0;
    int _nDealBmpCount = 0;
    Bitmap _defBmp = null;
    int _nCurPostion = 0;
    int _nLastPostion = -1;
    int _nStartPosition = 0;
    int _nEndPosition = 0;

    public XImagesAdapter(Context context, IImagesAdapter adapter) {
        int i;
        this._context = context;
        this._adapter = adapter;
        int nItemHeight = APP.GetScreenWidth() / 4;
        this._nOnePage = (APP.GetScreenHeight() + nItemHeight / 2) / nItemHeight * 4;
        N_IMAGE_SIZE = 3 * this._nOnePage;
        System.out.println("N_IMAGE_SIZE:" + N_IMAGE_SIZE);
        this._images = new View[N_IMAGE_SIZE];
        this._tags = new ImageItem[N_IMAGE_SIZE];
        for (i = 0; i < N_IMAGE_SIZE; ++i) {
            this._images[i] = adapter.NewView(context);
            ImageView iv = adapter.GetImageView(this._images[i]);
            iv.setAdjustViewBounds(true);
            iv.setScaleType(ImageView.ScaleType.FIT_XY);
            ImageItem item = new ImageItem();
            item.nPosiotion = -1;
            item.nImageIndex = i;
            this._tags[i] = item;
        }
        this._handler = new Handler(){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                if (msg.what == 1) {
                    --XImagesAdapter.this._nDealBmpCount;
                    ImageItem item = (ImageItem)msg.obj;
                    ImageItem curitem = XImagesAdapter.this._tags[item.nImageIndex];
                    if (item.bmp != null && curitem.nPosiotion == item.nPosiotion) {
                        ImageView iv = XImagesAdapter.this._adapter.GetImageView(XImagesAdapter.this._images[item.nImageIndex]);
                        if (iv != null) {
                            if (XImagesAdapter.this._tags[item.nImageIndex].bmp != null) {
                                XImagesAdapter.this._tags[item.nImageIndex].bmp = null;
                            }
                            XImagesAdapter.this._tags[item.nImageIndex].bmp = item.bmp;
                            iv.setImageBitmap(XImagesAdapter.this._tags[item.nImageIndex].bmp);
                        }
                        item.bmp = null;
                        item = null;
                        System.gc();
                    }
                }
            }
        };
        for (i = 0; i < 2; ++i) {
            new PreImageThread(this._handler).Start();
        }
    }

    public void Destoy() {
        this._bRunning = false;
    }

    synchronized ImageItem PopTask() {
        int i;
        if (this._nLastPostion != this._nCurPostion) {
            this._nCurPostion = this._nLastPostion;
            this._nStartPosition = this._nCurPostion - N_IMAGE_SIZE / 2;
            if (this._nStartPosition < 0) {
                this._nStartPosition = 0;
            }
            this._nEndPosition = this._nStartPosition + N_IMAGE_SIZE;
            if (this._nEndPosition > this._fileList.size()) {
                this._nEndPosition = this._fileList.size();
            }
            for (int i2 = this._nStartPosition; i2 < this._nEndPosition; ++i2) {
                int j = i2 % N_IMAGE_SIZE;
                ImageItem item = this._tags[j];
                if (item.nPosiotion != i2) {
                    item.nPosiotion = i2;
                    ImageItem taskItem = new ImageItem();
                    taskItem.nImageIndex = j;
                    taskItem.nPosiotion = i2;
                    System.out.println("TEST_ADD0:" + i2 + "  " + j);
                    int nTaskCount = this._tasks.size();
                    if (nTaskCount > 0) {
                        int k;
                        for (k = nTaskCount - 1; k > 0 && this._tasks.get((int)k).nPosiotion > i2; --k) {
                        }
                        this._tasks.add(++k, taskItem);
                        continue;
                    }
                    this._tasks.add(taskItem);
                    continue;
                }
                System.out.println("TEST_ADD1:" + i2 + "  " + j);
            }
        }
        if (this._nDealBmpCount > 16 || this._tasks.isEmpty()) {
            return null;
        }
        int nFind = this._nLastPostion - this._nOnePage - 4;
        if (nFind < 0) {
            nFind = 0;
        }
        ImageItem item = null;
        for (i = 0; i < this._tasks.size(); ++i) {
            item = this._tasks.get(i);
            if (item.nPosiotion < this._nStartPosition || item.nPosiotion >= this._nEndPosition) {
                this._tasks.remove(i);
                System.out.println("TEST_DEL:" + item.nPosiotion + "  " + item.nImageIndex);
                item = null;
                continue;
            }
            if (item.nPosiotion >= nFind) break;
        }
        if (this._tasks.isEmpty()) {
            return null;
        }
        if (i >= this._tasks.size()) {
            i = 0;
        }
        item = this._tasks.get(i);
        this._tasks.remove(i);
        System.out.println("TEST_ADD2:" + item.nPosiotion + " Last:" + this._nLastPostion + " page:" + this._nOnePage);
        return item;
    }

    public void SetSelectedListener(OnSelectedImageListener listener) {
        this._listener = listener;
    }

    public void SetDefultBmp(Bitmap defBmp) {
        this._defBmp = defBmp;
    }

    public int UpdateList(String dir, String type, String query) {
        File[] file;
        this._fileList.clear();
        File baseFile = new File(dir);
        if (baseFile != null && baseFile.exists() && (file = baseFile.listFiles()) != null) {
            for (int i = file.length - 1; i > -1; --i) {
                String path = file[i].getPath();
                if (!file[i].isFile() || !path.endsWith(type) || !query.equals("") && !file[i].getName().contains(query)) continue;
                this._fileList.add(path);
            }
        }
        this.notifyDataSetChanged();
        if (this._fileList.size() > 0) {
            this._images[0].setTag((Object)this._fileList.get(0));
        }
        return this._fileList.size();
    }

    public static Bitmap LoadImage(String url) {
        try {
            FileInputStream fis = new FileInputStream(url);
            return BitmapFactory.decodeStream((InputStream)fis);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Bitmap LoadImage(String pathName, int reqWidth, int reqHeight) {
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)opts);
        opts.inSampleSize = XImagesAdapter.GetSampleSize(opts.outWidth, opts.outHeight, reqWidth, reqHeight);
        opts.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)opts);
    }

    public static int GetSampleSize(int srcWidth, int srcHeight, int reqWidth, int reqHeight) {
        int inSampleSize = 1;
        if (srcHeight > reqHeight || srcWidth > reqWidth) {
            inSampleSize = srcWidth > srcHeight ? Math.round((float)srcHeight / (float)reqHeight) : Math.round((float)srcWidth / (float)reqWidth);
        }
        return inSampleSize;
    }

    public int getCount() {
        return this._fileList.size();
    }

    public Object getItem(int position) {
        return position;
    }

    public long getItemId(int position) {
        return position;
    }

    View GetImageViewByFileName(String fileName) {
        for (int i = 0; i < N_IMAGE_SIZE; ++i) {
            String curName = (String)this._images[i].getTag();
            if (curName == null || !fileName.equals(curName)) continue;
            return this._images[i];
        }
        return null;
    }

    String GetImageFileName(int index) {
        String fileName = this._fileList.get(index);
        if (!fileName.endsWith(".bmp") && !fileName.endsWith(".jpg")) {
            fileName = fileName.substring(0, fileName.length() - 3) + "jpg";
        }
        return fileName;
    }

    public View getView(int nPosition, View view, ViewGroup viewgroup) {
        System.out.println("TEST_AA:" + nPosition);
        View iv = this._images[nPosition % N_IMAGE_SIZE];
        iv.setOnClickListener((View.OnClickListener)this);
        if (nPosition != 0) {
            this._nLastPostion = nPosition;
        }
        return iv;
    }

    void OnSelected(ImageView iv) {
        iv.setAlpha(196);
        if (this._listener != null) {
            this._listener.OnSelectedImage((View)iv);
        }
    }

    public void onClick(View v) {
        this.OnSelected((ImageView)v);
    }

    public static Bitmap getImageThumbnail(String imagePath, int width, int height) {
        Bitmap bitmap = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        bitmap = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        options.inJustDecodeBounds = false;
        int h = options.outHeight;
        int w = options.outWidth;
        if (width <= 0) {
            width = w;
        }
        if (height <= 0) {
            height = h;
        }
        int beWidth = w / width;
        int beHeight = h / height;
        int be = 1;
        be = beWidth < beHeight ? beWidth : beHeight;
        if (be <= 0) {
            be = 1;
        }
        options.inSampleSize = be;
        bitmap = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        bitmap = ThumbnailUtils.extractThumbnail((Bitmap)bitmap, (int)width, (int)height, (int)2);
        return bitmap;
    }

    public static Bitmap getVideoThumbnail(String videoPath, int width, int height, int kind) {
        Bitmap bitmap = null;
        bitmap = ThumbnailUtils.createVideoThumbnail((String)videoPath, (int)kind);
        System.out.println("w" + bitmap.getWidth());
        System.out.println("h" + bitmap.getHeight());
        bitmap = ThumbnailUtils.extractThumbnail((Bitmap)bitmap, (int)width, (int)height, (int)2);
        return bitmap;
    }

    class ImageItem {
        Bitmap bmp = null;
        int nPosiotion = 0;
        int nImageIndex = 0;

        ImageItem() {
        }
    }

    class PreImageThread
    extends Thread {
        Handler _handler;

        public PreImageThread(Handler handler) {
            this._handler = handler;
        }

        public void Start() {
            this.start();
        }

        @Override
        public void run() {
            while (XImagesAdapter.this._bRunning) {
                ImageItem item = XImagesAdapter.this.PopTask();
                if (item == null) {
                    try {
                        Thread.sleep(4L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (item.nPosiotion < XImagesAdapter.this._nStartPosition || item.nPosiotion > XImagesAdapter.this._nEndPosition) {
                    item = null;
                    continue;
                }
                String path = XImagesAdapter.this.GetImageFileName(item.nPosiotion);
                File file = new File(path);
                if (file.isFile()) {
                    item.bmp = XImagesAdapter.getImageThumbnail(path, 180, 180);
                    if (item.bmp != null) {
                        ++XImagesAdapter.this._nDealBmpCount;
                        Message message = new Message();
                        message.what = 1;
                        message.obj = item;
                        this._handler.sendMessage(message);
                    } else {
                        item.bmp = null;
                        item = null;
                    }
                }
                Object var3_4 = null;
            }
        }
    }
}

