/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.TextView;
import demo.xm.com.libxmfunsdk.R;

public class SpinnerSelectItem
extends FrameLayout
implements View.OnTouchListener {
    private TextView tvTitle;
    private Spinner spinner;
    private TextView tvTip;
    private TextView tvRight;
    private LinearLayout llContent;
    private String title;
    private String tip;
    private String right;
    private float leftPadding;
    private float rightPadding;
    private int originTitleColor;
    private int originTipColor;
    private int originRightColor;
    private OnItemSelectedListener mOnItemSelectedListener;
    private boolean SpinnerIsTouched;

    public SpinnerSelectItem(Context context) {
        this(context, null);
    }

    public SpinnerSelectItem(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SpinnerSelectItem(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.SpinnerSelectItem);
        int tipStyle = ta.getInt(R.styleable.SpinnerSelectItem_tip_style, 0);
        this.title = ta.getString(R.styleable.SpinnerSelectItem_title);
        this.tip = ta.getString(R.styleable.SpinnerSelectItem_tip);
        this.right = ta.getString(R.styleable.SpinnerSelectItem_right_text);
        this.leftPadding = ta.getDimension(R.styleable.SpinnerSelectItem_left_padding, (float)this.dp2px(15));
        this.rightPadding = ta.getDimension(R.styleable.SpinnerSelectItem_right_padding, (float)this.dp2px(15));
        ta.recycle();
        LayoutInflater.from((Context)context).inflate(R.layout.funsdk_larhone_spinner_list_select_item, (ViewGroup)this, true);
        this.tvTitle = (TextView)this.findViewById(R.id.tv_ssi_title);
        this.spinner = (Spinner)this.findViewById(R.id.spinner_ssi);
        this.tvTip = tipStyle == 0 ? (TextView)this.findViewById(R.id.tv_ssi_tip_2) : (TextView)this.findViewById(R.id.tv_ssi_tip_1);
        this.tvRight = (TextView)this.findViewById(R.id.tv_ssi_right);
        this.llContent = (LinearLayout)this.findViewById(R.id.ll_content);
        this.spinner.setOnTouchListener((View.OnTouchListener)this);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.llContent != null) {
            this.llContent.setPadding((int)this.leftPadding, this.llContent.getPaddingTop(), (int)this.rightPadding, this.llContent.getPaddingBottom());
        }
        if (this.title != null) {
            this.tvTitle.setText((CharSequence)this.title);
        }
        if (this.tip != null) {
            this.tvTip.setVisibility(0);
            this.tvTip.setText((CharSequence)this.tip);
        }
        if (this.right != null) {
            this.spinner.setVisibility(8);
            this.tvRight.setVisibility(0);
            this.tvRight.setText((CharSequence)this.right);
        }
        this.originTitleColor = this.tvTitle.getCurrentTextColor();
        this.originTipColor = this.tvTip.getCurrentTextColor();
        this.originRightColor = this.tvRight.getCurrentTextColor();
    }

    public TextView getTitle() {
        return this.tvTitle;
    }

    public TextView getTip() {
        return this.tvTip;
    }

    public Spinner getSpinner() {
        return this.spinner;
    }

    public TextView getTvRight() {
        return this.tvRight;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.originTitleColor = this.tvTitle.getCurrentTextColor();
            this.originTipColor = this.tvTip.getCurrentTextColor();
            this.originRightColor = this.tvRight.getCurrentTextColor();
        }
        this.tvTitle.setEnabled(enabled);
        this.tvTip.setEnabled(enabled);
        this.tvRight.setEnabled(enabled);
        this.spinner.setEnabled(enabled);
        this.tvTitle.setTextColor(enabled ? this.originTitleColor : this.getResources().getColor(R.color.line_color));
        this.tvTip.setTextColor(enabled ? this.originTipColor : this.getResources().getColor(R.color.line_color));
        this.tvRight.setTextColor(enabled ? this.originRightColor : this.getResources().getColor(R.color.line_color));
    }

    private int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void setOnItemSelectedListener(OnItemSelectedListener listener) {
        this.mOnItemSelectedListener = listener;
        if (null != this.spinner) {
            this.spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                    if (null != SpinnerSelectItem.this.mOnItemSelectedListener) {
                        SpinnerSelectItem.this.mOnItemSelectedListener.onItemSelected((ViewGroup)SpinnerSelectItem.this, parent, view, position, id2, SpinnerSelectItem.this.SpinnerIsTouched);
                        SpinnerSelectItem.this.SpinnerIsTouched = false;
                    }
                }

                public void onNothingSelected(AdapterView<?> parent) {
                }
            });
        }
    }

    public void setSelection(int position) {
        if (this.spinner != null) {
            this.spinner.setSelection(position);
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.SpinnerIsTouched = true;
            }
        }
        return false;
    }

    public int getSelectedItemPosition() {
        if (this.spinner != null) {
            return this.spinner.getSelectedItemPosition();
        }
        return -1;
    }

    public static interface OnItemSelectedListener {
        public void onItemSelected(ViewGroup var1, AdapterView<?> var2, View var3, int var4, long var5, boolean var7);
    }
}

