/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import demo.xm.com.libxmfunsdk.R;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class RotateView
extends View {
    private int srcId;
    private Path.Direction direction;
    private Paint paint;
    private ScheduledExecutorService service;
    private float degrees;
    private float accumulation;
    private Bitmap bitmap;
    private long runTimes;

    public RotateView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public RotateView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public RotateView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle) {
        this.initAttributes(attrs, defStyle);
    }

    private void initAttributes(AttributeSet attrs, int defStyle) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.RotateView, defStyle, 0);
        this.srcId = typedArray.getResourceId(R.styleable.RotateView_android_src, -1);
        typedArray.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setFilterBitmap(true);
        if (this.srcId != 0) {
            this.bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.srcId);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.bitmap != null) {
            if (this.direction == Path.Direction.CCW) {
                canvas.rotate(this.degrees, (float)this.getWidth() * 1.0f / 2.0f, (float)this.getHeight() * 1.0f / 2.0f);
                if (Math.abs(this.degrees) >= 100.0f) {
                    this.runTimes = 20L;
                    this.accumulation = 10.0f;
                    this.direction = Path.Direction.CW;
                    this.stop();
                    this.service = Executors.newScheduledThreadPool(1);
                    this.service.scheduleAtFixedRate(new RotateRunable(), 10L, this.runTimes, TimeUnit.MILLISECONDS);
                }
            } else {
                canvas.rotate(this.degrees, (float)this.getWidth() * 1.0f / 2.0f, (float)this.getHeight() * 1.0f / 2.0f);
            }
            canvas.drawBitmap(this.bitmap, 0.0f, 0.0f, this.paint);
        }
    }

    public void start() {
        this.stop();
        this.runTimes = 100L;
        this.accumulation = 10.0f;
        this.direction = Path.Direction.CCW;
        this.service = Executors.newScheduledThreadPool(1);
        this.service.scheduleAtFixedRate(new RotateRunable(), 10L, this.runTimes, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.service != null) {
            this.service.shutdown();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    private int measureWidth(int measureSpec) {
        if (this.bitmap != null) {
            int result = 0;
            int specMode = View.MeasureSpec.getMode((int)measureSpec);
            int specSize = View.MeasureSpec.getSize((int)measureSpec);
            if (specMode == 0x40000000) {
                result = specSize;
            } else {
                result = this.bitmap.getWidth() + this.getPaddingLeft() + this.getPaddingRight();
                if (specMode == Integer.MIN_VALUE) {
                    result = Math.min(result, specSize);
                }
            }
            return result;
        }
        return 0;
    }

    private int measureHeight(int measureSpec) {
        if (this.bitmap != null) {
            int result = 0;
            int specMode = View.MeasureSpec.getMode((int)measureSpec);
            int specSize = View.MeasureSpec.getSize((int)measureSpec);
            if (specMode == 0x40000000) {
                result = specSize;
            } else {
                result = this.bitmap.getHeight() + this.getPaddingTop() + this.getPaddingBottom();
                if (specMode == Integer.MIN_VALUE) {
                    result = Math.min(result, specSize);
                }
            }
            return result;
        }
        return 0;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stop();
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 8) {
            this.stop();
        } else if (visibility == 0) {
            this.start();
        }
    }

    class RotateRunable
    implements Runnable {
        RotateRunable() {
        }

        @Override
        public void run() {
            if (RotateView.this.direction == Path.Direction.CCW) {
                RotateView.this.degrees -= RotateView.this.accumulation;
            } else {
                RotateView.this.degrees += RotateView.this.accumulation;
                RotateView.this.degrees %= 360.0f;
            }
            RotateView.this.postInvalidate();
        }
    }
}

