/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.SeekBar;
import com.utils.XUtils;
import demo.xm.com.libxmfunsdk.R;

public class ColorSeekBar
extends SeekBar
implements SeekBar.OnSeekBarChangeListener {
    private int[] pixels;
    private Drawable mThumbDrawable;
    private OnColorSeekBarChangeListener mOnColorSeekBarChangeLs;

    public ColorSeekBar(Context context) {
        super(context);
        this.init(null, 0);
    }

    public ColorSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public ColorSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    private void init(AttributeSet attrs, int defStyle) {
        this.initAttributes(attrs, defStyle);
        this.setOnSeekBarChangeListener(this);
    }

    private void initAttributes(AttributeSet attrs, int defStyle) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ColorSeekBar, defStyle, 0);
        typedArray.recycle();
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        if (null != this.mOnColorSeekBarChangeLs) {
            int colorId = this.getColorVal();
            this.mOnColorSeekBarChangeLs.onColorChanged(seekBar, colorId, fromUser);
        }
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
    }

    public void setOnColorSeekBarChangeListener(OnColorSeekBarChangeListener ls) {
        this.mOnColorSeekBarChangeLs = ls;
    }

    public void setThumb(Drawable thumb) {
        super.setThumb(thumb);
        this.mThumbDrawable = thumb;
    }

    public int getColorVal() {
        if (null == this.pixels) {
            return -1;
        }
        int color2 = this.pixels[this.mThumbDrawable.getBounds().centerX()];
        return color2;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.pixels == null) {
            this.pixels = XUtils.getButtonPixels((View)this);
        }
    }

    public synchronized void setProgress(int progress) {
        super.setProgress(progress);
        if (this.mOnColorSeekBarChangeLs != null) {
            int colorId = this.getColorVal();
            this.mOnColorSeekBarChangeLs.onColorChanged(this, colorId, false);
        }
    }

    public void setBackgroundResource(int resid) {
        super.setBackgroundResource(resid);
        this.pixels = XUtils.getButtonPixels((View)this);
    }

    public static interface OnColorSeekBarChangeListener {
        public void onColorChanged(SeekBar var1, int var2, boolean var3);
    }
}

