/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.os.Handler;
import android.os.Looper;
import android.os.Vibrator;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;
import com.utils.BaseThreadPool;
import com.utils.TimeUtils;
import com.xm.ui.widget.drawgeometry.model.GeometryPoints;
import com.xm.ui.widget.drawgeometry.utils.GeometryUtils;

public class ClockView
extends View {
    private GeometryPoints pointsCircle;
    private int pointRadius = 50;
    private String showTimeInfo;
    private float time;
    private float curAngle;
    private boolean isNeedVibrate;

    public ClockView(Context context) {
        super(context);
    }

    public ClockView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ClockView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public ClockView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Paint paint = new Paint();
        paint.setColor(-1);
        paint.setAntiAlias(true);
        Path path = this.getCirclePath(new GeometryPoints((float)(this.getWidth() / 2), (float)(this.getHeight() / 2)), 0.3f, 100.0f, 3, 100.0f);
        canvas.drawPath(path, paint);
        paint.setTextSize(150.0f);
        this.showTimeInfo = TimeUtils.formatTimes((int)((int)this.time));
        float textHeightOffset = -(paint.ascent() + paint.descent()) * 0.5f;
        float textWidth = paint.measureText(this.showTimeInfo);
        canvas.drawText(this.showTimeInfo, ((float)this.getWidth() - textWidth) / 2.0f, (float)(this.getHeight() / 2) + textHeightOffset, paint);
        paint.setColor(-65536);
        canvas.drawCircle(this.pointsCircle.x, this.pointsCircle.y, (float)this.pointRadius, paint);
    }

    private Path getCirclePath(GeometryPoints centerPoints, float lineWidth, float lineHeight, int angleCount, float padding) {
        Path path = new Path();
        path.reset();
        float circleAngle = (float)GeometryUtils.getAngle((double)(this.pointsCircle.x - centerPoints.x), (double)(this.pointsCircle.y - centerPoints.y));
        for (int i = 0; i <= 360; i += angleCount) {
            float afterPadding = padding;
            float angle = ((float)i + lineWidth + 360.0f) % 360.0f;
            if (Math.abs(circleAngle - angle) <= 15.0f) {
                afterPadding = padding - (15.0f - Math.abs(circleAngle - angle)) * 3.0f;
            } else if (360.0f - Math.abs(circleAngle - angle) <= 15.0f) {
                afterPadding = padding - (15.0f - (360.0f - Math.abs(circleAngle - angle))) * 3.0f;
            }
            GeometryPoints geometryPoints = GeometryUtils.getSameAngleDifferRadius((float)angle, (float)(centerPoints.x - lineHeight - padding), (GeometryPoints)centerPoints);
            path.moveTo(geometryPoints.x, geometryPoints.y);
            angle = ((float)i - lineWidth + 360.0f) % 360.0f;
            geometryPoints = GeometryUtils.getSameAngleDifferRadius((float)angle, (float)(centerPoints.x - lineHeight - padding), (GeometryPoints)centerPoints);
            path.lineTo(geometryPoints.x, geometryPoints.y);
            angle = ((float)i - lineWidth - 0.5f + 360.0f) % 360.0f;
            geometryPoints = GeometryUtils.getSameAngleDifferRadius((float)angle, (float)(centerPoints.x - afterPadding), (GeometryPoints)centerPoints);
            path.lineTo(geometryPoints.x, geometryPoints.y);
            angle = ((float)i + lineWidth + 0.5f + 360.0f) % 360.0f;
            geometryPoints = GeometryUtils.getSameAngleDifferRadius((float)angle, (float)(centerPoints.x - afterPadding), (GeometryPoints)centerPoints);
            path.lineTo(geometryPoints.x, geometryPoints.y);
            angle = ((float)i + lineWidth + 360.0f) % 360.0f;
            geometryPoints = GeometryUtils.getSameAngleDifferRadius((float)angle, (float)(centerPoints.x - lineHeight - padding), (GeometryPoints)centerPoints);
            path.lineTo(geometryPoints.x, geometryPoints.y);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                if (GeometryUtils.isRotate((GeometryPoints)new GeometryPoints(event.getX(), event.getY()), (GeometryPoints)this.pointsCircle)) {
                    this.stopCountDown();
                    return true;
                }
                return false;
            }
            case 2: {
                float angle = (float)GeometryUtils.getAngle((double)(event.getX() - (float)(this.getWidth() / 2)), (double)(event.getY() - (float)(this.getHeight() / 2)));
                float time = this.time;
                if (angle - this.curAngle % 360.0f > 300.0f) {
                    if (time < 10.0f) break;
                    this.curAngle -= 360.0f - angle;
                }
                this.curAngle = angle < 100.0f && this.curAngle % 360.0f > 300.0f ? (this.curAngle += angle) : (this.curAngle += angle - this.curAngle % 360.0f);
                time = this.curAngle / 6.0f;
                if (time < 0.0f) {
                    time = 0.0f;
                }
                if ((int)this.time != (int)time) {
                    this.pointsCircle = GeometryUtils.getSameAngleDifferRadius((float)angle, (float)((float)(this.getWidth() / 2 - this.pointRadius) - 200.0f), (GeometryPoints)new GeometryPoints((float)(this.getWidth() / 2), (float)(this.getHeight() / 2)));
                    if ((int)time % 2 == 0) {
                        this.vibrate();
                    }
                    this.postInvalidate();
                }
                ClockView clockView = this;
                synchronized (clockView) {
                    this.time = time;
                }
                System.out.println("angle:" + angle + "  curAngle:" + this.curAngle);
                break;
            }
            case 1: 
            case 3: {
                if (!(this.time > 0.0f)) break;
                this.startCountDown();
                break;
            }
        }
        return super.onTouchEvent(event);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.setBackgroundColor(-16777216);
        this.pointsCircle = new GeometryPoints((float)(this.getWidth() / 2), 200.0f + (float)((this.getHeight() - this.getWidth()) / 2 + this.pointRadius));
    }

    private void vibrate() {
        Vibrator vibrator = (Vibrator)this.getContext().getSystemService("vibrator");
        vibrator.vibrate(40L);
    }

    private void startCountDown() {
        BaseThreadPool.getInstance().doTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    ClockView.access$010(ClockView.this);
                }
                if (ClockView.this.time >= 0.0f) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            float angle = ClockView.this.time * 6.0f % 360.0f;
                            ClockView.this.pointsCircle = GeometryUtils.getSameAngleDifferRadius((float)angle, (float)((float)(ClockView.this.getWidth() / 2 - ClockView.this.pointRadius) - 200.0f), (GeometryPoints)new GeometryPoints((float)(ClockView.this.getWidth() / 2), (float)(ClockView.this.getHeight() / 2)));
                            ClockView.this.postInvalidate();
                        }
                    });
                } else {
                    ClockView.this.stopCountDown();
                }
            }
        }, 1L, 1L);
    }

    private void stopCountDown() {
        BaseThreadPool.getInstance().cancelTask();
    }

    static /* synthetic */ float access$010(ClockView x0) {
        float f = x0.time;
        x0.time = f - 1.0f;
        return f;
    }
}

