/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import demo.xm.com.libxmfunsdk.R;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class BatteryView
extends View {
    public static final int UPDATE_CHARGE_PROGRESS_TIME = 500;
    public static final int UPDATE_LOADING_PROGRESS_TIME = 300;
    public static final int UNCHARGED = 0;
    public static final int CHARGING = 1;
    public static final int FULL_POWER = 2;
    private Paint mFillPaint;
    private Paint mLoadingPaint;
    private Paint mLightningPaint;
    private Paint mTextPaint;
    private float mProgress = 0.0f;
    private float mMaxProgress = 100.0f;
    private int mLevel = 0;
    private int mMaxLevel = 6;
    private int mProgressType;
    private Context mContext;
    private Bitmap mBackgroundBitmap;
    private Bitmap mEleLowBgBitmap;
    private int mFillColor;
    private int mFillLowColor;
    private int mBatteryLow;
    private boolean mbBatteryLow;
    private float mFramePadding;
    private boolean mIsCharging = false;
    private boolean mIsLoading = true;
    private ValueAnimator mProgressAnimation;
    private float mCenterX;
    private float mCenterY;
    private Path mLightningPath;
    private Point[] mLoadingPoints;
    private int mLoadingPosition;
    private ScheduledExecutorService mBatteryService;
    private BatteryTask mBatteryTask;
    private Rect mChargeRect = new Rect();

    public BatteryView(Context context) {
        super(context);
    }

    public BatteryView(Context context, AttributeSet set) {
        super(context, set);
        this.mContext = context;
        this.initData(set);
    }

    private void initData(AttributeSet set) {
        TypedArray mTypedArray = this.mContext.obtainStyledAttributes(set, R.styleable.BatteryView);
        this.mMaxProgress = mTypedArray.getInteger(R.styleable.BatteryView_battery_max, 100);
        this.mProgress = mTypedArray.getInteger(R.styleable.BatteryView_progress_now, 0);
        this.mLevel = mTypedArray.getInteger(R.styleable.BatteryView_battery_level, 0);
        this.mMaxLevel = mTypedArray.getInteger(R.styleable.BatteryView_battery_max_level, 6);
        this.mProgressType = mTypedArray.getInteger(R.styleable.BatteryView_progress_type, 0);
        this.mBackgroundBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)mTypedArray.getResourceId(R.styleable.BatteryView_battery_background, R.drawable.battery_normal_bg));
        this.mEleLowBgBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.battery_low_bg);
        this.mFillColor = mTypedArray.getInteger(R.styleable.BatteryView_fill_color, this.mContext.getResources().getColor(R.color.makingrecord_qing));
        this.mFillLowColor = mTypedArray.getInteger(R.styleable.BatteryView_fill_low_color, -65536);
        this.mBatteryLow = mTypedArray.getInteger(R.styleable.BatteryView_progress_low, 10);
        this.mFramePadding = mTypedArray.getDimension(R.styleable.BatteryView_frame_padding, 0.0f);
        mTypedArray.recycle();
        this.mFillPaint = new Paint();
        this.mFillPaint.setAntiAlias(true);
        this.mFillPaint.setTextAlign(Paint.Align.CENTER);
        this.mFillPaint.setColor(this.mFillColor);
        this.mFillPaint.setStyle(Paint.Style.FILL);
        this.mLightningPaint = new Paint();
        this.mLightningPaint.setAntiAlias(true);
        this.mLightningPaint.setColor(-1);
        this.mLightningPaint.setStyle(Paint.Style.FILL);
        this.mTextPaint = new Paint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setColor(-1);
        this.mLightningPath = new Path();
        this.mLightningPath.moveTo((float)this.mBackgroundBitmap.getWidth() / 6.0f, (float)this.mBackgroundBitmap.getHeight() / 2.0f);
        this.mLightningPath.lineTo((float)this.mBackgroundBitmap.getWidth() * 5.0f / 12.0f, (float)this.mBackgroundBitmap.getHeight() / 2.0f);
        this.mLightningPath.lineTo((float)this.mBackgroundBitmap.getWidth() / 2.0f, (float)this.mBackgroundBitmap.getHeight() * 3.0f / 4.0f);
        this.mLightningPath.lineTo((float)this.mBackgroundBitmap.getWidth() * 5.0f / 6.0f, (float)this.mBackgroundBitmap.getHeight() / 2.0f);
        this.mLightningPath.lineTo((float)this.mBackgroundBitmap.getWidth() * 7.0f / 12.0f, (float)this.mBackgroundBitmap.getHeight() / 2.0f);
        this.mLightningPath.lineTo((float)this.mBackgroundBitmap.getWidth() / 2.0f, (float)this.mBackgroundBitmap.getHeight() / 4.0f);
        this.mLightningPath.lineTo((float)this.mBackgroundBitmap.getWidth() / 6.0f, (float)this.mBackgroundBitmap.getHeight() / 2.0f);
        this.startLoading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharging(boolean isCharging) {
        BatteryView batteryView = this;
        synchronized (batteryView) {
            if (isCharging && this.mIsLoading) {
                this.stopLoading();
                this.mIsLoading = false;
            }
            if (isCharging && !this.mIsCharging) {
                this.mIsCharging = isCharging;
                this.startCharge();
            } else if (!isCharging && this.mIsCharging) {
                this.mIsCharging = isCharging;
                this.stopCharge();
            }
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mIsLoading) {
            this.mLoadingPaint.setAntiAlias(true);
            this.mLoadingPaint.setStyle(Paint.Style.STROKE);
            for (Point point : this.mLoadingPoints) {
                canvas.drawCircle((float)point.x, (float)point.y, 2.0f, this.mLoadingPaint);
            }
            this.mLoadingPaint.setStyle(Paint.Style.FILL);
            canvas.drawCircle((float)this.mLoadingPoints[this.mLoadingPosition].x, (float)this.mLoadingPoints[this.mLoadingPosition].y, 2.0f, this.mLoadingPaint);
            canvas.drawBitmap(this.mBackgroundBitmap, this.mCenterX, this.mCenterY, this.mLoadingPaint);
        } else if (!this.mIsCharging) {
            float scale = this.mProgress / 100.0f;
            float left = this.mCenterX + this.mFramePadding;
            float top = this.mCenterY + this.mFramePadding;
            float right = ((float)this.mBackgroundBitmap.getWidth() - 2.5f * this.mFramePadding) * scale + this.mFramePadding + this.mCenterX;
            float bottom = (float)this.mBackgroundBitmap.getHeight() - this.mFramePadding + this.mCenterY;
            canvas.drawRect(left, top, right, bottom, this.mFillPaint);
            canvas.drawBitmap(this.mbBatteryLow ? this.mEleLowBgBitmap : this.mBackgroundBitmap, this.mCenterX, this.mCenterY, this.mFillPaint);
        } else {
            this.mFillPaint.setColor(this.mFillColor);
            canvas.drawRect(this.mChargeRect, this.mFillPaint);
            canvas.drawBitmap(this.mBackgroundBitmap, this.mCenterX, this.mCenterY, this.mFillPaint);
        }
        float textHeightOffset = -(this.mTextPaint.ascent() + this.mTextPaint.descent()) * 0.5f;
        float textWidth = this.mTextPaint.measureText((int)this.mProgress + "%");
        canvas.drawText((int)this.mProgress + "%", ((float)this.mBackgroundBitmap.getWidth() - textWidth) / 2.0f, (float)(this.mBackgroundBitmap.getHeight() / 2) + textHeightOffset, this.mTextPaint);
    }

    public synchronized void setProgress(int progress) {
        if (progress < 0 && this.mProgress == 0.0f) {
            return;
        }
        if (progress > 100 && this.mProgress == 100.0f) {
            return;
        }
        this.mProgressAnimation = ValueAnimator.ofFloat((float[])new float[]{this.mProgress, progress});
        this.mProgressAnimation.setDuration(600L);
        this.mProgressAnimation.setStartDelay(0L);
        this.mProgressAnimation.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.mProgressAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                if (BatteryView.this.mProgress < 0.0f) {
                    BatteryView.this.mProgress = 0.0f;
                }
                if (BatteryView.this.mProgress > 100.0f) {
                    BatteryView.this.mProgress = 100.0f;
                }
                BatteryView.this.mProgress = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                if (BatteryView.this.mProgress <= (float)BatteryView.this.mBatteryLow) {
                    BatteryView.this.mFillPaint.setColor(BatteryView.this.mFillLowColor);
                } else {
                    BatteryView.this.mFillPaint.setColor(BatteryView.this.mFillColor);
                }
                BatteryView.this.invalidate();
            }
        });
        this.mProgressAnimation.start();
        if (this.mIsLoading) {
            this.stopLoading();
            this.mIsLoading = false;
        }
    }

    public synchronized void setLevel(int level) {
        if (level < 0 || level > this.mMaxLevel) {
            return;
        }
        this.mLevel = level;
        switch (this.mLevel) {
            case 0: {
                this.mbBatteryLow = true;
                this.mFillPaint.setColor(this.mFillLowColor);
                this.mProgress = 0.0f;
                break;
            }
            case 1: {
                this.mbBatteryLow = false;
                this.mFillPaint.setColor(this.mFillLowColor);
                this.mProgress = 10.0f;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.mbBatteryLow = false;
                this.mFillPaint.setColor(this.mFillColor);
                this.mProgress = 20 * (this.mLevel - 1);
                break;
            }
            case 6: {
                this.mbBatteryLow = false;
                this.mFillPaint.setColor(this.mFillColor);
                this.mProgress = this.mIsCharging ? 90.0f : 100.0f;
                break;
            }
            case 7: {
                this.mbBatteryLow = false;
                this.mFillPaint.setColor(this.mFillColor);
                this.mProgress = 100.0f;
                break;
            }
            default: {
                this.mbBatteryLow = true;
                this.mFillPaint.setColor(this.mFillLowColor);
                this.mProgress = 0.0f;
            }
        }
        if (this.mIsLoading) {
            this.stopLoading();
            this.mIsLoading = false;
        }
        this.invalidate();
    }

    public int getBatteryState() {
        if (this.mProgress == 100.0f) {
            return 2;
        }
        if (this.mIsCharging) {
            return 1;
        }
        return 0;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mCenterX = (float)(w - this.mBackgroundBitmap.getWidth()) / 2.0f;
        this.mCenterY = (float)(h - this.mBackgroundBitmap.getHeight()) / 2.0f;
    }

    protected void onDetachedFromWindow() {
        this.stopCharge();
        super.onDetachedFromWindow();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    private int measureWidth(int measureSpec) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = this.mBackgroundBitmap.getWidth() + this.getPaddingLeft() + this.getPaddingRight();
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    private int measureHeight(int measureSpec) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = this.mBackgroundBitmap.getHeight() + this.getPaddingTop() + this.getPaddingBottom();
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoading() {
        BatteryView batteryView = this;
        synchronized (batteryView) {
            this.mLoadingPaint = new Paint();
            this.mLoadingPaint.setAntiAlias(true);
            this.mLoadingPaint.setTextAlign(Paint.Align.CENTER);
            this.mLoadingPaint.setColor(-1);
            this.mLoadingPaint.setStyle(Paint.Style.FILL);
            this.mLoadingPaint.setTextSize(10.0f);
            this.mLoadingPoints = new Point[3];
            this.mLoadingPoints[0] = new Point((int)((float)this.mBackgroundBitmap.getWidth() / 4.0f), (int)((float)this.mBackgroundBitmap.getHeight() / 2.0f));
            this.mLoadingPoints[1] = new Point((int)((float)this.mBackgroundBitmap.getWidth() / 2.0f), (int)((float)this.mBackgroundBitmap.getHeight() / 2.0f));
            this.mLoadingPoints[2] = new Point((int)((float)this.mBackgroundBitmap.getWidth() * 3.0f / 4.0f), (int)((float)this.mBackgroundBitmap.getHeight() / 2.0f));
            if (this.mBatteryService != null && this.mBatteryService != null) {
                this.mBatteryService.shutdown();
                this.mBatteryService = null;
                this.mBatteryTask = null;
            }
            this.mBatteryTask = new BatteryTask();
            this.mBatteryService = Executors.newScheduledThreadPool(1);
            this.mBatteryService.scheduleAtFixedRate(this.mBatteryTask, 0L, 300L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopLoading() {
        BatteryView batteryView = this;
        synchronized (batteryView) {
            this.mIsLoading = false;
            if (this.mBatteryService != null && this.mBatteryService != null) {
                this.mBatteryService.shutdown();
                this.mBatteryService = null;
                this.mBatteryTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCharge() {
        BatteryView batteryView = this;
        synchronized (batteryView) {
            float scale = this.mProgress / 100.0f;
            this.mChargeRect = new Rect((int)(this.mCenterX + this.mFramePadding), (int)(this.mCenterY + this.mFramePadding), (int)(((float)this.mBackgroundBitmap.getWidth() - 2.5f * this.mFramePadding) * scale + this.mFramePadding + this.mCenterX), (int)((float)this.mBackgroundBitmap.getHeight() - this.mFramePadding + this.mCenterY));
            if (this.mBatteryService != null && this.mBatteryService != null) {
                this.mBatteryService.shutdown();
                this.mBatteryService = null;
                this.mBatteryTask = null;
            }
            this.mBatteryTask = new BatteryTask();
            this.mBatteryService = Executors.newScheduledThreadPool(1);
            this.mBatteryService.scheduleAtFixedRate(this.mBatteryTask, 500L, 500L, TimeUnit.MILLISECONDS);
            this.mIsLoading = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopCharge() {
        BatteryView batteryView = this;
        synchronized (batteryView) {
            this.mIsCharging = false;
            if (this.mBatteryService != null && this.mBatteryService != null) {
                this.mBatteryService.shutdown();
                this.mBatteryService = null;
                this.mBatteryTask = null;
            }
        }
    }

    private void drawCharge() {
        int width = (int)((float)this.mBackgroundBitmap.getWidth() - 2.5f * this.mFramePadding + this.mFramePadding + this.mCenterX);
        this.mChargeRect.right = this.mChargeRect.right < width ? (this.mChargeRect.right += 5) : (int)(((float)this.mBackgroundBitmap.getWidth() - 2.5f * this.mFramePadding) * (this.mProgress / 100.0f) + this.mFramePadding + this.mCenterX);
        this.mChargeRect.right = this.mChargeRect.right > width ? width : this.mChargeRect.right;
        this.postInvalidate();
    }

    private void drawLoading() {
        this.mLoadingPosition = (this.mLoadingPosition + 1) % 3;
        this.postInvalidate();
    }

    class BatteryTask
    implements Runnable {
        BatteryTask() {
        }

        @Override
        public void run() {
            if (BatteryView.this.mIsLoading) {
                BatteryView.this.drawLoading();
            } else if (BatteryView.this.mIsCharging) {
                BatteryView.this.drawCharge();
            }
        }
    }
}

