/*
 * Decompiled with CFR 0.152.
 */
package com.xm.activity.device.monitor.presenter;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.lib.MsgContent;
import com.lib.sdk.bean.SensorInfoBean;
import com.lib.sdk.struct.MultiLensParam;
import com.lib.sdk.struct.SDBDeviceInfo;
import com.lib.sdk.struct.SDK_FishEyeFrame;
import com.manager.db.DevDataCenter;
import com.manager.device.DeviceManager;
import com.manager.device.config.PwdErrorManager;
import com.manager.device.config.SensorManager;
import com.manager.device.media.MediaManager;
import com.manager.device.media.attribute.PlayerAttribute;
import com.manager.device.media.monitor.MonitorManager;
import com.utils.PathUtils;
import com.video.opengl.OnPlayViewTouchListener;
import com.xm.activity.base.XMBasePresenter;
import com.xm.activity.device.monitor.contract.XMMonitorContract;
import com.xm.ui.dialog.XMPromptDlg;
import java.io.File;
import java.util.ArrayList;

public class XMMonitorPresenter
extends XMBasePresenter<DeviceManager>
implements XMMonitorContract.IXMMonitorPresenter,
MediaManager.OnMediaManagerListener,
MediaManager.OnFrameInfoListener,
SensorManager.OnSensorChangeListener {
    private MonitorManager monitorManager;
    private MonitorManager extraMonitorManager;
    private SensorManager sensorManager;
    private XMMonitorContract.IXMMonitorView ixmMonitorView;
    private float curScale;
    private int changeSensorId = -1;
    private int curSensorId;
    private boolean isScalePrepare = false;
    private int streamType = 1;
    private float needChangeScale = 1.6f;

    public XMMonitorPresenter(XMMonitorContract.IXMMonitorView ixmMonitorView) {
        this.ixmMonitorView = ixmMonitorView;
    }

    @Override
    protected DeviceManager getManager() {
        return DeviceManager.getInstance();
    }

    @Override
    public void setDevId(String devId) {
        super.setDevId(devId);
        this.sensorManager = SensorManager.getInstance(this);
    }

    @Override
    public void initMonitorPlayer(ViewGroup surfaceView, ViewGroup extraSurfaceView) {
        this.monitorManager = ((DeviceManager)this.manager).createMonitorPlayer(surfaceView, this.getDevId());
        this.monitorManager.setPlayStateTipsEnable(true);
        this.monitorManager.setStreamType(this.streamType);
        this.monitorManager.setOnMediaManagerListener(this);
        this.monitorManager.setOnFrameInfoListener(this);
        this.monitorManager.setOnPlayViewTouchListener(new OnPlayViewTouchListener(){

            public void onScale(float fingerScale, float imgScale, View v, MotionEvent event) {
            }

            public void onTrans(float x, float y) {
            }

            public void onBoundary(boolean isLeft, boolean isRight) {
            }
        });
        this.extraMonitorManager = ((DeviceManager)this.manager).createMonitorPlayer(extraSurfaceView, this.getDevId());
        this.extraMonitorManager.setStreamType(this.streamType);
        this.extraMonitorManager.setOnMediaManagerListener(this);
    }

    @Override
    public void startMonitor() {
        this.monitorManager.startMonitor();
    }

    @Override
    public void pauseMonitor() {
        this.monitorManager.pausePlay();
        this.extraMonitorManager.pausePlay();
    }

    @Override
    public void stopMonitor() {
        this.monitorManager.stopPlay();
        this.extraMonitorManager.stopPlay();
    }

    @Override
    public void destroyMonitor() {
        this.monitorManager.destroyPlay();
        this.extraMonitorManager.destroyPlay();
    }

    @Override
    public void capture() {
        String imgPath = this.monitorManager.capture(PathUtils.getAndroidPath((Context)this.ixmMonitorView.getActivity()) + File.separator);
    }

    @Override
    public void setScale(float scale) {
        if (scale > this.curScale) {
            this.curScale = scale;
            if (scale >= this.needChangeScale) {
                if (this.changeSensorId != 1) {
                    this.changeSensorId = 1;
                    this.sensorManager.switchSensor(this.getDevId(), this.changeSensorId, this.streamType, -1);
                    this.isScalePrepare = false;
                }
            } else {
                this.isScalePrepare = true;
            }
        } else if (scale < this.curScale) {
            this.curScale = scale;
            if (scale < this.needChangeScale) {
                if (this.changeSensorId != 0) {
                    this.changeSensorId = 0;
                    this.sensorManager.switchSensor(this.getDevId(), this.changeSensorId, this.streamType, -1);
                    this.isScalePrepare = false;
                }
            } else {
                this.isScalePrepare = true;
            }
        }
        if (this.curSensorId == this.changeSensorId) {
            this.monitorManager.setScale(this.curScale % this.needChangeScale + 1.0f);
            this.sensorManager.switchSensor(this.getDevId(), this.changeSensorId, this.streamType, -1);
        }
    }

    @Override
    public void changeStream() {
        this.monitorManager.stopPlay();
        this.monitorManager.setStreamType(this.monitorManager.getStreamType() == 0 ? 1 : 0);
        this.monitorManager.startMonitor();
    }

    @Override
    public boolean isFishCtrlShow() {
        return this.monitorManager != null && this.monitorManager.isFishCtrlLayoutShow();
    }

    @Override
    public void hideFishCtrlShow() {
        if (this.monitorManager != null) {
            this.monitorManager.closeFishCtrl();
        }
    }

    @Override
    public void onMediaPlayState(PlayerAttribute attribute, int state) {
        this.ixmMonitorView.onPlayState(state);
        if (state == 19) {
            if (this.ixmMonitorView != null) {
                this.ixmMonitorView.onCaptureResult(attribute.getTempSaveImagePath());
            }
        } else if (state == 0) {
            this.sensorManager.getSensor(attribute.getDevId(), this.streamType, -1);
        }
    }

    @Override
    public void onFailed(PlayerAttribute attribute, int msgId, int errorId) {
        if (errorId == -11301) {
            SDBDeviceInfo deviceInfo = DevDataCenter.getInstance().getDevInfo(this.getDevId()).getSdbDevInfo();
            XMPromptDlg.onShowPasswordErrorDialog(this.ixmMonitorView.getActivity(), deviceInfo, msgId, new PwdErrorManager.OnRepeatSendMsgListener(){

                @Override
                public void onSendMsg(int msgId) {
                    XMMonitorPresenter.this.startMonitor();
                }
            });
        }
    }

    @Override
    public void onShowRateAndTime(PlayerAttribute attribute, boolean isShowTime, String time, long rate) {
    }

    @Override
    public void onVideoBufferEnd(PlayerAttribute attribute, MsgContent ex) {
    }

    @Override
    public void onPlayStateClick(View view) {
    }

    @Override
    public void onFrameInfo(PlayerAttribute attribute, SDK_FishEyeFrame fishEyeFrame) {
        if (attribute.getStreamType() == this.streamType && fishEyeFrame instanceof MultiLensParam) {
            this.curSensorId = ((MultiLensParam)fishEyeFrame).st_1_sensorMain;
            if (this.changeSensorId == -1) {
                this.changeSensorId = this.curSensorId;
                float scale = (float)this.curSensorId * this.needChangeScale;
                if (this.ixmMonitorView != null) {
                    this.ixmMonitorView.onVideoScaleResult(scale);
                }
            } else if (this.curSensorId == this.changeSensorId) {
                this.monitorManager.setScale(this.curScale % this.needChangeScale + 1.0f);
            }
        }
    }

    @Override
    public void onGetSensorResult(String devId, int chnId, SensorInfoBean sensorInfoBean) {
    }

    @Override
    public void onSetSensorResult(String devId, boolean isSuccess) {
    }

    @Override
    public void onInitSensor(String devId, ArrayList<Float> sensorFLs) {
    }

    @Override
    public void onSetScaleResult(String devId, float scale, boolean isSuccess) {
    }
}

