/*
 * Decompiled with CFR 0.152.
 */
package com.xm.activity.device.devset.ability.presenter;

import android.content.Context;
import com.lib.sdk.bean.HandleConfigData;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.bean.SystemFunctionBean;
import com.lib.sdk.struct.SDBDeviceInfo;
import com.manager.db.DevDataCenter;
import com.manager.db.XMDevInfo;
import com.manager.device.DeviceManager;
import com.manager.device.config.DevConfigInfo;
import com.manager.device.config.DevConfigManager;
import com.manager.device.config.PwdErrorManager;
import com.xm.activity.base.XMBasePresenter;
import com.xm.activity.device.devset.ability.contract.XMDevAbilityContract;
import com.xm.activity.device.devset.ability.data.AbilityInfo;
import com.xm.ui.dialog.XMPromptDlg;
import demo.xm.com.libxmfunsdk.R;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class XMDevAbilityPresenter
extends XMBasePresenter<DeviceManager>
implements XMDevAbilityContract.IXMDevAbilityPresenter {
    private DevConfigManager devConfigManager;
    private SystemFunctionBean systemFunctionBean;
    private List<AbilityInfo> abilityInfos;
    private XMDevAbilityContract.IXMDevAbilityView ixmDevAbilityView;

    public XMDevAbilityPresenter(XMDevAbilityContract.IXMDevAbilityView ixmDevAbilityView) {
        this.ixmDevAbilityView = ixmDevAbilityView;
        this.abilityInfos = new ArrayList<AbilityInfo>();
    }

    @Override
    protected DeviceManager getManager() {
        return DeviceManager.getInstance();
    }

    @Override
    public void setDevId(String devId) {
        super.setDevId(devId);
        this.devConfigManager = ((DeviceManager)this.manager).getDevConfigManager(devId);
    }

    @Override
    public void updateDevAbility() {
        DevConfigInfo devConfigInfo2 = DevConfigInfo.create(new DeviceManager.OnDevManagerListener(){

            public void onSuccess(String devId, int operationType, Object jsonData) {
                HandleConfigData handleConfigData;
                if (!StringUtils.isStringNULL((String)jsonData) && (handleConfigData = new HandleConfigData()).getDataObj((String)jsonData, SystemFunctionBean.class)) {
                    Field[] fields;
                    XMDevAbilityPresenter.this.systemFunctionBean = (SystemFunctionBean)handleConfigData.getObj();
                    for (Field field : fields = XMDevAbilityPresenter.this.systemFunctionBean.getClass().getDeclaredFields()) {
                        try {
                            Field[] childFields;
                            Object obj = field.get(XMDevAbilityPresenter.this.systemFunctionBean);
                            if (obj == null) continue;
                            System.out.println("name:" + obj.getClass().getSimpleName());
                            for (Field childField : childFields = obj.getClass().getFields()) {
                                Object childObj = childField.get(obj);
                                AbilityInfo abilityInfo = new AbilityInfo();
                                abilityInfo.setParentName(obj.getClass().getSimpleName());
                                abilityInfo.setChildName(childField.getName());
                                abilityInfo.setEnable((Boolean)childObj);
                                XMDevAbilityPresenter.this.abilityInfos.add(abilityInfo);
                            }
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                    Collections.sort(XMDevAbilityPresenter.this.abilityInfos, new Comparator<AbilityInfo>(){

                        @Override
                        public int compare(AbilityInfo lhs, AbilityInfo rhs) {
                            return lhs.getChildName().compareTo(rhs.getChildName());
                        }
                    });
                    XMDevAbilityPresenter.this.ixmDevAbilityView.onUpdateDevAbilityResult(true);
                }
            }

            @Override
            public void onFailed(String devId, int msgId, String jsonName, int errorId) {
                if (errorId == -11301) {
                    SDBDeviceInfo deviceInfo;
                    XMDevInfo xmDevInfo = DevDataCenter.getInstance().getDevInfo(XMDevAbilityPresenter.this.getDevId());
                    if (xmDevInfo != null && (deviceInfo = xmDevInfo.getSdbDevInfo()) != null) {
                        XMPromptDlg.onShowPasswordErrorDialog(XMDevAbilityPresenter.this.ixmDevAbilityView.getActivity(), deviceInfo, msgId, new PwdErrorManager.OnRepeatSendMsgListener(){

                            @Override
                            public void onSendMsg(int msgId) {
                                XMDevAbilityPresenter.this.updateDevAbility();
                            }
                        });
                    }
                } else {
                    String tips = XMDevAbilityPresenter.this.ixmDevAbilityView.getActivity().getString(R.string.libfunsdk_operation_failed) + ":" + errorId;
                    XMPromptDlg.onShow((Context)XMDevAbilityPresenter.this.ixmDevAbilityView.getActivity(), tips, null);
                }
            }
        }, new String[0]);
        devConfigInfo2.setJsonName("SystemFunction");
        devConfigInfo2.setChnId(-1);
        this.devConfigManager.getDevConfig(devConfigInfo2);
    }

    @Override
    public int getAbilityCount() {
        return this.abilityInfos == null ? 0 : this.abilityInfos.size();
    }

    @Override
    public AbilityInfo getAbilityEnable(int position) {
        if (this.abilityInfos != null && position < this.abilityInfos.size()) {
            AbilityInfo abilityInfo = this.abilityInfos.get(position);
            return abilityInfo;
        }
        return null;
    }
}

