/*
 * Decompiled with CFR 0.152.
 */
package com.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.DhcpInfo;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.basic.G;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.struct.SDBDeviceInfo;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class XMWifiManager {
    public static final String TAG = XMWifiManager.class.getSimpleName();
    public static final int TYPE_NO_PASSWD = 1;
    public static final int TYPE_WEP = 2;
    public static final int TYPE_WPA = 3;
    private List<ScanResult> wifiList = new ArrayList<ScanResult>();
    private List<WifiConfiguration> wifiConfiguration;
    private WifiManager wifiManager;
    private WifiInfo wifiInfo;
    private WifiManager.WifiLock wifiLock;
    private DhcpInfo dhcpInfo;
    private ConnectivityManager connManager;
    private static XMWifiManager instance;
    private int wifiNumber = 0;
    private static final int MAX_PRIORITY = 999999;

    private XMWifiManager(Context context) {
        if (null != context) {
            this.wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            this.connManager = (ConnectivityManager)context.getSystemService("connectivity");
            this.wifiInfo = this.wifiManager.getConnectionInfo();
        } else {
            instance = null;
        }
    }

    public static synchronized XMWifiManager getInstance(Context context) {
        if (instance == null) {
            instance = new XMWifiManager(context);
        }
        return instance;
    }

    public boolean isWiFiEnabled() {
        return this.wifiManager == null ? false : this.wifiManager.isWifiEnabled();
    }

    public boolean openWifi() {
        if (!this.wifiManager.isWifiEnabled()) {
            if (this.wifiManager.setWifiEnabled(true)) {
                this.startScan(0, 1000);
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public void closeWifi() {
        if (this.wifiManager.isWifiEnabled()) {
            this.wifiManager.setWifiEnabled(false);
        }
    }

    public int checkState() {
        return this.wifiManager.getWifiState();
    }

    public void acquireWifiLock() {
        this.wifiLock.acquire();
    }

    public void releaseWifiLock() {
        if (this.wifiLock.isHeld()) {
            this.wifiLock.acquire();
        }
    }

    public void creatWifiLock() {
        this.wifiLock = this.wifiManager.createWifiLock("Test");
    }

    public List<WifiConfiguration> getConfiguration() {
        return this.wifiConfiguration;
    }

    public void connectConfiguration(int index) {
        if (index > this.wifiConfiguration.size()) {
            return;
        }
        this.enableNetwork(this.wifiConfiguration.get((int)index).networkId, true);
    }

    public void startScan(int type, int timeout) {
        boolean scan;
        boolean bl = scan = this.wifiManager == null ? false : this.wifiManager.startScan();
        if (!scan) {
            return;
        }
        SystemClock.sleep((long)timeout);
        this.wifiNumber = 0;
        List wifiList = this.wifiManager.getScanResults();
        if (wifiList != null) {
            this.wifiNumber = wifiList.size();
        }
        this.wifiConfiguration = this.wifiManager.getConfiguredNetworks();
        if (this.wifiList != null && wifiList != null) {
            this.wifiList.clear();
            if (type == 1) {
                for (ScanResult result : wifiList) {
                    if (!XMWifiManager.isXMDeviceWifi(result.SSID)) continue;
                    this.wifiList.add(result);
                }
            } else if (type == 2) {
                for (ScanResult result : wifiList) {
                    if (XMWifiManager.isXMDeviceWifi(result.SSID) || result.SSID.equals("")) continue;
                    this.wifiList.add(result);
                }
            } else {
                this.wifiList = wifiList;
            }
        }
    }

    public ScanResult getCurScanResult(String ssid) {
        this.wifiNumber = 0;
        this.wifiManager.startScan();
        List wifiList = this.wifiManager.getScanResults();
        if (wifiList != null) {
            this.wifiNumber = wifiList.size();
        }
        ScanResult scanResult = null;
        if (wifiList != null && ssid != null) {
            for (ScanResult result : wifiList) {
                String tmpSSID = result.SSID.trim();
                if (tmpSSID.startsWith("\"") && tmpSSID.endsWith("\"")) {
                    tmpSSID = tmpSSID.substring(1, tmpSSID.length() - 1);
                }
                if (!StringUtils.contrast(tmpSSID, ssid)) continue;
                if (result.frequency > 4900 && result.frequency < 5900) {
                    scanResult = result;
                    continue;
                }
                return result;
            }
        }
        return scanResult;
    }

    public void getCurScanResult(final String ssid, final OnCurScanResultListener listener) {
        this.wifiNumber = 0;
        this.wifiManager.startScan();
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                List wifiList = XMWifiManager.this.wifiManager.getScanResults();
                if (wifiList != null) {
                    XMWifiManager.this.wifiNumber = wifiList.size();
                }
                ScanResult scanResult = null;
                if (wifiList != null && ssid != null) {
                    for (ScanResult result : wifiList) {
                        String tmpSSID = result.SSID.trim();
                        if (tmpSSID.startsWith("\"") && tmpSSID.endsWith("\"")) {
                            tmpSSID = tmpSSID.substring(1, tmpSSID.length() - 1);
                        }
                        System.out.println("scanResult:" + tmpSSID + result.frequency);
                        if (!StringUtils.contrast(tmpSSID, ssid)) continue;
                        if (result.frequency > 4900 && result.frequency < 5900) {
                            scanResult = result;
                            continue;
                        }
                        scanResult = result;
                        break;
                    }
                }
                if (listener != null) {
                    listener.onResult(scanResult);
                }
            }
        }, 2000L);
    }

    public List<ScanResult> getWifiList() {
        return this.wifiList;
    }

    public boolean isWifiConnect() {
        NetworkInfo ni = this.connManager.getActiveNetworkInfo();
        return ni != null && ni.isConnectedOrConnecting();
    }

    public StringBuilder lookUpScan() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.wifiList.size(); ++i) {
            stringBuilder.append("Index_" + new Integer(i + 1).toString() + ":");
            stringBuilder.append(this.wifiList.get(i).toString());
            stringBuilder.append("/n");
        }
        return stringBuilder;
    }

    public String getMacAddress() {
        return this.wifiManager == null ? "NULL" : this.wifiManager.getConnectionInfo().getMacAddress();
    }

    public String getBSSID() {
        return this.wifiManager == null ? "NULL" : this.wifiManager.getConnectionInfo().getBSSID();
    }

    public String getSSID() {
        if (this.wifiList == null) {
            return null;
        }
        String ssid = this.wifiManager.getConnectionInfo().getSSID();
        if (ssid != null && ssid.startsWith("\"")) {
            ssid = ssid.substring(1, ssid.length() - 1);
        }
        return ssid;
    }

    public DhcpInfo getDhcpInfo() {
        this.dhcpInfo = this.wifiManager.getDhcpInfo();
        return this.dhcpInfo;
    }

    public String getIPAddress() {
        int ipAddress = 0;
        String ip = null;
        if (this.wifiManager != null) {
            ipAddress = this.wifiManager.getConnectionInfo().getIpAddress();
            if (ipAddress == 0) {
                return null;
            }
            ip = (ipAddress & 0xFF) + "." + (ipAddress >> 8 & 0xFF) + "." + (ipAddress >> 16 & 0xFF) + "." + (ipAddress >> 24 & 0xFF);
            return ip;
        }
        return null;
    }

    public int getNetworkId() {
        return this.wifiManager == null ? 0 : this.wifiManager.getConnectionInfo().getNetworkId();
    }

    public int getLinkSpeed() {
        return this.wifiManager == null ? 0 : this.wifiManager.getConnectionInfo().getLinkSpeed();
    }

    public WifiInfo getWifiInfo() {
        this.wifiInfo = this.wifiManager == null ? null : this.wifiManager.getConnectionInfo();
        return this.wifiInfo;
    }

    public boolean addNetwork(WifiConfiguration wcg) {
        int wcgID = -1;
        if (null == wcg) {
            return false;
        }
        boolean benable = false;
        wcgID = wcg.networkId >= 0 ? wcg.networkId : this.wifiManager.addNetwork(wcg);
        int newPri = 10000;
        if (newPri >= 999999) {
            newPri = this.shiftPriorityAndSave();
        }
        wcg.priority = newPri;
        this.wifiManager.updateNetwork(wcg);
        this.wifiManager.saveConfiguration();
        benable = this.enableNetwork(wcgID, true);
        return benable;
    }

    private boolean connectWifiByReflectMethod(int netId) {
        if (netId < 0) {
            return false;
        }
        Method connectMethod = null;
        if (Build.VERSION.SDK_INT >= 17) {
            Log.i((String)TAG, (String)"connectWifiByReflectMethod road 1");
            for (Method methodSub : this.wifiManager.getClass().getDeclaredMethods()) {
                Class<?>[] types;
                if (!"connect".equalsIgnoreCase(methodSub.getName()) || (types = methodSub.getParameterTypes()) == null || types.length <= 0 || !"int".equalsIgnoreCase(types[0].getName())) continue;
                connectMethod = methodSub;
            }
            if (connectMethod != null) {
                try {
                    connectMethod.invoke((Object)this.wifiManager, netId, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.i((String)TAG, (String)("connectWifiByReflectMethod Android " + Build.VERSION.SDK_INT + " error!"));
                    return false;
                }
            }
        } else if (Build.VERSION.SDK_INT == 16) {
            Log.i((String)TAG, (String)"connectWifiByReflectMethod road 2");
        } else if (Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT < 16) {
            Log.i((String)TAG, (String)"connectWifiByReflectMethod road 3");
            for (Method methodSub : this.wifiManager.getClass().getDeclaredMethods()) {
                Class<?>[] types;
                if (!"connectNetwork".equalsIgnoreCase(methodSub.getName()) || (types = methodSub.getParameterTypes()) == null || types.length <= 0 || !"int".equalsIgnoreCase(types[0].getName())) continue;
                connectMethod = methodSub;
            }
            if (connectMethod != null) {
                try {
                    connectMethod.invoke((Object)this.wifiManager, netId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.i((String)TAG, (String)("connectWifiByReflectMethod Android " + Build.VERSION.SDK_INT + " error!"));
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean enableNetwork(int netId, boolean disableOthers) {
        return this.connectWifiByReflectMethod(netId) ? true : this.wifiManager.enableNetwork(netId, disableOthers);
    }

    public boolean enableNetwork(String ssid) {
        boolean state = false;
        List list = this.wifiManager.getConfiguredNetworks();
        if (list != null && list.size() > 0) {
            for (WifiConfiguration i : list) {
                if (i.SSID == null || !i.SSID.equals(XMWifiManager.convertToQuotedString(ssid))) continue;
                this.wifiManager.disconnect();
                int newPri = this.getMaxPriority() + 1;
                if (newPri >= 999999) {
                    newPri = this.shiftPriorityAndSave();
                }
                i.priority = newPri;
                this.wifiManager.updateNetwork(i);
                this.wifiManager.saveConfiguration();
                state = this.enableNetwork(i.networkId, true);
                this.wifiManager.reconnect();
                break;
            }
        }
        return state;
    }

    private int getMaxPriority() {
        List configurations = this.wifiManager.getConfiguredNetworks();
        int pri = 0;
        for (WifiConfiguration config : configurations) {
            if (config.priority <= pri) continue;
            pri = config.priority;
        }
        return pri;
    }

    private void sortByPriority(List<WifiConfiguration> configurations) {
        Collections.sort(configurations, new Comparator<WifiConfiguration>(){

            @Override
            public int compare(WifiConfiguration object1, WifiConfiguration object2) {
                return object1.priority - object2.priority;
            }
        });
    }

    private int shiftPriorityAndSave() {
        List configurations = this.wifiManager.getConfiguredNetworks();
        this.sortByPriority(configurations);
        int size = configurations.size();
        int i = 0;
        while (i < size) {
            WifiConfiguration config = (WifiConfiguration)configurations.get(i);
            config.priority = i++;
            this.wifiManager.updateNetwork(config);
        }
        this.wifiManager.saveConfiguration();
        return size;
    }

    public static String convertToQuotedString(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "";
        }
        int lastPos = string2.length() - 1;
        if (lastPos > 0 && string2.charAt(0) == '\"' && string2.charAt(lastPos) == '\"') {
            return string2;
        }
        return "\"" + string2 + "\"";
    }

    public void disconnectWifi(int netId) {
        this.wifiManager.disableNetwork(netId);
        this.wifiManager.disconnect();
    }

    public boolean disconnect() {
        boolean benable = this.wifiManager.disconnect();
        System.out.println("disconnect--" + benable);
        return benable;
    }

    public WifiConfiguration createWifiInfo(String SSID, String Password) {
        return this.createWifiInfo(SSID, Password, this.getCipherType(SSID));
    }

    public WifiConfiguration createWifiInfoNoUseExsit(String SSID, String Password, int Type2) {
        WifiConfiguration config = new WifiConfiguration();
        config.allowedAuthAlgorithms.clear();
        config.allowedGroupCiphers.clear();
        config.allowedKeyManagement.clear();
        config.allowedPairwiseCiphers.clear();
        config.allowedProtocols.clear();
        config.SSID = "\"" + SSID + "\"";
        if (Type2 == 1) {
            config.wepKeys[0] = "\"\"";
            config.status = 2;
            config.allowedKeyManagement.set(0);
            config.wepTxKeyIndex = 0;
        }
        if (Type2 == 2) {
            config.hiddenSSID = true;
            config.wepKeys[0] = "\"" + Password + "\"";
            config.allowedAuthAlgorithms.set(1);
            config.allowedGroupCiphers.set(3);
            config.allowedGroupCiphers.set(2);
            config.allowedGroupCiphers.set(0);
            config.allowedGroupCiphers.set(1);
            config.allowedKeyManagement.set(0);
            config.wepTxKeyIndex = 0;
        }
        if (Type2 == 3) {
            config.preSharedKey = "\"" + Password + "\"";
            config.hiddenSSID = false;
            config.allowedAuthAlgorithms.set(0);
            config.allowedGroupCiphers.set(2);
            config.allowedKeyManagement.set(1);
            config.allowedPairwiseCiphers.set(1);
            config.allowedGroupCiphers.set(3);
            config.allowedPairwiseCiphers.set(2);
            config.status = 2;
        }
        return config;
    }

    public WifiConfiguration createWifiInfo(String SSID, String Password, int Type2) {
        WifiConfiguration config = new WifiConfiguration();
        config.allowedAuthAlgorithms.clear();
        config.allowedGroupCiphers.clear();
        config.allowedKeyManagement.clear();
        config.allowedPairwiseCiphers.clear();
        config.allowedProtocols.clear();
        config.SSID = "\"" + SSID + "\"";
        WifiConfiguration tempConfig = this.isExsits(SSID);
        if (tempConfig != null) {
            this.enableNetwork(tempConfig.networkId, false);
            return tempConfig;
        }
        if (Type2 == 1) {
            config.wepKeys[0] = "\"\"";
            config.status = 2;
            config.allowedKeyManagement.set(0);
            config.wepTxKeyIndex = 0;
        }
        if (Type2 == 2) {
            config.hiddenSSID = true;
            config.wepKeys[0] = "\"" + Password + "\"";
            config.allowedAuthAlgorithms.set(1);
            config.allowedGroupCiphers.set(3);
            config.allowedGroupCiphers.set(2);
            config.allowedGroupCiphers.set(0);
            config.allowedGroupCiphers.set(1);
            config.allowedKeyManagement.set(0);
            config.wepTxKeyIndex = 0;
        }
        if (Type2 == 3) {
            config.preSharedKey = "\"" + Password + "\"";
            config.hiddenSSID = false;
            config.allowedAuthAlgorithms.set(0);
            config.allowedGroupCiphers.set(2);
            config.allowedKeyManagement.set(1);
            config.allowedPairwiseCiphers.set(1);
            config.allowedGroupCiphers.set(3);
            config.allowedPairwiseCiphers.set(2);
            config.status = 2;
        }
        return config;
    }

    public boolean removeNetWork(String ssid) {
        WifiConfiguration tempConfig = this.isExsits(ssid);
        if (tempConfig != null && XMWifiManager.isXMDeviceWifi(ssid)) {
            this.wifiManager.removeNetwork(tempConfig.networkId);
            this.wifiManager.saveConfiguration();
            return true;
        }
        return false;
    }

    private WifiConfiguration isExsits(String ssid) {
        String dealWithSsid = "\"" + ssid + "\"";
        List existingConfigs = this.wifiManager.getConfiguredNetworks();
        if (existingConfigs == null) {
            return null;
        }
        for (WifiConfiguration existingConfig : existingConfigs) {
            if (!ssid.equals(existingConfig.SSID) && !dealWithSsid.equals(existingConfig.SSID)) continue;
            return existingConfig;
        }
        return null;
    }

    public boolean isSSIDExist(String ssid) {
        this.wifiManager.startScan();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (ScanResult result : this.wifiManager.getScanResults()) {
            if (!result.SSID.equals(ssid)) continue;
            return true;
        }
        return false;
    }

    public String getConfiguredNetwork() {
        return this.wifiManager == null ? null : this.wifiManager.getConnectionInfo().getSSID();
    }

    public static boolean isXMDeviceWifi(String ssid) {
        if (StringUtils.isStringNULL(ssid)) {
            return false;
        }
        return XMWifiManager.isStartsWith(ssid, "robot_") || XMWifiManager.isStartsWith(ssid, "Robot_") || XMWifiManager.isStartsWith(ssid, "card_") || XMWifiManager.isStartsWith(ssid, "car_") || XMWifiManager.isStartsWith(ssid, "seye_") || XMWifiManager.isStartsWith(ssid, "NVR_") || XMWifiManager.isStartsWith(ssid, "DVR_") || XMWifiManager.isStartsWith(ssid, "beye_") || XMWifiManager.isStartsWith(ssid, "IPC_") || XMWifiManager.isStartsWith(ssid, "IPC") || XMWifiManager.isStartsWith(ssid, "Car") || XMWifiManager.isStartsWith(ssid, "BOB_") || XMWifiManager.isStartsWith(ssid, "socket_") || XMWifiManager.isStartsWith(ssid, "xmjp_") || XMWifiManager.isStartsWith(ssid, "feye_") || XMWifiManager.isStartsWith(ssid, "bullet_") || XMWifiManager.isStartsWith(ssid, "drum_") || XMWifiManager.isStartsWith(ssid, "camera_") || XMWifiManager.isStartsWith(ssid, "Camera_") || XMWifiManager.isStartsWith(ssid, "ipc") || XMWifiManager.isStartsWith(ssid, "dev_cz_idr_");
    }

    public static int getXMDeviceAPType(String ssid) {
        if (!XMWifiManager.isXMDeviceWifi(ssid)) {
            return -1;
        }
        if (XMWifiManager.isStartsWith(ssid, "xmjp_idr") || XMWifiManager.isStartsWith(ssid, "idr") || XMWifiManager.isStartsWith(ssid, "dev_cz_idr_")) {
            return 21;
        }
        if (XMWifiManager.isStartsWith(ssid, "robot_") || XMWifiManager.isStartsWith(ssid, "Robot_") || XMWifiManager.isStartsWith(ssid, "NVR_") || XMWifiManager.isStartsWith(ssid, "DVR_") || XMWifiManager.isStartsWith(ssid, "IPC_") || XMWifiManager.isStartsWith(ssid, "IPC")) {
            return 0;
        }
        if (XMWifiManager.isStartsWith(ssid, "socket_") || XMWifiManager.isStartsWith(ssid, "xmjp_socket_")) {
            return 1;
        }
        if (XMWifiManager.isStartsWith(ssid, "xmjp_bulb_")) {
            return 2;
        }
        if (XMWifiManager.isStartsWith(ssid, "xmjp_bulbsocket_")) {
            return 3;
        }
        if (XMWifiManager.isStartsWith(ssid, "car_") || XMWifiManager.isStartsWith(ssid, "xmjp_car_")) {
            return 4;
        }
        if (XMWifiManager.isStartsWith(ssid, "beye_") || XMWifiManager.isStartsWith(ssid, "xmjp_beye_")) {
            return 5;
        }
        if (XMWifiManager.isStartsWith(ssid, "seye_") || XMWifiManager.isStartsWith(ssid, "xmjp_seye_")) {
            return 6;
        }
        if (XMWifiManager.isStartsWith(ssid, "xmjp_robot_")) {
            return 7;
        }
        if (XMWifiManager.isStartsWith(ssid, "xmjp_mov_") || XMWifiManager.isStartsWith(ssid, "xmjp_spt_") || XMWifiManager.isStartsWith(ssid, "GripCam_")) {
            return 8;
        }
        if (XMWifiManager.isStartsWith(ssid, "feye_") || XMWifiManager.isStartsWith(ssid, "xmjp_feye_")) {
            return 9;
        }
        if (XMWifiManager.isStartsWith(ssid, "xmjp_fbulb_")) {
            return 10;
        }
        if (XMWifiManager.isStartsWith(ssid, "xmjp_BOB_")) {
            return 11;
        }
        if (XMWifiManager.isStartsWith(ssid, "xmjp_musicbox_")) {
            return 12;
        }
        if (XMWifiManager.isStartsWith(ssid, "xmjp_speaker")) {
            return 13;
        }
        if (XMWifiManager.isStartsWith(ssid, "xmjp_dcam_")) {
            return 15;
        }
        if (XMWifiManager.isStartsWith(ssid, "xmjp_m2g_") || XMWifiManager.isStartsWith(ssid, "xmjp_maf_")) {
            return 18;
        }
        return 0;
    }

    public static boolean isStartsWith(String str1, String str2) {
        if (StringUtils.isStringNULL(str1)) {
            return false;
        }
        return str1.startsWith(str2) | str1.startsWith(str2, 1);
    }

    public void setAPDeviceInfo(SDBDeviceInfo info, String ssid) {
        if (null == info) {
            return;
        }
        int devType = XMWifiManager.getXMDeviceAPType(ssid);
        switch (devType) {
            case 1: 
            case 2: 
            case 3: {
                G.SetValue((byte[])info.st_0_Devmac, (String)"172.16.10.1:9001");
                G.SetValue((byte[])info.st_2_Devip, (String)"172.16.10.1");
                break;
            }
            default: {
                G.SetValue((byte[])info.st_0_Devmac, (String)"192.168.10.1:34567");
                G.SetValue((byte[])info.st_2_Devip, (String)"192.168.10.1");
            }
        }
        G.SetValue((byte[])info.st_1_Devname, (String)ssid);
        G.SetValue((byte[])info.st_4_loginName, (String)"admin");
        G.SetValue((byte[])info.st_5_loginPsw, (String)"");
        info.st_7_nType = devType;
    }

    public int getCipherType(String ssid) {
        for (ScanResult scResult : this.wifiList) {
            String capabilities;
            String _ssid = scResult.SSID;
            if (TextUtils.isEmpty((CharSequence)_ssid) || !_ssid.replace("\"", "").equals(ssid) || TextUtils.isEmpty((CharSequence)(capabilities = scResult.capabilities))) continue;
            if (capabilities.contains("WPA") || capabilities.contains("wpa")) {
                return 3;
            }
            if (capabilities.contains("WEP") || capabilities.contains("wep")) {
                return 3;
            }
            return 1;
        }
        return 0;
    }

    public int getWifiNumber() {
        return this.wifiNumber;
    }

    public void setWifiNumber(int wifiNumber) {
        this.wifiNumber = wifiNumber;
    }

    public static String getWiFiMacAddress() {
        try {
            ArrayList<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface nif : all) {
                if (!nif.getName().equalsIgnoreCase("wlan0")) continue;
                byte[] macBytes = nif.getHardwareAddress();
                if (macBytes == null) {
                    return "02:00:00:00:00:00";
                }
                StringBuilder res1 = new StringBuilder();
                for (byte b : macBytes) {
                    res1.append(String.format("%02X:", b));
                }
                if (res1.length() > 0) {
                    res1.deleteCharAt(res1.length() - 1);
                }
                return res1.toString();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    public static interface OnCurScanResultListener {
        public void onResult(ScanResult var1);
    }

    public static interface DEVICE_CLASSIFY {
        public static final int CLASSIFY_XMJP = 0;
        public static final int CLASSIFY_OEM = 1;
    }

    public static interface SENSOR_TYPE {
        public static final int DEV_433_DETECT = 0;
        public static final int SOCKET_TYPE = 100;
        public static final int REMOTE_TYPE = 101;
        public static final int WALLSWITCH_TYPE = 102;
        public static final int CURTAINS_TYPE = 103;
        public static final int LIGHT_TYPE = 104;
        public static final int BUTTON_TYPE = 105;
        public static final int LINKCENTER_MAGNETOMETER = 110;
        public static final int LINKCENTER_BODY_INFRARED = 111;
        public static final int LINKCENTER_WATER_IMMERSION = 112;
        public static final int LINKCENTER_ENVIRONMENT = 113;
        public static final int LINKCENTER_FUEL_GAS = 114;
        public static final int LINKCENTER_SMOKE = 115;
    }

    public static interface WIFI_TYPE {
        public static final int ALL = 0;
        public static final int DEV_AP = 1;
        public static final int ROUTER = 2;
    }
}

